forward_function cfgread, cfgcalc, save_calfile, nlines
compile_opt idl2

PRO cfgnew2fgmcal

;*************************************************************************
COMMON MATOFF,offset, offsetsc, mtrxr, mtrxdr,mtrxsc,angle,ocal,mcal
COMMON RECORD,adc,sensor,mod1,mod2,dt,scid,outboard,range,tbstr
COMMON FILES,calname,ext,version
COMMON PATH_CFG,inp,outp,slash,inidir

cfgdir='/home/FGM/cfg/'      ; contains cfgnew2fgmcal.(cfg|lst)
inidir='/home/FGM/data/ini/' ; contains cal?_?d.(cfg|neu)
;cfgdir=''

;adc=0                                           
inpcfgf=cfgdir+'cfgnew2fgmcal.cfg' 
nli=nlines(inpcfgf) & incfg=strarr(nli)
openr,11,inpcfgf & readf,11,incfg & close,11

adc=fix(strmid(incfg(2),0,1))
if strupcase(!d.name) eq 'X' then slash='/' else slash='\'
inp=strmid(incfg(0),0,rstrpos(incfg(0),slash)+1) 
outp=strmid(incfg(1),0,rstrpos(incfg(1),slash)+1)
;ext=strmid(incfg(3),0,3)
ext='neu'
if nli gt 4 then version=strmid(incfg(4),0,3) else version='V01'


lstfile=cfgdir+'cfgnew2fgmcal.lst'
nli=nlines(lstfile) & lststrarr=strarr(nli)
openr,11,lstfile & readf,11,lststrarr & close,11

for j=0,nli-1 do begin
  cfgnew_file=lststrarr(j)

  ;cfgnew_file='c1_090331_2000r2_V01.cfgnew'

  if (strmid(cfgnew_file,2,1) eq 'i') then mod1=1 else mod1=0
  mod2=strmid(cfgnew_file,15+mod1,1)
  tbstr=strmid(cfgnew_file,10+mod1,2)+':'+strmid(cfgnew_file,12+mod1,2)
  scid=strmid(cfgnew_file,1,1)
  version=strmid(cfgnew_file,17+mod1,3)
  date=strmid(cfgnew_file,3+mod1,6)
  calname='C'+scid+'_20'+date+'_'+version+'.fgmcal' 
  
  print, calname

  spawn, 'cp -f '+inp+cfgnew_file+' '+inidir+'cal'+scid+'_1d.neu'
  
  
  CFGREAD
  CFGCALC
  save_calfile

endfor

spawn, '/usr/bin/beep -f 10000 -l 10 '

END


;===========================================================
PRO cfgread

  COMMON MATOFF
  COMMON RECORD
  COMMON FILES
  COMMON PATH_CFG
  ;===========================================================
  strng = STRARR(28)
  offset = DBLARR(3,6,4)
  offsetsc = DBLARR(3,4)
  mtrxr = DBLARR(3,3,6,4)
  mtrxsc = DBLARR(3,3,4)
  mtrxdr = DBLARR(3,3,4)
  angle =  DBLARR(3,4)
  strngc = ''
  cary1 = 0.0d0
  cary2 = 0.0d0
  cary3 = 0.0d0

  ;=============================================================
  ;   READ ALL CONFIGURATION PARAMETERS
  ;   by means of a main FOR LOOP on the parameter K
  ;=============================================================
  L = 2
  FOR K=0,3 DO BEGIN
    ssensor=string(K+1,format="(i1)")
    nrranges=5
    fcfgnam=inidir+'cal'+scid+'_'+ssensor+'d.'+ext
    if file_lines(fcfgnam) gt 40 then nrranges=6
    OPENR,L, fcfgnam
    ;print, fcfgnam
    ;=============================================================
    ;  INPUT OF the OFFSETS of all ranges
    ;=============================================================
    FOR I=0,nrranges-1 DO BEGIN
      READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
      strng[I] = strngc
      offset[0,I,K] = cary1
      offset[1,I,K] = cary2
      offset[2,I,K] = cary3
    ENDFOR
    READF, L, FORMAT='(/)'
    ;=============================================================
    ;         To input the offset spacecraft matrix
    ;=============================================================
    READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
    strng[nrranges] = strngc
    offsetsc[0,K] = cary1
    offsetsc[1,K] = cary2
    offsetsc[2,K] = cary3

    READF, L, FORMAT='(/)'
    ;=============================================================
    ;  INPUT of the MATRIX_r for all ranges
    ;=============================================================
    ; The multiplication of the range factors given by Uli Ausster
    ; will be taken into consideration only at the calculation
    ; program
    ;-------------------------------------------------------------
    FOR J=0,nrranges-1 DO BEGIN
      FOR I=0,2 DO BEGIN
        READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
        strng[5] = strngc
        mtrxr[0,I,J,K] = cary1
        mtrxr[1,I,J,K] = cary2
        mtrxr[2,I,J,K] = cary3
      ENDFOR
      READF, L, FORMAT='(/)'
    ENDFOR
    ;============================================================
    ;         INPUT of the spacecraft matrix_sc
    ;===========================================================
    FOR I=0,2 DO BEGIN
      READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
      mtrxsc[0,I,K] = cary1
      mtrxsc[1,I,K] = cary2
      mtrxsc[2,I,K] = cary3
    ENDFOR
    READF, L, FORMAT='(/)'
    ;===========================================================
    ;        INPUT of the rotation matrx_dr
    ;===========================================================
    FOR I=0,2 DO BEGIN
      READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
      mtrxdr[0,I,K] = cary1
      mtrxdr[1,I,K] = cary2
      mtrxdr[2,I,K] = cary3
    ENDFOR
    READF, L, FORMAT='(/)'
    ;===========================================================
    ;    To read the angle array
    ;===========================================================
    READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
    angle[0,K] = cary1
    angle[1,K] = cary2
    angle[2,K] = cary3
    CLOSE, L
    ;==========================================================
  ENDFOR   ;To end the FOR  K loop
  ;==========================================================
END ;====End of the Configuration-READ============================


;==========================================================
PRO cfgcalc
  ;==Calculation of the Calibration Matrices and Offsets===
  COMMON  MATOFF
  PI = !dpi
  ;==(1) The Rotation matrix MROT===================================
  xymtrx = DBLARR(3,3,4)
  xzmtrx = DBLARR(3,3,4)
  yzmtrx = DBLARR(3,3,4)
  mrot = DBLARR(3,3,4)
  mcal = DBLARR(3,3,6,4)
  ocal = DBLARR(3,6,4)
  ;-----------------------------------------------------------
  FOR K=0,3 DO BEGIN
    xymtrx[0,0,K] = cos(angle[0,K]*(PI/180.d0))
    xymtrx[1,0,K] = sin(angle[0,K]*(PI/180.d0))
    xymtrx[2,0,K] = 0.d0
    ;
    xymtrx[0,1,K] = -sin(angle[0,K]*(PI/180.d0))
    xymtrx[1,1,K] = cos(angle[0,K]*(PI/180.d0))
    xymtrx[2,1,K] = 0.d0
    ;
    xymtrx[0,2,K] = 0.d0
    xymtrx[1,2,K] = 0.d0
    xymtrx[2,2,K] = 1.d0
    ;-----------------------------------------------------------
    xzmtrx[0,0,K] = cos(angle[1,K]*(PI/180.d0))
    xzmtrx[1,0,K] = 0.d0
    xzmtrx[2,0,K] = sin(angle[1,K]*(PI/180.d0))
    ;
    xzmtrx[0,1,K] = 0.d0
    xzmtrx[1,1,K] = 1.d0
    xzmtrx[2,1,K] = 0.d0
    ;
    xzmtrx[0,2,K] = -sin(angle[1,K]*(PI/180.d0))
    xzmtrx[1,2,K] = 0.d0
    xzmtrx[2,2,K] = cos(angle[1,K]*(PI/180.d0))
    ;-----------------------------------------------------------
    yzmtrx[0,0,K] = 1.d0
    yzmtrx[1,0,K] = 0.d0
    yzmtrx[2,0,K] = 0.d0
    ;
    yzmtrx[0,1,K] = 0.d0
    yzmtrx[1,1,K] = cos(angle[2,K]*(PI/180.d0))
    yzmtrx[2,1,K] = sin(angle[2,K]*(PI/180.d0))
    ;
    yzmtrx[0,2,K] = 0.d0
    yzmtrx[1,2,K] = -sin(angle[2,K]*(PI/180.d0))
    yzmtrx[2,2,K] = cos(angle[2,K]*(PI/180.d0))
    ;
    mrot[*,*,K] = yzmtrx[*,*,K] ## xzmtrx[*,*,K] ## xymtrx[*,*,K] ## mtrxdr[*,*,K]
  ENDFOR
  ;-------------------------------------------------------------
  ;==(2) The Calibration  matrix MCAL====================================
  factor = [1.0d0,1.0d0,1.0d0,1.0d0,1.0d0,1.0d0]
  FOR K=0,3 DO BEGIN
    FOR J=0,5 DO mcal[*,*,J,K] =  mrot[*,*,K] ## mtrxsc[*,*,K] ## (mtrxr[*,*,J,K]*factor[J])
  ENDFOR
    ;==(3) The Calibration Offset OCAL=====================================
  FOR K=0,3 DO BEGIN
    FOR J=0,5 DO ocal[*,J,K] = mrot[*,*,K] ## mtrxsc[*,*,K] ## offsetsc[*,K] +  $
                               mrot[*,*,K] ## mtrxsc[*,*,K] ## (mtrxr[*,*,J,K]*factor[J]) ## offset[*,J,K]
  ENDFOR
  ;-------------------------------------------------------------
  ;PRINT, ocal,mcal
  ;--Opening files to out put the OCAL and MCAL Matrices---------------------
  ;--------------------------------------------------------------
  ;OPENW,20,'ofstcal.dat' & printf,20,ocal & CLOSE,20
  ;OPENW,20,'matcal.dat' & printf,20,mcal & CLOSE,20
END;==========End of the calibrations calculations=========================




;;-----------------------------------------------------------
PRO save_calfile
  ;----To output the OCAL values in the MUENCHEN Format-------
  COMMON MATOFF
  COMMON RECORD
  COMMON FILES
  COMMON PATH_CFG

  ;; saving here range 7 calibration parameters to daily range 7 calfile 
  calf_r7=outp+strmid(calname,0,strpos(calname,'_V'))+'range7.fgmcal'
  openw,21,calf_r7
  for j=0,2 do printf,21,ocal(j,5,0)
  for l=0,2 do for j=0,2 do printf,21,mcal(j,l,5,0)
  close,21
  ;; end save range 7

  OPENW,21,outp+calname
  if adc eq 0 then PRINTF,21,'1  T24:00:00.000' else PRINTF,21,'2  T24:00:00.000'
  FOR S=0,3 DO BEGIN
    FOR J=0,2 DO BEGIN
      calvalue1 = ocal(J,0,S)
      calvalue2 = ocal(J,1,S)
      calvalue3 = ocal(J,2,S)
      calvalue4 = ocal(J,3,S)
      calvalue5 = ocal(J,4,S)
      label = STRCOMPRESS('S'+STRING(S+1)+'_0'+STRING(J+1),/REMOVE_ALL)
      fo1='(5(F14.7),3x,A5)
      PRINTF,21,FORMAT=fo1,calvalue1,calvalue2,calvalue3,calvalue4,calvalue5,label
    ENDFOR
    ;----To output the MCAL values in the MUENCHEN Format-------
    ;
    FOR L=0,2 DO BEGIN
      FOR J=0,2 DO BEGIN
        calvalue1 = mcal(J,L,0,S)
        calvalue2 = mcal(J,L,1,S)
        calvalue3 = mcal(J,L,2,S)
        calvalue4 = mcal(J,L,3,S)
        calvalue5 = mcal(J,L,4,S)
        label=STRCOMPRESS('S'+STRING(S+1)+'_'+STRING(L+1)+STRING(J+1),/REMOVE_ALL)
        PRINTF,21,FORMAT=fo1,calvalue1,calvalue2,calvalue3,calvalue4,calvalue5,label
      ENDFOR
    ENDFOR
  ENDFOR
PRINTF,21,''
PRINTF,21,'S1 = OB + ADC1, S2 = IB + ADC1, S3 = OB + ADC2, S4 = IB + ADC2'
PRINTF,21,'ranges = 2,3,4,5,6 => 64, 256, 1024, 4096, 16384 nT'
gr_text=['F9_fsr, data from ground calibration tu-bs magnetsrode 08/09 1999',$
	 'F6_fsr, data from ground calibration tu-bs magnetsrode 11 1998',$
	 'F7_fsr, data from ground calibration tu-bs magnetsrode 01/02 1999',$
	 'F8_fsr, data from ground calibration tu-bs magnetsrode 07/08 1999']
PRINTF,21,gr_text(fix(scid)-1)
sensstr=['OB','IB']
PRINTF,21,sensstr(mod1(0))+'  r',mod2(0),'  '+tbstr,format="(a,i1,a)"
PRINTF,21,calname
CLOSE,21
END;==========End of save calibration file














;---------------------------------------------------------    
FUNCTION nlines,file
;      INPUT :  filename for an ASCII file
;      OUTPUT:  number of lines
;      to be used instead spawn,'wc -l '+file for windows IDL compatibility                       
;      eg@mpe.mpg.de
;----------------------------------------------------------    
usg='USAGE : result=nlines(file)'
if n_elements(file) eq 0 then begin print,usg & return,-1 & end
if strupcase(!d.name) eq 'X' then begin
  spawn,'wc -l '+file,nrli & i=long(nrli(0)) & end else begin
  i=0l & ss=strarr(1) & openr,11,file
  while not eof(11) do begin readf,11,ss & $
       if strlen(ss(0)) gt 1 then i=i+1l & end
  close,11 & endelse
return,i
END


