;** Calibration Tool for CLUSTER
;** 13-05-2000 Tarek calibration-tool for EQS, changed by ("eg@mpe.mpg.de")
;** 20-04-2001: windows&linux, introduced sinustest for spin plane components
;** 13-11-2001: back to EQS formulae
;** 11-12-2002: unify for all 4 s/c, USAGE: cls,sc_number
;     auto name dailycalfile, rename cal*_sd.neu, copy to outpath
;     auto determine spin axis angles
;     changed widgets, fft, clus_ev, data, config_edit, ...almost everything
;** 24-06-2003: changed cfg to allow for other version number than V01
;** 11-09-2009: added 'load current', 'load from...', 'update' buttons ;;DC;;
;** 12-04-2010: added 'update -> rc offset' button ;;DC;;
;** 22-11-2010: fixed the y scale for the fft plots ;;DC;;
;** 14-01-2011: extended caltool to range 7
;                        changed common: path_cfg, editmat
;                        changed modules: cfgcalc, savecfg2file, cfg_save, cfg_edit, save_calfile
;                        cls.cfg file has now 7 lines: initpath for cal#_id.neu|cfg and logpath added
;
;** 21-01-2013: fix window size (xsi, ysi) ;;DC;;
;** 20-02-2016: added option to calibrate line 1 columns 2 and 3 matrix elements (x spin tone) ;;DC;;
;*************************************************************************
PRO clus_ev, event
;*************************************************************************
COMMON VALUES, valuex, valueyz, valueb
COMMON MATOFF, offset, offsetsc, mtrxr, mtrxdr, mtrxsc, angle, ocal, mcal
COMMON RECORD,adc,sensor,mod1,mod2,dt,scid,outboard,range,tbstr
COMMON COUNTER, count
COMMON INOUT, indata,outdata,time,spax_out
COMMON FILES,datfile,calname,ext,version,date,LOGF
COMMON PATH_CFG,inp,outp,initpath,logpath,slash
COMMON KSAVE, K2,noopen,lastsensor,icancel,nofirst,lastcfg
COMMON EDITMAT,ofst01,ofst02,ofst03,$
ofstwdgt1,ofst11,ofst12,ofst13,$
ofstwdgt2,ofst21,ofst22,ofst23,$
ofstwdgt3,ofst31,ofst32,ofst33,$
ofstwdgt4,ofst41,ofst42,ofst43,$
ofstwdgt5,ofst51,ofst52,ofst53,$
ofstwdgtsc,ofstsc1,ofstsc2,ofstsc3,$
mtrx011,mtrx012,mtrx013,mtrx021,mtrx022,mtrx023,mtrx031,mtrx032,mtrx033,$
mtrx111,mtrx112,mtrx113,mtrx121,mtrx122,mtrx123,mtrx131,mtrx132,mtrx133,$
mtrx211,mtrx212,mtrx213,mtrx221,mtrx222,mtrx223,mtrx231,mtrx232,mtrx233,$
mtrx311,mtrx312,mtrx313,mtrx321,mtrx322,mtrx323,mtrx331,mtrx332,mtrx333,$
mtrx411,mtrx412,mtrx413,mtrx421,mtrx422,mtrx423,mtrx431,mtrx432,mtrx433,$
mtrx511,mtrx512,mtrx513,mtrx521,mtrx522,mtrx523,mtrx531,mtrx532,mtrx533,$
mtrxsc11,mtrxsc12,mtrxsc13,mtrxsc21,mtrxsc22,mtrxsc23,mtrxsc31,mtrxsc32,mtrxsc33,$
mtrxdr11,mtrxdr12,mtrxdr13,mtrxdr21,mtrxdr22,mtrxdr23,mtrxdr31,mtrxdr32,mtrxdr33,$
winkel1,winkel2,winkel3

;fftxrange2=[0.001,1.]  ;The range of the frequencies plotted in the spectrum(FFTzoom) Hz
;fftyrange =[0.1,1000.]         ;The range of the PSD plotted in the spectrum(FFT,FFTzoom) pT

;WIDGET_CONTROL, default_font='7x14'
;===========================================================
WIDGET_CONTROL, event.id, GET_UVALUE = eventval
;============================================================
IF N_ELEMENTS(eventval) EQ 0 THEN RETURN
IF eventval eq 'THEMENU' THEN BEGIN                             ;To open a data File
        data
    ;if  not icancel  then  calibrate,0,0
    END
IF eventval eq 'MOFF' then begin
  free_lun, LOGF ;;DC;;
  WIDGET_CONTROL, event.top, /DESTROY
endif
if n_elements(datfile) lt 1  or strlen(datfile) lt 2 then $
    begin print,'Select inputfile first!' & return & end

IF ((eventval EQ 'BXBUTTON')  or $
    (eventval EQ 'BYZBUTTON') or $
    (eventval EQ 'BBUTTON'))  THEN show_data, eventval, event.index

titl= [  '>>OB + ADC 1<<','>>IB + ADC 1<<','>>OB + ADC 2<<','>>IB + ADC 2<<']

;;----To plot The Bx Options----------------------------------------
;titl= [  '>>OB + ADC 1<<','>>IB + ADC 1<<','>>OB + ADC 2<<','>>IB + ADC 2<<']
;k2=2*adc+outboard
;IF eventval EQ 'BXBUTTON' THEN BEGIN
;WSET, valuex
;if ((k2) mod 2) eq 1 then plotarray=indata(0,*) else plotarray=outdata(0,*)
;plotarray=transpose(plotarray) & meanbxout = mean(plotarray)
;N21 = fix(count/2)+1 & F = findgen(n21)
;F = F/(count*dt) & sfft=1000.*ABS(FFT(plotarray-meanbxout,-1))
;CASE event.index OF
;   0: plot, time*3600., plotarray,/XSTY,/YSTY, YTITLE='[nT]', XTICKFORMAT='tticks', $
;   YMARGIN=[3,2],XMARGIN=[9,1],TITLE=titl(k2)+' '+datfile
;   1: plot,F,sfft(0:n21-1),/xsty,/ysty, /ylog,XTITLE='Hz',YTITLE='Amplitude pT/sqrt(Hz)]-> Bx',$
;   YMARGIN=[3,2],XMARGIN=[9,1],TITLE=titl(k2)+' '+datfile
;    2: plot,F,sfft(0:n21-1),/xsty,/ysty, /ylog,XTITLE='Hz',YTITLE='Amplitude [pT/sqrt(Hz)]-> Bx',$
;              XRANGE=fftxrange2,YMARGIN=[3,2],XMARGIN=[9,1],$
;   TITLE=titl(k2)+' '+datfile, yrange=fftyrange
;       ELSE: MESSAGE, "NOTHING"
;  ENDCASE
;ENDIF
;;===================================================================
;;----To plot The Byz Options----------------------------------------------
;IF eventval EQ 'BYZBUTTON' THEN BEGIN
; WSET, valueyz
;if ((k2) mod 2) eq 1 then plotarray=sqrt(indata(1,*)^2+indata(2,*)^2) $
;              else plotarray= sqrt(outdata(1,*)^2+outdata(2,*)^2)
;plotarray=transpose(plotarray) & meanbxout = mean(plotarray)
;N21 = fix(count/2)+1 & F = findgen(n21)
;F = F/(count*dt) & sfft=1000.*ABS(FFT(plotarray-meanbxout,-1))
;CASE event.index OF
;   0: plot, time*3600., plotarray,/XSTY,/YSTY,YTITLE='[nT]', XTICKFORMAT='tticks', $
;   YMARGIN=[3,2],XMARGIN=[9,1],TITLE=titl(k2)+' '+datfile
;   1: plot,F,sfft(0:n21-1),/xsty,/ysty, /ylog,XTITLE='Hz',YTITLE='Amplitude [pT/sqrt(Hz)]-> Byz',$
;   YMARGIN=[3,2],XMARGIN=[9,1],TITLE=titl(k2)+' '+datfile
;    2: plot,F,sfft(0:n21-1),/xsty,/ysty, /ylog,XTITLE='Hz',YTITLE='Amplitude [pT/sqrt(Hz)]-> Byz',$
;   XRANGE=fftxrange2,YMARGIN=[3,2],XMARGIN=[9,1],$
;   TITLE=titl(k2)+' '+datfile,yrange=fftyrange
;      ELSE: MESSAGE, "NOTHING"
;  ENDCASE
;ENDIF
;;==============================================================
;;----To plot The B Options------------------------------------------
;IF eventval EQ 'BBUTTON' THEN BEGIN
; WSET, valueb
;if ((k2) mod 2) eq 1 then $
;   plotarray=sqrt((indata(0,*)^2)+(indata(1,*)^2)+(indata(2,*)^2)) $
;else   plotarray= sqrt((outdata(0,*)^2)+(outdata(1,*)^2)+(outdata(2,*)^2))
;plotarray=transpose(plotarray) & meanbxout = mean(plotarray)
;N21 = fix(count/2)+1 & F = findgen(n21)
;F = F/(count*dt) & sfft=1000.*ABS(FFT(plotarray-meanbxout,-1))
;CASE event.index OF
;   0: plot, time*3600.d0 ,plotarray, /XSTY,/YSTY,YTITLE='[nT]',XTICKFORMAT='tticks',$
;   YMARGIN=[3,2],XMARGIN=[9,1],TITLE=titl(k2)+' '+datfile
;   1: plot,F,sfft(0:n21-1),/xsty,/ysty, /ylog,XTITLE='Hz',YTITLE='Amplitude [pT/sqrt(Hz)]-> B',$
;   YMARGIN=[3,2],XMARGIN=[9,1],TITLE=titl(k2)+' '+datfile
;    2: plot,F,sfft(0:n21-1),/xsty,/ysty, /ylog,XTITLE='Hz',YTITLE='Amplitude [pT/sqrt(Hz)]-> B',$
;   XRANGE=fftxrange2,YMARGIN=[3,2],XMARGIN=[9,1],$
;   TITLE=titl(k2)+' '+datfile, yrange=fftyrange
;       ELSE: MESSAGE, "NOTHING"
;  ENDCASE
;ENDIF

;==============================================================
;----Calling the cfg editor procedure------------------------------------
IF eventval EQ 'CFGMENU' THEN BEGIN
K=2*adc+outboard & sflag=0 & aflag=0 ; USING only outboard and ADC=0
CASE event.value OF
    'Show cal-table' :  if noopen then config_edit, K, titl(K)
    'Align spin axis' :   BEGIN if aflag eq 0 then aflag=1 & calibrate,sflag,aflag & END
    'Spin plane angle': BEGIN if aflag eq 0 then aflag=2 & calibrate,sflag,aflag & END
    'Spin plane offset' :  BEGIN if sflag eq 0 then aflag=3 & calibrate,sflag,aflag & END
    '   Sinus test    ' :   BEGIN if sflag eq 0 then sflag=1 & calibrate,sflag,aflag & END
    'Spin axis angles and gain':BEGIN if sflag eq 0 then aflag=4 & calibrate,sflag,aflag & END ;;DC;;
   ELSE: MESSAGE, "NOTHING"
ENDCASE
ENDIF
;==============================================================
IF eventval EQ 'cgapply' THEN BEGIN print,'saving basic calibration parameters to:'
  cfg_save, K2
  isensor=2*adc+outboard
  ssensor=string(isensor+1,format="(i1)")
  fname=initpath+'cal'+scid+'_'+ssensor+'d.neu' & print,fname
  savecfg2file,fname,isensor
  cfgcalc
  calibrate,0,0
  show_data, 'BXBUTTON', 2
  show_data, 'BYZBUTTON', 2
  show_data, 'BBUTTON', 0
ENDIF

IF eventval EQ 'cgload' THEN BEGIN  ;;DC;;

  fname=outp+strmid(datfile,0,strpos(datfile,'.uncal'))+'_'+version+'.cfgnew'

  print,'loading basic calibration parameters from '+fname
  printf, LOGF, systime()+'  ... load  '+fname

  isensor=2*adc+outboard
  ssensor=string(isensor+1,format="(i1)")
  spawn, 'cp '+fname+' '+initpath+'cal'+scid+'_'+ssensor+'d.neu'

  cfgread
  cfgcalc
  calibrate,0,0

  show_data, 'BXBUTTON', 2
  show_data, 'BYZBUTTON', 2
  show_data, 'BBUTTON', 0

  K=2*adc+outboard & sflag=0 & aflag=0
  config_edit, K, titl(K)

ENDIF


IF eventval EQ 'cgupdate' THEN BEGIN ;;DC;;
  K=2*adc+outboard
  range_str=strmid(datfile,14,strlen(datfile)-20)

  case strlen(range_str) of
    2: rg_chg=[fix(strmid(range_str,1)),fix(strmid(range_str,1))] ; no rc
    5: rg_chg=[fix(strmid(range_str,1)),fix(strmid(range_str,4))] ; to
    4: rg_chg=[fix(strmid(range_str,1)),fix(strmid(range_str,3))] ; from
  endcase

  CASE event.value OF
    'sc offset' :      begin
                         offsetsc[1,K]=spax_out[0]
                         offsetsc[2,K]=spax_out[1]
                         printf, LOGF, systime()+'  ... update sc offset'
                       end
    'range change' :   begin
                         if (rg_chg[0] le rg_chg[1]) then begin
                           offsetsc[1,K]=spax_out[0]
                           offsetsc[2,K]=spax_out[1]
                         endif else begin
                           offset[1,rg_chg[0]-2,K]-=(offsetsc[1,K]-spax_out[0])
                           offset[2,rg_chg[0]-2,K]-=(offsetsc[2,K]-spax_out[1])
                         endelse
                         printf, LOGF, systime()+'  ... update range change '+range_str
                       end
    'higher harmonic': begin
                         mtrxr[1,2,rg_chg[0]-2,K]=spax_out[0]
                         mtrxr[2,2,rg_chg[0]-2,K]=spax_out[1]
                         printf, LOGF, systime()+'  ... update higher harmonic'
                       end
     'rc offset':      begin
                         OPENR, 87,initpath+'rc_off.tmp'
                         ir_off=0
                         r_off_val=0.0
                         readf, 87, ir_off, r_off_val
                         close, 87
                         if (ir_off eq 0) then begin
                           print, 'old offset value. please use plotrc.pl before updating'
                         endif else begin
                           print, 'old offset: ',offset[0,ir_off-2,K], ' diff: ', r_off_val
                           offset[0,ir_off-2,K]-=r_off_val
                           printf, LOGF, systime()+'  ... update range change offset for r'+string(ir_off)
                         endelse
                       end
   ELSE: MESSAGE, "NOTHING"
  ENDCASE

  fname='updated.cfg'
  savecfg2file, fname, K

  print,'loading basic calibration parameters from '+fname
  printf, LOGF, systime()+'  ... load '+fname  ;;DC;;

  isensor=2*adc+outboard
  ssensor=string(isensor+1,format="(i1)")
  spawn, 'cp '+fname+' '+initpath+'cal'+scid+'_'+ssensor+'d.neu'

  cfgread
  cfgcalc
  calibrate,0,0

  show_data, 'BXBUTTON', 2
  show_data, 'BYZBUTTON', 2
  show_data, 'BBUTTON', 0

  sflag=0 & aflag=0
  config_edit, K, titl(K)

ENDIF

;;DC;;->
IF eventval EQ 'cgloadfrom' THEN BEGIN

  fname = DIALOG_PICKFILE(FILTER='c'+scid+'_'+date+'*.cfgnew',path=outp)

  print,'loading basic calibration parameters from '+fname
  printf, LOGF, systime()+'  ... load  '+fname

  isensor=2*adc+outboard
  ssensor=string(isensor+1,format="(i1)")
  spawn, 'cp '+fname+' '+initpath+'cal'+scid+'_'+ssensor+'d.neu'

  cfgread
  cfgcalc
  calibrate,0,0

  show_data, 'BXBUTTON', 2
  show_data, 'BYZBUTTON', 2
  show_data, 'BBUTTON', 0


  K=2*adc+outboard & sflag=0 & aflag=0
  config_edit, K, titl(K)

ENDIF
;;DC;;<-




;----------------------------------------------------------
IF eventval EQ 'cgsave' THEN BEGIN print,'saving calibration file: '
  isensor=adc+mod1(0) & tbst=strmid(tbstr,0,2)+strmid(tbstr,3,2)
  ssensor=string(isensor,format="(i1)")
  fname=outp+strmid(datfile,0,strpos(datfile,'.uncal'))+'_'+version+'.cfgnew'
  ;strput,fname,'_'+version+'.cf',strpos(fname,'.uncal')
  ;fname=outp+fname+'gnew' &
  print,outp+calname
  print,'saving basic calibration parameters to: ',fname
  savecfg2file,fname,isensor
  save_calfile
ENDIF
;---------------------------------------------------------
IF eventval EQ 'cgclose' then WIDGET_CONTROL, event.top, /DESTROY
END ;============= end of the event-handling procedure =============

;---------------------------------------------------------
FUNCTION nlines,file
;      INPUT :  filename for an ASCII file
;      OUTPUT:  number of lines
;      to be used instead spawn,'wc -l '+file for windows IDL compatibility
;      eg@mpe.mpg.de
;----------------------------------------------------------
usg='USAGE : result=nlines(file)'
if n_elements(file) eq 0 then begin print,usg & return,-1 & end
if strupcase(!d.name) eq 'X' then begin
  spawn,'wc -l '+file,nrli & i=long(nrli(0)) & end else begin
  i=0l & ss=strarr(1) & openr,11,file
  while not eof(11) do begin readf,11,ss & $
       if strlen(ss(0)) gt 1 then i=i+1l & end
  close,11 & endelse
return,i
END

;===========================================================
PRO cfgread

COMMON MATOFF
COMMON RECORD
COMMON FILES
COMMON PATH_CFG
;===========================================================
strng = STRARR(28)
offset = DBLARR(3,6,4)
offsetsc = DBLARR(3,4)
mtrxr = DBLARR(3,3,6,4)
mtrxsc = DBLARR(3,3,4)
mtrxdr = DBLARR(3,3,4)
angle =  DBLARR(3,4)
strngc = ''
cary1 = 0.0d0
cary2 = 0.0d0
cary3 = 0.0d0

;=============================================================
;   READ ALL CONFIGURATION PARAMETERS
;   by means of a main FOR LOOP on the parameter K
;=============================================================
L = 2
FOR K=0,3 DO BEGIN
ssensor=string(K+1,format="(i1)")
nrranges=5
fcfgnam=initpath+'cal'+scid+'_'+ssensor+'d.'+ext
if file_lines(fcfgnam) gt 40 then nrranges=6
OPENR,L, fcfgnam
print, fcfgnam
;=============================================================
;  INPUT OF the OFFSETS of all ranges
;=============================================================
FOR I=0,nrranges-1 DO BEGIN
READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
strng[I] = strngc
offset[0,I,K] = cary1
offset[1,I,K] = cary2
offset[2,I,K] = cary3

ENDFOR
READF, L, FORMAT='(/)'
;=============================================================
;         To input the offset spacecraft matrix
;=============================================================
READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
strng[nrranges] = strngc
offsetsc[0,K] = cary1
offsetsc[1,K] = cary2
offsetsc[2,K] = cary3

READF, L, FORMAT='(/)'
;=============================================================
;  INPUT of the MATRIX_r for all ranges
;=============================================================
; The multiplication of the range factors given by Uli Ausster
; will be taken into consideration only at the calculation
; program
;-------------------------------------------------------------
FOR J=0,nrranges-1 DO BEGIN
FOR I=0,2 DO BEGIN
READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
strng[5] = strngc
mtrxr[0,I,J,K] = cary1
mtrxr[1,I,J,K] = cary2
mtrxr[2,I,J,K] = cary3

    ENDFOR
READF, L, FORMAT='(/)'
               ENDFOR
;============================================================
;         INPUT of the spacecraft matrix_sc
;===========================================================
FOR I=0,2 DO BEGIN
READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
mtrxsc[0,I,K] = cary1
mtrxsc[1,I,K] = cary2
mtrxsc[2,I,K] = cary3

ENDFOR
READF, L, FORMAT='(/)'
;===========================================================
;        INPUT of the rotation matrx_dr
;===========================================================
FOR I=0,2 DO BEGIN
READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
mtrxdr[0,I,K] = cary1
mtrxdr[1,I,K] = cary2
mtrxdr[2,I,K] = cary3

ENDFOR
READF, L, FORMAT='(/)'
;===========================================================
;    To read the angle array
;===========================================================
READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
angle[0,K] = cary1
angle[1,K] = cary2
angle[2,K] = cary3

CLOSE, L
;==========================================================
ENDFOR   ;To end the FOR  K loop
;==========================================================
END ;====End of the Configuration-READ============================

;==========================================================
PRO cfgcalc
;==Calculation of the Calibration Matrices and Offsets===
COMMON  MATOFF
PI = !dpi
;==(1) The Rotation matrix MROT===================================
xymtrx = DBLARR(3,3,4)
xzmtrx = DBLARR(3,3,4)
yzmtrx = DBLARR(3,3,4)
mrot = DBLARR(3,3,4)
mcal = DBLARR(3,3,6,4)
ocal = DBLARR(3,6,4)
;-----------------------------------------------------------
FOR K=0,3 DO BEGIN
xymtrx[0,0,K] = cos(angle[0,K]*(PI/180.d0))
xymtrx[1,0,K] = sin(angle[0,K]*(PI/180.d0))
xymtrx[2,0,K] = 0.d0
;
xymtrx[0,1,K] = -sin(angle[0,K]*(PI/180.d0))
xymtrx[1,1,K] = cos(angle[0,K]*(PI/180.d0))
xymtrx[2,1,K] = 0.d0
;
xymtrx[0,2,K] = 0.d0
xymtrx[1,2,K] = 0.d0
xymtrx[2,2,K] = 1.d0
;-----------------------------------------------------------
xzmtrx[0,0,K] = cos(angle[1,K]*(PI/180.d0))
xzmtrx[1,0,K] = 0.d0
xzmtrx[2,0,K] = sin(angle[1,K]*(PI/180.d0))
;
xzmtrx[0,1,K] = 0.d0
xzmtrx[1,1,K] = 1.d0
xzmtrx[2,1,K] = 0.d0
;
xzmtrx[0,2,K] = -sin(angle[1,K]*(PI/180.d0))
xzmtrx[1,2,K] = 0.d0
xzmtrx[2,2,K] = cos(angle[1,K]*(PI/180.d0))
;-----------------------------------------------------------
yzmtrx[0,0,K] = 1.d0
yzmtrx[1,0,K] = 0.d0
yzmtrx[2,0,K] = 0.d0
;
yzmtrx[0,1,K] = 0.d0
yzmtrx[1,1,K] = cos(angle[2,K]*(PI/180.d0))
yzmtrx[2,1,K] = sin(angle[2,K]*(PI/180.d0))
;
yzmtrx[0,2,K] = 0.d0
yzmtrx[1,2,K] = -sin(angle[2,K]*(PI/180.d0))
yzmtrx[2,2,K] = cos(angle[2,K]*(PI/180.d0))
;
mrot[*,*,K] = yzmtrx[*,*,K] ## xzmtrx[*,*,K] ## xymtrx[*,*,K] ## mtrxdr[*,*,K]
ENDFOR
;-------------------------------------------------------------
;==(2) The Calibration  matrix MCAL====================================
factor = [1.0d0,1.0d0,1.0d0,1.0d0,1.0d0,1.0d0]
FOR K=0,3 DO BEGIN
FOR J=0,5 DO mcal[*,*,J,K] =  mrot[*,*,K] ## mtrxsc[*,*,K] ## (mtrxr[*,*,J,K]*factor[J])
ENDFOR
;==(3) The Calibration Offset OCAL=====================================
FOR K=0,3 DO BEGIN
FOR J=0,5 DO ocal[*,J,K] = mrot[*,*,K] ## mtrxsc[*,*,K] ## offsetsc[*,K] +  $
                           mrot[*,*,K] ## mtrxsc[*,*,K] ## (mtrxr[*,*,J,K]*factor[J]) ## offset[*,J,K]
ENDFOR
;-------------------------------------------------------------
;PRINT, ocal,mcal
;--Opening files to output the OCAL and MCAL Matrices---------------------
;--------------------------------------------------------------
OPENW,20,'ofstcal.dat' & printf,20,ocal & CLOSE,20
OPENW,20,'matcal.dat' & printf,20,mcal & CLOSE,20
END;==========End of the calibrations calculations=========================
;
;===============================================================
pro savecfg2file,fname,isensor
;---------------------------------------------------------------
;-------Output of the new Basic calibration parameters in "*.neu" files------------
;---------------------------------------------------------------
COMMON KSAVE
COMMON EDITMAT
COMMON MATOFF
COMMON RECORD
COMMON FILES
result1 = DBLARR(3,6,4)
result2 = DBLARR(3,4)
result3 = DBLARR(3,3,6,4)
result4 = DBLARR(3,3,4)
result5 = DBLARR(3,3,4)
result6 = DBLARR(3,4)
I=isensor & m=15
;;DC;;->
if ((fname ne 'updated.cfg') and (strmatch(fname,'*.neu') eq 1)) then begin
  printf, LOGF, systime()+'  ... save  '+fname
endif
;;DC;;<-
OPENW,m,fname
;------------------------------
FOR T=0,5 DO BEGIN
result1 = offset[*,T,I]
name = STRCOMPRESS('Offset_r'+STRING(T)+'=',/REMOVE_ALL)
PRINTF,m,name,result1
ENDFOR
PRINTF,m,' '
;------------------------------
result2 = offsetsc[*,I]
PRINTF,m,FORMAT='(A10,F13.7,2x,F13.7,2x,F13.7)','offset_sc=',result2
PRINTF,m,' '
;------------------------------
FOR T=0,5 DO BEGIN
FOR Y=0,2 DO BEGIN
result3 = mtrxr[*,Y,T,I]
name = STRCOMPRESS('Matrix_r'+STRING(T)+'=',/REMOVE_ALL)
PRINTF,m,FORMAT='(A10,F13.7,2x,F13.7,2x,F13.7)',name,result3
ENDFOR
PRINTF,m,' '
ENDFOR
;------------------------------
FOR Y=0,2 DO BEGIN
result4 = mtrxsc[*,Y,I]
PRINTF,m,FORMAT='(A10,F13.7,2x,F13.7,2x,F13.7)','Matrix_SC= ',result4
ENDFOR
PRINTF,m,' '
;-----------------------------
FOR Y=0,2 DO BEGIN
result5 = mtrxdr[*,Y,I]
PRINTF,m,FORMAT='(A10,F13.7,2x,F13.7,2x,F13.7)','Matrix_dr= ',result5
ENDFOR
PRINTF,m,' '
;-----------------------------
result6 = angle[*,I]
PRINTF,m,FORMAT='(A10,F13.7,2x,F13.7,2x,F13.7)','Matrix_xyz',result6
PRINTF,m,' ' & CLOSE,15
END ;save  basic parameters to ./cal#_id.neu' files or to output directory for statistics


;-----------------------------------------------------------
pro save_calfile
;----To output the OCAL values to the daily_calfiles and to the C#_yyyymmddrange7.calfile -------
COMMON MATOFF
COMMON RECORD
COMMON FILES
COMMON PATH_CFG
printf, LOGF, systime()+'  ... write '+outp+calname ;;DC;;
;; saving here range 7 calibration parameters to daily range 7 calfile MUST be renamed for use in FGM s/w
calf_r7=outp+strmid(calname,0,strpos(calname,'_V'))+'range7.fgmcal'
openw,21,calf_r7
for j=0,2 do printf,21,ocal(j,5,0)
for l=0,2 do for j=0,2 do printf,21,mcal(j,l,5,0)
close,21
;; end save range 7
OPENW,21,outp+calname
if adc eq 0 then PRINTF,21,'1  T24:00:00.000' else PRINTF,21,'2  T24:00:00.000'
fo1='(5(F14.7),3x,A5)
FOR S=0,3 DO BEGIN
   FOR J=0,2 DO BEGIN
          calvalue1 = ocal(J,0,S)
          calvalue2 = ocal(J,1,S)
          calvalue3 = ocal(J,2,S)
          calvalue4 = ocal(J,3,S)
          calvalue5 = ocal(J,4,S)
          label = STRCOMPRESS('S'+STRING(S+1)+'_0'+STRING(J+1),/REMOVE_ALL)
           PRINTF,21,FORMAT=fo1,calvalue1,calvalue2,calvalue3,calvalue4,calvalue5,label
    ENDFOR ;J
;----To output the MCAL values in the MUENCHEN Format-------
;
   FOR L=0,2 DO BEGIN
      FOR J=0,2 DO BEGIN
           calvalue1 = mcal(J,L,0,S)
           calvalue2 = mcal(J,L,1,S)
           calvalue3 = mcal(J,L,2,S)
           calvalue4 = mcal(J,L,3,S)
           calvalue5 = mcal(J,L,4,S)
           label=STRCOMPRESS('S'+STRING(S+1)+'_'+STRING(L+1)+STRING(J+1),/REMOVE_ALL)
           PRINTF,21,FORMAT=fo1,calvalue1,calvalue2,calvalue3,calvalue4,calvalue5,label
       ENDFOR;J
   ENDFOR;L
ENDFOR;S
PRINTF,21,''
PRINTF,21,'S1 = OB + ADC1, S2 = IB + ADC1, S3 = OB + ADC2, S4 = IB + ADC2'
PRINTF,21,'ranges = 2,3,4,5,6,7 => 64, 256, 1024, 4096, 16384 65536 nT'
gr_text=['F9_fsr, data from ground calibration tu-bs magnetsrode 08/09 1999',$
    'F6_fsr, data from ground calibration tu-bs magnetsrode 11 1998',$
    'F7_fsr, data from ground calibration tu-bs magnetsrode 01/02 1999',$
    'F8_fsr, data from ground calibration tu-bs magnetsrode 07/08 1999']
PRINTF,21,gr_text(fix(scid)-1)
sensstr=['OB','IB']
PRINTF,21,sensstr(mod1(0))+'  r',mod2(0),'  '+tbstr,format="(a,i1,a)"
PRINTF,21,calname
CLOSE,21
END;==========End of save calibration file

;================================================================
;=========A program to edit the configuration values =========================
;================================================================
PRO config_edit, K, sennumber
COMMON RECORD
COMMON PATH_CFG
COMMON FILES
COMMON MATOFF
COMMON KSAVE
COMMON EDITMAT
K2=K
noopen=0 & lastsensor=K2
;---------------------------------------------------------
cfgedit1 = WIDGET_BASE(/COLUMN, TITLE=sennumber)
if cfgedit1 ne lastcfg and nofirst gt 0 then WIDGET_CONTROL, lastcfg, /DESTROY
lastcfg=cfgedit1 & nofirst=nofirst+1
cfgbutton = WIDGET_BASE(cfgedit1,/ROW)
cfgapply =  WIDGET_BUTTON(cfgbutton, VALUE='Apply',UVALUE='cgapply')
cfgsave =  WIDGET_BUTTON(cfgbutton, VALUE='Save',UVALUE='cgsave')
cfgload =  WIDGET_BUTTON(cfgbutton, VALUE='Load current',UVALUE='cgload')
cfgload =  WIDGET_BUTTON(cfgbutton, VALUE='Load...',UVALUE='cgloadfrom')
cfgupdate = CW_PdMenu(cfgbutton, /RETURN_NAME, ['1\ Update ',$
    '0\sc offset','0\range change','0\higher harmonic','0\rc offset'],uvalue='cgupdate')
cfgclose =  WIDGET_BUTTON(cfgbutton, VALUE='CLOSE',UVALUE='cgclose')

;--------------------------------------------------------
cfgedit = WIDGET_BASE(cfgedit1,/COLUMN,X_SCROll_SIZE=400,Y_SCROll_SIZE=450)
ofstwdgt =WIDGET_BASE(cfgedit, /COLUMN,/FRAME)
ofstwdgt0 = WIDGET_BASE(ofstwdgt, /ROW)
ofst01 = CW_FIELD(ofstwdgt0,XSIZE=12,VALUE=offset[0,0,K]$
    ,/RETURN_EVENTS,/ALL_EVENTS,TITLE='offset_r2')
ofst02 = CW_FIELD(ofstwdgt0,XSIZE=12,VALUE=offset[1,0,K],TITLE=' ')
ofst03 = CW_FIELD(ofstwdgt0,XSIZE=12,VALUE=offset[2,0,K],TITLE=' ')
;--------------------------------------------------------
ofstwdgt1 = WIDGET_BASE(ofstwdgt, /ROW)
ofst11 = CW_FIELD(ofstwdgt1,XSIZE=12,VALUE=offset[0,1,K],TITLE='offset_r3')
ofst12 = CW_FIELD(ofstwdgt1,XSIZE=12,VALUE=offset[1,1,K],TITLE=' ')
ofst13 = CW_FIELD(ofstwdgt1,XSIZE=12,VALUE=offset[2,1,K],TITLE=' ')
;--------------------------------------------------------
ofstwdgt2 = WIDGET_BASE(ofstwdgt, /ROW)
ofst21 = CW_FIELD(ofstwdgt2,XSIZE=12,VALUE=offset[0,2,K],TITLE='offset_r4')
ofst22 = CW_FIELD(ofstwdgt2,XSIZE=12,VALUE=offset[1,2,K],TITLE=' ')
ofst23 = CW_FIELD(ofstwdgt2,XSIZE=12,VALUE=offset[2,2,K],TITLE=' ')
;--------------------------------------------------------
ofstwdgt3 = WIDGET_BASE(ofstwdgt, /ROW)
ofst31 = CW_FIELD(ofstwdgt3,XSIZE=12,VALUE=offset[0,3,K],TITLE='offset_r5')
ofst32 = CW_FIELD(ofstwdgt3,XSIZE=12,VALUE=offset[1,3,K],TITLE=' ')
ofst33 = CW_FIELD(ofstwdgt3,XSIZE=12,VALUE=offset[2,3,K],TITLE=' ')
;--------------------------------------------------------
ofstwdgt4 = WIDGET_BASE(ofstwdgt, /ROW)
ofst41 = CW_FIELD(ofstwdgt4,XSIZE=12,VALUE=offset[0,4,K],TITLE='offset_r6')
ofst42 = CW_FIELD(ofstwdgt4,XSIZE=12,VALUE=offset[1,4,K],TITLE=' ')
ofst43 = CW_FIELD(ofstwdgt4,XSIZE=12,VALUE=offset[2,4,K],TITLE=' ')
;--------------------------------------------------------
ofstwdgt5 = WIDGET_BASE(ofstwdgt, /ROW)
ofst51 = CW_FIELD(ofstwdgt5,XSIZE=12,VALUE=offset[0,5,K],TITLE='offset_r7')
ofst52 = CW_FIELD(ofstwdgt5,XSIZE=12,VALUE=offset[1,5,K],TITLE=' ')
ofst53 = CW_FIELD(ofstwdgt5,XSIZE=12,VALUE=offset[2,5,K],TITLE=' ')
;--------------------------------------------------------
ofstwdgtsc = WIDGET_BASE(ofstwdgt, /ROW)
ofstsc1 = CW_FIELD(ofstwdgtsc,XSIZE=12,VALUE=offsetsc[0,K],TITLE='offset_sc')
ofstsc2 = CW_FIELD(ofstwdgtsc,XSIZE=12,VALUE=offsetsc[1,K],TITLE=' ')
ofstsc3 = CW_FIELD(ofstwdgtsc,XSIZE=12,VALUE=offsetsc[2,K],TITLE=' ')
;--------------------------------------------------------
winkel = WIDGET_BASE(cfgedit,/ROW,/FRAME)
winkel1 = CW_FIELD(winkel,XSIZE=12,VALUE=angle[0,K],TITLE='Angle_xyz')
winkel2 = CW_FIELD(winkel,XSIZE=12,VALUE=angle[1,K],TITLE=' ')
winkel3 = CW_FIELD(winkel,XSIZE=12,VALUE=angle[2,K],TITLE=' ')
;========================================================
mtrxwdgt1 =WIDGET_BASE(cfgedit, /COLUMN,/FRAME)
;--------------------------------------------------------
mtrxr01 = WIDGET_BASE(mtrxwdgt1, /ROW)
mtrx011 = CW_FIELD(mtrxr01,XSIZE=12,VALUE=mtrxr[0,0,0,K],TITLE='Matrix_r2')
mtrx012 = CW_FIELD(mtrxr01,XSIZE=12,VALUE=mtrxr[1,0,0,K],TITLE=' ')
mtrx013 = CW_FIELD(mtrxr01,XSIZE=12,VALUE=mtrxr[2,0,0,K],TITLE=' ')
;--------------------------------------------------------
mtrxr02 = WIDGET_BASE(mtrxwdgt1, /ROW)
mtrx021 = CW_FIELD(mtrxr02,XSIZE=12,VALUE=mtrxr[0,1,0,K],TITLE='Matrix_r2')
mtrx022 = CW_FIELD(mtrxr02,XSIZE=12,VALUE=mtrxr[1,1,0,K],TITLE=' ')
mtrx023 = CW_FIELD(mtrxr02,XSIZE=12,VALUE=mtrxr[2,1,0,K],TITLE=' ')
;--------------------------------------------------------
mtrxr03 = WIDGET_BASE(mtrxwdgt1, /ROW)
mtrx031 = CW_FIELD(mtrxr03,XSIZE=12,VALUE=mtrxr[0,2,0,K],TITLE='Matrix_r2')
mtrx032 = CW_FIELD(mtrxr03,XSIZE=12,VALUE=mtrxr[1,2,0,K],TITLE=' ')
mtrx033 = CW_FIELD(mtrxr03,XSIZE=12,VALUE=mtrxr[2,2,0,K],TITLE=' ')
;========================================================
mtrxwdgt2 =WIDGET_BASE(cfgedit, /COLUMN,/FRAME)
;--------------------------------------------------------
mtrxr11 = WIDGET_BASE(mtrxwdgt2, /ROW)
mtrx111 = CW_FIELD(mtrxr11,XSIZE=12,VALUE=mtrxr[0,0,1,K],TITLE='Matrix_r3')
mtrx112 = CW_FIELD(mtrxr11,XSIZE=12,VALUE=mtrxr[1,0,1,K],TITLE=' ')
mtrx113 = CW_FIELD(mtrxr11,XSIZE=12,VALUE=mtrxr[2,0,1,K],TITLE=' ')
;--------------------------------------------------------
mtrxr12 = WIDGET_BASE(mtrxwdgt2, /ROW)
mtrx121 = CW_FIELD(mtrxr12,XSIZE=12,VALUE=mtrxr[0,1,1,K],TITLE='Matrix_r3')
mtrx122 = CW_FIELD(mtrxr12,XSIZE=12,VALUE=mtrxr[1,1,1,K],TITLE=' ')
mtrx123 = CW_FIELD(mtrxr12,XSIZE=12,VALUE=mtrxr[2,1,1,K],TITLE=' ')
;--------------------------------------------------------
mtrxr13 = WIDGET_BASE(mtrxwdgt2, /ROW)
mtrx131 = CW_FIELD(mtrxr13,XSIZE=12,VALUE=mtrxr[0,2,1,K],TITLE='Matrix_r3')
mtrx132 = CW_FIELD(mtrxr13,XSIZE=12,VALUE=mtrxr[1,2,1,K],TITLE=' ')
mtrx133 = CW_FIELD(mtrxr13,XSIZE=12,VALUE=mtrxr[2,2,1,K],TITLE=' ')
;========================================================
mtrxwdgt3 =WIDGET_BASE(cfgedit, /COLUMN,/FRAME)
;--------------------------------------------------------
mtrxr21 = WIDGET_BASE(mtrxwdgt3, /ROW)
mtrx211 = CW_FIELD(mtrxr21,XSIZE=12,VALUE=mtrxr[0,0,2,K],TITLE='Matrix_r4')
mtrx212 = CW_FIELD(mtrxr21,XSIZE=12,VALUE=mtrxr[1,0,2,K],TITLE=' ')
mtrx213 = CW_FIELD(mtrxr21,XSIZE=12,VALUE=mtrxr[2,0,2,K],TITLE=' ')
;--------------------------------------------------------
mtrxr22 = WIDGET_BASE(mtrxwdgt3, /ROW)
mtrx221 = CW_FIELD(mtrxr22,XSIZE=12,VALUE=mtrxr[0,1,2,K],TITLE='Matrix_r4')
mtrx222 = CW_FIELD(mtrxr22,XSIZE=12,VALUE=mtrxr[1,1,2,K],TITLE=' ')
mtrx223 = CW_FIELD(mtrxr22,XSIZE=12,VALUE=mtrxr[2,1,2,K],TITLE=' ')
;--------------------------------------------------------
mtrxr23 = WIDGET_BASE(mtrxwdgt3, /ROW)
mtrx231 = CW_FIELD(mtrxr23,XSIZE=12,VALUE=mtrxr[0,2,2,K],TITLE='Matrix_r4')
mtrx232 = CW_FIELD(mtrxr23,XSIZE=12,VALUE=mtrxr[1,2,2,K],TITLE=' ')
mtrx233 = CW_FIELD(mtrxr23,XSIZE=12,VALUE=mtrxr[2,2,2,K],TITLE=' ')
;========================================================
mtrxwdgt4 =WIDGET_BASE(cfgedit, /COLUMN,/FRAME)
;--------------------------------------------------------
mtrxr31 = WIDGET_BASE(mtrxwdgt4, /ROW)
mtrx311 = CW_FIELD(mtrxr31,XSIZE=12,VALUE=mtrxr[0,0,3,K],TITLE='Matrix_r5')
mtrx312 = CW_FIELD(mtrxr31,XSIZE=12,VALUE=mtrxr[1,0,3,K],TITLE=' ')
mtrx313 = CW_FIELD(mtrxr31,XSIZE=12,VALUE=mtrxr[2,0,3,K],TITLE=' ')
;--------------------------------------------------------
mtrxr32 = WIDGET_BASE(mtrxwdgt4, /ROW)
mtrx321 = CW_FIELD(mtrxr32,XSIZE=12,VALUE=mtrxr[0,1,3,K],TITLE='Matrix_r5')
mtrx322 = CW_FIELD(mtrxr32,XSIZE=12,VALUE=mtrxr[1,1,3,K],TITLE=' ')
mtrx323 = CW_FIELD(mtrxr32,XSIZE=12,VALUE=mtrxr[2,1,3,K],TITLE=' ')
;--------------------------------------------------------
mtrxr33 = WIDGET_BASE(mtrxwdgt4, /ROW)
mtrx331 = CW_FIELD(mtrxr33,XSIZE=12,VALUE=mtrxr[0,2,3,K],TITLE='Matrix_r5')
mtrx332 = CW_FIELD(mtrxr33,XSIZE=12,VALUE=mtrxr[1,2,3,K],TITLE=' ')
mtrx333 = CW_FIELD(mtrxr33,XSIZE=12,VALUE=mtrxr[2,2,3,K],TITLE=' ')
;========================================================
mtrxwdgt5 =WIDGET_BASE(cfgedit, /COLUMN,/FRAME)
;--------------------------------------------------------
mtrxr41 = WIDGET_BASE(mtrxwdgt5, /ROW)
mtrx411 = CW_FIELD(mtrxr41,XSIZE=12,VALUE=mtrxr[0,0,4,K],TITLE='Matrix_r6')
mtrx412 = CW_FIELD(mtrxr41,XSIZE=12,VALUE=mtrxr[1,0,4,K],TITLE=' ')
mtrx413 = CW_FIELD(mtrxr41,XSIZE=12,VALUE=mtrxr[2,0,4,K],TITLE=' ')
;--------------------------------------------------------
mtrxr42 = WIDGET_BASE(mtrxwdgt5, /ROW)
mtrx421 = CW_FIELD(mtrxr42,XSIZE=12,VALUE=mtrxr[0,1,4,K],TITLE='Matrix_r6')
mtrx422 = CW_FIELD(mtrxr42,XSIZE=12,VALUE=mtrxr[1,1,4,K],TITLE=' ')
mtrx423 = CW_FIELD(mtrxr42,XSIZE=12,VALUE=mtrxr[2,1,4,K],TITLE=' ')
;--------------------------------------------------------
mtrxr43 = WIDGET_BASE(mtrxwdgt5, /ROW)
mtrx431 = CW_FIELD(mtrxr43,XSIZE=12,VALUE=mtrxr[0,2,4,K],TITLE='Matrix_r6')
mtrx432 = CW_FIELD(mtrxr43,XSIZE=12,VALUE=mtrxr[1,2,4,K],TITLE=' ')
mtrx433 = CW_FIELD(mtrxr43,XSIZE=12,VALUE=mtrxr[2,2,4,K],TITLE=' ')
;========================================================
mtrxwdgt9 =WIDGET_BASE(cfgedit, /COLUMN,/FRAME)
;--------------------------------------------------------
mtrxr51 = WIDGET_BASE(mtrxwdgt9, /ROW)
mtrx511 = CW_FIELD(mtrxr51,XSIZE=12,VALUE=mtrxr[0,0,5,K],TITLE='Matrix_r7')
mtrx512 = CW_FIELD(mtrxr51,XSIZE=12,VALUE=mtrxr[1,0,5,K],TITLE=' ')
mtrx513 = CW_FIELD(mtrxr51,XSIZE=12,VALUE=mtrxr[2,0,5,K],TITLE=' ')
;--------------------------------------------------------
mtrxr52 = WIDGET_BASE(mtrxwdgt9, /ROW)
mtrx521 = CW_FIELD(mtrxr52,XSIZE=12,VALUE=mtrxr[0,1,5,K],TITLE='Matrix_r7')
mtrx522 = CW_FIELD(mtrxr52,XSIZE=12,VALUE=mtrxr[1,1,5,K],TITLE=' ')
mtrx523 = CW_FIELD(mtrxr52,XSIZE=12,VALUE=mtrxr[2,1,5,K],TITLE=' ')
;--------------------------------------------------------
mtrxr53 = WIDGET_BASE(mtrxwdgt9, /ROW)
mtrx531 = CW_FIELD(mtrxr53,XSIZE=12,VALUE=mtrxr[0,2,5,K],TITLE='Matrix_r7')
mtrx532 = CW_FIELD(mtrxr53,XSIZE=12,VALUE=mtrxr[1,2,5,K],TITLE=' ')
mtrx533 = CW_FIELD(mtrxr53,XSIZE=12,VALUE=mtrxr[2,2,5,K],TITLE=' ')
;========================================================
mtrxwdgt6 =WIDGET_BASE(cfgedit, /COLUMN,/FRAME)
;--------------------------------------------------------
mtrxsc1 = WIDGET_BASE(mtrxwdgt6, /ROW)
mtrxsc11 = CW_FIELD(mtrxsc1,XSIZE=12,VALUE=mtrxsc[0,0,K],TITLE='Matrix_sc')
mtrxsc12 = CW_FIELD(mtrxsc1,XSIZE=12,VALUE=mtrxsc[1,0,K],TITLE=' ')
mtrxsc13 = CW_FIELD(mtrxsc1,XSIZE=12,VALUE=mtrxsc[2,0,K],TITLE=' ')
;--------------------------------------------------------
mtrxsc2 = WIDGET_BASE(mtrxwdgt6, /ROW)
mtrxsc21 = CW_FIELD(mtrxsc2,XSIZE=12,VALUE=mtrxsc[0,1,K],TITLE='Matrix_sc')
mtrxsc22 = CW_FIELD(mtrxsc2,XSIZE=12,VALUE=mtrxsc[1,1,K],TITLE=' ')
mtrxsc23 = CW_FIELD(mtrxsc2,XSIZE=12,VALUE=mtrxsc[2,1,K],TITLE=' ')
;--------------------------------------------------------
mtrxsc3 = WIDGET_BASE(mtrxwdgt6, /ROW)
mtrxsc31 = CW_FIELD(mtrxsc3,XSIZE=12,VALUE=mtrxsc[0,2,K],TITLE='Matrix_sc')
mtrxsc32 = CW_FIELD(mtrxsc3,XSIZE=12,VALUE=mtrxsc[1,2,K],TITLE=' ')
mtrxsc33 = CW_FIELD(mtrxsc3,XSIZE=12,VALUE=mtrxsc[2,2,K],TITLE=' ')
;========================================================
mtrxwdgt7 =WIDGET_BASE(cfgedit, /COLUMN,/FRAME)
;--------------------------------------------------------
mtrxdr1 = WIDGET_BASE(mtrxwdgt7, /ROW)
mtrxdr11 = CW_FIELD(mtrxdr1,XSIZE=12,VALUE=mtrxdr[0,0,K],TITLE='Matrix_dr')
mtrxdr12 = CW_FIELD(mtrxdr1,XSIZE=12,VALUE=mtrxdr[1,0,K],TITLE=' ')
mtrxdr13 = CW_FIELD(mtrxdr1,XSIZE=12,VALUE=mtrxdr[2,0,K],TITLE=' ')
;--------------------------------------------------------
mtrxdr2 = WIDGET_BASE(mtrxwdgt7, /ROW)
mtrxdr21 = CW_FIELD(mtrxdr2,XSIZE=12,VALUE=mtrxdr[0,1,K],TITLE='Matrix_dr')
mtrxdr22 = CW_FIELD(mtrxdr2,XSIZE=12,VALUE=mtrxdr[1,1,K],TITLE=' ')
mtrxdr23 = CW_FIELD(mtrxdr2,XSIZE=12,VALUE=mtrxdr[2,1,K],TITLE=' ')
;--------------------------------------------------------
mtrxdr3 = WIDGET_BASE(mtrxwdgt7, /ROW)
mtrxdr31 = CW_FIELD(mtrxdr3,XSIZE=12,VALUE=mtrxdr[0,2,K],TITLE='Matrix_dr')
mtrxdr32 = CW_FIELD(mtrxdr3,XSIZE=12,VALUE=mtrxdr[1,2,K],TITLE=' ')
mtrxdr33 = CW_FIELD(mtrxdr3,XSIZE=12,VALUE=mtrxdr[2,2,K],TITLE=' ')
;---------------------------------------------------------
WIDGET_CONTROL, cfgedit1, /REALIZE
;---------------------------------------------------------
XManager, "config_edit", cfgedit1, EVENT_HANDLER = "clus_ev"
END;====== END of the Configurations-Edit Window ===================

;=========================================================
PRO cfg_save, K2
;========= A program to save the new basic calibration parameters =======
;========= after its modification In the calbration edit window =============
;---------------------------------------------------------
COMMON MATOFF
COMMON EDITMAT
;--------------------------------------------------------
WIDGET_CONTROL,ofst01,GET_VALUE= temp
offset[0,0,K2]= temp
WIDGET_CONTROL,ofst02,GET_VALUE= temp
offset[1,0,K2]= temp
WIDGET_CONTROL,ofst03,GET_VALUE= temp
offset[2,0,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,ofst11,GET_VALUE= temp
offset[0,1,K2]= temp
WIDGET_CONTROL,ofst12,GET_VALUE= temp
offset[1,1,K2]= temp
WIDGET_CONTROL,ofst13,GET_VALUE= temp
offset[2,1,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,ofst21,GET_VALUE= temp
offset[0,2,K2] = temp
WIDGET_CONTROL,ofst22,GET_VALUE= temp
offset[1,2,K2] = temp
WIDGET_CONTROL,ofst23,GET_VALUE= temp
offset[2,2,K2] = temp
;--------------------------------------------------------
WIDGET_CONTROL,ofst31,GET_VALUE= temp
offset[0,3,K2] = temp
WIDGET_CONTROL,ofst32,GET_VALUE= temp
offset[1,3,K2] = temp
WIDGET_CONTROL,ofst33,GET_VALUE= temp
offset[2,3,K2] = temp
;--------------------------------------------------------
WIDGET_CONTROL,ofst41,GET_VALUE= temp
offset[0,4,K2] = temp
WIDGET_CONTROL,ofst42,GET_VALUE= temp
offset[1,4,K2]  = temp
WIDGET_CONTROL,ofst43,GET_VALUE= temp
offset[2,4,K2] = temp
;--------------------------------------------------------
WIDGET_CONTROL,ofst51,GET_VALUE= temp
offset[0,5,K2] = temp
WIDGET_CONTROL,ofst52,GET_VALUE= temp
offset[1,5,K2]  = temp
WIDGET_CONTROL,ofst53,GET_VALUE= temp
offset[2,5,K2] = temp
;--------------------------------------------------------
WIDGET_CONTROL,ofstsc1, GET_VALUE= temp
offsetsc[0,K2]= temp
WIDGET_CONTROL,ofstsc2, GET_VALUE= temp
offsetsc[1,K2]= temp
WIDGET_CONTROL,ofstsc3, GET_VALUE= temp
offsetsc[2,K2] = temp
;--------------------------------------------------------
WIDGET_CONTROL,winkel1 , GET_VALUE= temp
angle[0,K2]= temp
WIDGET_CONTROL,winkel2 , GET_VALUE= temp
angle[1,K2] = temp
WIDGET_CONTROL,winkel3, GET_VALUE= temp
angle[2,K2] = temp
;========================================================
WIDGET_CONTROL,mtrx011, GET_VALUE= temp
mtrxr[0,0,0,K2] = temp
WIDGET_CONTROL,mtrx012, GET_VALUE= temp
mtrxr[1,0,0,K2] = temp
WIDGET_CONTROL,mtrx013, GET_VALUE= temp
mtrxr[2,0,0,K2] = temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrx021, GET_VALUE= temp
mtrxr[0,1,0,K2]= temp
WIDGET_CONTROL,mtrx022, GET_VALUE= temp
mtrxr[1,1,0,K2] = temp
WIDGET_CONTROL,mtrx023, GET_VALUE= temp
mtrxr[2,1,0,K2] = temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrx031 , GET_VALUE= temp
mtrxr[0,2,0,K2]= temp
WIDGET_CONTROL,mtrx032 , GET_VALUE= temp
mtrxr[1,2,0,K2]= temp
WIDGET_CONTROL,mtrx033 , GET_VALUE= temp
mtrxr[2,2,0,K2]= temp
;========================================================
WIDGET_CONTROL,mtrx111 , GET_VALUE= temp
mtrxr[0,0,1,K2]= temp
WIDGET_CONTROL,mtrx112 , GET_VALUE= temp
mtrxr[1,0,1,K2]= temp
WIDGET_CONTROL,mtrx113 , GET_VALUE= temp
mtrxr[2,0,1,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrx121 , GET_VALUE= temp
mtrxr[0,1,1,K2]= temp
WIDGET_CONTROL,mtrx122 , GET_VALUE= temp
mtrxr[1,1,1,K2]= temp
WIDGET_CONTROL,mtrx123 , GET_VALUE= temp
mtrxr[2,1,1,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrx131 , GET_VALUE= temp
mtrxr[0,2,1,K2]= temp
WIDGET_CONTROL,mtrx132 , GET_VALUE= temp
mtrxr[1,2,1,K2]= temp
WIDGET_CONTROL,mtrx133 , GET_VALUE= temp
mtrxr[2,2,1,K2]= temp
;========================================================
WIDGET_CONTROL,mtrx211 , GET_VALUE= temp
mtrxr[0,0,2,K2]= temp
WIDGET_CONTROL,mtrx212 , GET_VALUE= temp
mtrxr[1,0,2,K2]= temp
WIDGET_CONTROL,mtrx213 , GET_VALUE= temp
mtrxr[2,0,2,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrx221 , GET_VALUE= temp
mtrxr[0,1,2,K2]= temp
WIDGET_CONTROL,mtrx222 , GET_VALUE= temp
mtrxr[1,1,2,K2]= temp
WIDGET_CONTROL,mtrx223 , GET_VALUE= temp
mtrxr[2,1,2,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrx231 , GET_VALUE= temp
mtrxr[0,2,2,K2]= temp
WIDGET_CONTROL,mtrx232 , GET_VALUE= temp
mtrxr[1,2,2,K2]= temp
WIDGET_CONTROL,mtrx233 , GET_VALUE= temp
mtrxr[2,2,2,K2]= temp
;========================================================
WIDGET_CONTROL,mtrx311 , GET_VALUE= temp
mtrxr[0,0,3,K2]= temp
WIDGET_CONTROL,mtrx312 , GET_VALUE= temp
mtrxr[1,0,3,K2]= temp
WIDGET_CONTROL,mtrx313 , GET_VALUE= temp
mtrxr[2,0,3,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrx321 , GET_VALUE= temp
mtrxr[0,1,3,K2]= temp
WIDGET_CONTROL,mtrx322 , GET_VALUE= temp
mtrxr[1,1,3,K2]= temp
WIDGET_CONTROL,mtrx323 , GET_VALUE= temp
mtrxr[2,1,3,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrx331 , GET_VALUE= temp
mtrxr[0,2,3,K2]= temp
WIDGET_CONTROL,mtrx332 , GET_VALUE= temp
mtrxr[1,2,3,K2]= temp
WIDGET_CONTROL,mtrx333 , GET_VALUE= temp
mtrxr[2,2,3,K2]= temp
;========================================================
WIDGET_CONTROL,mtrx411 , GET_VALUE= temp
mtrxr[0,0,4,K2]= temp
WIDGET_CONTROL,mtrx412 , GET_VALUE= temp
mtrxr[1,0,4,K2]= temp
WIDGET_CONTROL,mtrx413 , GET_VALUE= temp
mtrxr[2,0,4,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrx421 , GET_VALUE= temp
mtrxr[0,1,4,K2]= temp
WIDGET_CONTROL,mtrx422 , GET_VALUE= temp
mtrxr[1,1,4,K2]= temp
WIDGET_CONTROL,mtrx423 , GET_VALUE= temp
mtrxr[2,1,4,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrx431 , GET_VALUE= temp
mtrxr[0,2,4,K2]= temp
WIDGET_CONTROL,mtrx432 , GET_VALUE= temp
mtrxr[1,2,4,K2]= temp
WIDGET_CONTROL,mtrx433 , GET_VALUE= temp
mtrxr[2,2,4,K2]= temp
;========================================================
WIDGET_CONTROL,mtrx511 , GET_VALUE= temp
mtrxr[0,0,5,K2]= temp
WIDGET_CONTROL,mtrx512 , GET_VALUE= temp
mtrxr[1,0,5,K2]= temp
WIDGET_CONTROL,mtrx513 , GET_VALUE= temp
mtrxr[2,0,5,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrx521 , GET_VALUE= temp
mtrxr[0,1,5,K2]= temp
WIDGET_CONTROL,mtrx522 , GET_VALUE= temp
mtrxr[1,1,5,K2]= temp
WIDGET_CONTROL,mtrx523 , GET_VALUE= temp
mtrxr[2,1,5,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrx531 , GET_VALUE= temp
mtrxr[0,2,5,K2]= temp
WIDGET_CONTROL,mtrx532 , GET_VALUE= temp
mtrxr[1,2,5,K2]= temp
WIDGET_CONTROL,mtrx533 , GET_VALUE= temp
mtrxr[2,2,5,K2]= temp
;========================================================
WIDGET_CONTROL,mtrxsc11 , GET_VALUE= temp
mtrxsc[0,0,K2]= temp
WIDGET_CONTROL,mtrxsc12 , GET_VALUE= temp
mtrxsc[1,0,K2]= temp
WIDGET_CONTROL,mtrxsc13 , GET_VALUE= temp
mtrxsc[2,0,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrxsc21 , GET_VALUE= temp
mtrxsc[0,1,K2]= temp
WIDGET_CONTROL,mtrxsc22 , GET_VALUE= temp
mtrxsc[1,1,K2]= temp
WIDGET_CONTROL,mtrxsc23 , GET_VALUE= temp
mtrxsc[2,1,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrxsc31 , GET_VALUE= temp
mtrxsc[0,2,K2]= temp
WIDGET_CONTROL,mtrxsc32 , GET_VALUE= temp
mtrxsc[1,2,K2]= temp
WIDGET_CONTROL,mtrxsc33 , GET_VALUE= temp
mtrxsc[2,2,K2]= temp
;========================================================
WIDGET_CONTROL,mtrxdr11 , GET_VALUE= temp
mtrxdr[0,0,K2]= temp
WIDGET_CONTROL,mtrxdr12 , GET_VALUE= temp
mtrxdr[1,0,K2]= temp
WIDGET_CONTROL,mtrxdr13 , GET_VALUE= temp
mtrxdr[2,0,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrxdr21 , GET_VALUE= temp
mtrxdr[0,1,K2]= temp
WIDGET_CONTROL,mtrxdr22 , GET_VALUE= temp
mtrxdr[1,1,K2]= temp
WIDGET_CONTROL,mtrxdr23 , GET_VALUE= temp
mtrxdr[2,1,K2]= temp
;--------------------------------------------------------
WIDGET_CONTROL,mtrxdr31 , GET_VALUE= temp
mtrxdr[0,2,K2]= temp
WIDGET_CONTROL,mtrxdr32 , GET_VALUE= temp
mtrxdr[1,2,K2]= temp
WIDGET_CONTROL,mtrxdr33 , GET_VALUE= temp
mtrxdr[2,2,K2]= temp
;--------------------------------------------------------
END;====== END of the configuration Saving Program =======================

pro show_data, eventval, event_idx

  COMMON RECORD
  COMMON COUNTER
  COMMON INOUT
  COMMON VALUES
  COMMON FILES

  ; fftxrange2=[0.001,1.]   ;The range of the frequencies plotted in the spectrum(FFTzoom) Hz
  fftxrange2=[0.15,0.6]   ;The range of the frequencies plotted in the spectrum(FFTzoom) Hz
 ; fftyrange =[0.1,10000.] ;The range of the PSD plotted in the spectrum(FFT,FFTzoom) pT
; fftyrange =[100,1000.] ;The range of the PSD plotted in the spectrum(FFT,FFTzoom) pT
fftyrange =[0.1,20000.] ;The range of the PSD plotted in the spectrum(FFT,FFTzoom) pT


  ;----To plot The Bx Options----------------------------------------
  titl= [  '>>OB + ADC 1<<','>>IB + ADC 1<<','>>OB + ADC 2<<','>>IB + ADC 2<<']
  k2=2*adc+outboard
  IF eventval EQ 'BXBUTTON' THEN BEGIN
  WSET, valuex
  if ((k2) mod 2) eq 1 then plotarray=indata(0,*) else plotarray=outdata(0,*)
  plotarray=transpose(plotarray) & meanbxout = mean(plotarray)
  N21 = fix(count/2)+1 & F = findgen(n21)
  F = F/(count*dt) & sfft=1000.*ABS(FFT(plotarray-meanbxout,-1))

  ;;DC;; ->
  sfft2=sfft(1:n21-2)
  fftyrange_z=[fftyrange(0)>min(sfft2(where((F ge fftxrange2(0)) and (F le fftxrange2(1)) and (F ge 1e-9)))),$
             fftyrange(1)<max(sfft2(where((F ge fftxrange2(0)) and (F le fftxrange2(1)))))]
  fftyrange_all=[min(sfft2),max(sfft2)]
  ;;DC;; <-

  CASE event_idx OF
     0: plot, time*3600., plotarray,/XSTY,/YSTY, YTITLE='[nT]', XTICKFORMAT='tticks', $
          YMARGIN=[3,2],XMARGIN=[9,1],TITLE=titl(k2)+' '+datfile
     1: plot,F,sfft(0:n21-1),/xsty,/ysty, /ylog,XTITLE='Hz',YTITLE='Amplitude pT/sqrt(Hz)]-> Bx',$
          YMARGIN=[3,2],XMARGIN=[9,1],TITLE=titl(k2)+' '+datfile , yrange=fftyrange_all
     2: plot,F,sfft(0:n21-1),/xsty,ystyle=1, /ylog,XTITLE='Hz',YTITLE='Amplitude [pT/sqrt(Hz)]-> Bx',$
                XRANGE=fftxrange2,YMARGIN=[3,2],XMARGIN=[9,1],$
          TITLE=titl(k2)+' '+datfile, yrange=fftyrange_z
         ELSE: MESSAGE, "NOTHING"
    ENDCASE
  ENDIF
  ;===================================================================
  ;----To plot The Byz Options----------------------------------------------
  IF eventval EQ 'BYZBUTTON' THEN BEGIN
   WSET, valueyz
  if ((k2) mod 2) eq 1 then plotarray=sqrt(indata(1,*)^2+indata(2,*)^2) $
                                  else plotarray= sqrt(outdata(1,*)^2+outdata(2,*)^2)
  plotarray=transpose(plotarray) & meanbxout = mean(plotarray)
  N21 = fix(count/2)+1 & F = findgen(n21)
  F = F/(count*dt) & sfft=1000.*ABS(FFT(plotarray-meanbxout,-1))

  ;;DC;; ->
  sfft2=sfft(1:n21-2)
  fftyrange_z=[fftyrange(0)>min(sfft2(where((F ge fftxrange2(0)) and (F le fftxrange2(1)) and (F ge 1e-9)))),$
             fftyrange(1)<max(sfft2(where((F ge fftxrange2(0)) and (F le fftxrange2(1)))))]
  fftyrange_all=[min(sfft2),max(sfft2)]
  ;;DC;; <-

  CASE event_idx OF
     0: plot, time*3600., plotarray,/XSTY,/YSTY,YTITLE='[nT]', XTICKFORMAT='tticks', $
          YMARGIN=[3,2],XMARGIN=[9,1],TITLE=titl(k2)+' '+datfile
     1: plot,F,sfft(0:n21-1),/xsty,/ysty, /ylog,XTITLE='Hz',YTITLE='Amplitude [pT/sqrt(Hz)]-> Byz',$
          YMARGIN=[3,2],XMARGIN=[9,1],TITLE=titl(k2)+' '+datfile , yrange=fftyrange_all
     2: plot,F,sfft(0:n21-1),/xsty,/ysty, /ylog,XTITLE='Hz',YTITLE='Amplitude [pT/sqrt(Hz)]-> Byz',$
          XRANGE=fftxrange2,YMARGIN=[3,2],XMARGIN=[9,1],$
          TITLE=titl(k2)+' '+datfile,yrange=fftyrange_z
        ELSE: MESSAGE, "NOTHING"
    ENDCASE
  ENDIF
  ;==============================================================
  ;----To plot The B Options------------------------------------------
  IF eventval EQ 'BBUTTON' THEN BEGIN
   WSET, valueb
  if ((k2) mod 2) eq 1 then $
          plotarray=sqrt((indata(0,*)^2)+(indata(1,*)^2)+(indata(2,*)^2)) $
  else    plotarray= sqrt((outdata(0,*)^2)+(outdata(1,*)^2)+(outdata(2,*)^2))
  plotarray=transpose(plotarray) & meanbxout = mean(plotarray)
  N21 = fix(count/2)+1 & F = findgen(n21)
  F = F/(count*dt) & sfft=1000.*ABS(FFT(plotarray-meanbxout,-1))

  ;;DC;; ->
  sfft2=sfft(1:n21-2)
  fftyrange_z=[fftyrange(0)>min(sfft2(where((F ge fftxrange2(0)) and (F le fftxrange2(1)) and (F ge 1e-9)))),$
             fftyrange(1)<max(sfft2(where((F ge fftxrange2(0)) and (F le fftxrange2(1)))))]
  fftyrange_all=[min(sfft2),max(sfft2)]
  ;;DC;; <-

  CASE event_idx OF
     0: plot, time*3600.d0 ,plotarray, /XSTY,/YSTY,YTITLE='[nT]',XTICKFORMAT='tticks',$
          YMARGIN=[3,2],XMARGIN=[9,1],TITLE=titl(k2)+' '+datfile
     1: plot,F,sfft(0:n21-1),/xsty,/ysty, /ylog,XTITLE='Hz',YTITLE='Amplitude [pT/sqrt(Hz)]-> B',$
          YMARGIN=[3,2],XMARGIN=[9,1],TITLE=titl(k2)+' '+datfile , yrange=fftyrange_all
      2: plot,F,sfft(0:n21-1),/xsty,/ysty, /ylog,XTITLE='Hz',YTITLE='Amplitude [pT/sqrt(Hz)]-> B',$
          XRANGE=fftxrange2,YMARGIN=[3,2],XMARGIN=[9,1],$
          TITLE=titl(k2)+' '+datfile, yrange=fftyrange_z
         ELSE: MESSAGE, "NOTHING"
    ENDCASE
  ENDIF

end

;==============================================================
; A procedure to input  the CLUSTER FGM files in FS coordinates
;==============================================================
PRO data
;--------------------------------------------------------------
COMMON COUNTER
COMMON INOUT
COMMON RECORD
COMMON PATH_CFG
COMMON FILES
COMMON KSAVE
if strupcase(!d.name) ne 'X' then $
    while(strpos(inp,'/') ge 0) do strput,inp,'\',strpos(inp,'/')
;datfile = DIALOG_PICKFILE(FILTER='c'+scid+'*.uncal',path=inp)
datfile = DIALOG_PICKFILE(FILTER='c'+scid+'_*.uncal',path=inp)
if strlen(datfile) lt 2 then begin icancel=1 &  return & end else icancel=0
lslash=rstrpos(datfile,slash) & undrsc=strpos(strmid(datfile,lslash),'_')
date=strmid(datfile,undrsc+lslash+1,6)
calname='C'+scid+'_20'+date+'_'+version+'.fgmcal'
count=nlines(datfile) & print,count,'  '+datfile,format="(i5,a)"

printf, LOGF, systime()+'  ... open  '+datfile ;;DC;;

;--------------------------------------------------------------
;- parts[0]          :time[hours] / UTC (ISO)
;- [parts[1], parts[2],parts[3]]    :[Bx,By,Bz]
;- parts[4]                           :B
;- parts[8]                         :0/1 (OB/IB)
;- parts[7]                         :range
; - parts[5]                            :freq[Hz] jetzt aus Zeitstatistik ausgerechnet
;---------------------------------------------------------------
fstr=strarr(count)                  ;To copy the input file
time = dblarr(count)
sensor = DBLARR(3,count,2)         ;To save vector of the used sensor0:OB,1:IB
mod1 = INTARR(count)                  ;To save the first digit of the mod
mod2 = INTARR(count)                  ;To save the second digit of the mod
OPENR,10,datfile & readf,10,fstr & close,10
datfile=strmid(datfile,lslash+1) & ii = 0L
WHILE (ii LT count) DO BEGIN
parts=str_sep(strcompress(strtrim(fstr[ii],2)),' ')
if strpos(parts[0],':') ge 0 then begin
    if ii eq 0 then tbstr=strmid(parts(0),strpos(parts[0],':')-2,5)
    dt=1./float(parts[5]) & print,'only nominal frequency - time in ISO-string format!'
endif else begin
    if (ii eq 0 ) then begin
    ti=double(parts[0]) & hh=fix(ti) & mm=fix((ti-hh)*60.)
              tbstr=string(hh,mm,format="(i2,':',i2)")  & ti=ti*3600.
    while(strpos(tbstr,' ') ge 0 ) do strput,tbstr,'0',strpos(tbstr,' ')
     endif else begin if (ii lt 20) then ti=[ti,double(parts[0])*3600.]  & end
endelse
time(ii)=double(parts[0])  & mod1(ii) = fix(parts[8]) & mod2(ii) = fix(parts[7])
outboard=mod1(ii) & range=median(mod2)-2
sensor(0,ii,outboard) = double(parts[1])
sensor(1,ii,outboard) = double(parts[2])
sensor(2,ii,outboard) = double(parts[3])
ii = ii + 1
ENDWHILE
if noopen eq 1 then lastsensor=2*adc+outboard
if noopen eq 0 and (2*adc+outboard) ne lastsensor then noopen=1
dete=ti-shift(ti,1) & dete=dete(where( dete gt 0)) & dt=median(dete)
print,'data aquisition frequency: ',1./dt,' Hz'

calibrate,0,0
show_data, 'BXBUTTON', 2
show_data, 'BYZBUTTON', 2
show_data, 'BBUTTON', 0


END

;---------------------------------------------------------------
PRO calibrate,sflag,aflag
;======= A procedure to calibrate the FGM Data acquiered by the  Data Procedure===
;---------------------------------------------------------------
COMMON MATOFF
COMMON COUNTER
COMMON RECORD
COMMON PATH_CFG
COMMON INOUT
COMMON FILES
outdata = DBLARR(3,count)
indata =  DBLARR(3,count)
I = 0l & k2=2*adc+outboard
spax_out=dblarr(2)
;---------------------------------------------------------------
FOR I = 0L,(count-1)  DO BEGIN               ;to determine the range
CASE mod2[I] OF
2: irange = 0
3: irange = 1
4: irange = 2
5: irange = 3
6: irange = 4
7: irange = 5
ELSE: MESSAGE, "NOTHING"
ENDCASE
;----------------------
 outboard = mod1[i]                          ;to determine the sensor (OB/IB)
;----------------------
if (outboard) then $
indata[*,I]=(mcal[*,*,irange,k2] ## sensor[*,I,outboard])-$
       ocal[*,irange,k2] else $
outdata[*,I]=(mcal[*,*,irange,k2] ## sensor[*,I,outboard]) -$
        ocal[*,irange,k2]
ENDFOR
;-------------Sinus test----------------------------------------
if sflag gt 0 then begin
    comment='yz' & offsc=offsetsc(1:2,K2)
    scratio=mtrxr(2,2,range,K2) &  ayz=mtrxr(1,2,range,K2)
    if outboard then     testsinwa,time,indata,offsc,ayz,scratio,inp+datfile,comment else $
         testsinwa,time,outdata,offsc,ayz,scratio,inp+datfile,comment
  printf, LOGF, systime()+'  ... CALIBRATE: sinus test' ;;DC;;
endif

;-------------Spin axis angles fit-----------------------------------
if aflag eq 1 then begin  angle0=angle(*,k2)
if outboard then    spinaxisa,time,indata,scid,angle0(0:1),datfile,spax_out else $
     spinaxisa,time,outdata,scid,angle0(0:1),datfile,spax_out
  printf, LOGF, systime()+'  ... CALIBRATE: spin axis angles' ;;DC;;
endif
;-------------Spin plane angle fit-----------------------------------
if aflag eq 2 then begin  angle0=[mtrxr(1,2,range,K2),mtrxr(2,2,range,K2)]
if outboard then    spinaxisa,time,indata,scid,angle0(0:1),datfile,spax_out,/spinplane_a else $
     spinaxisa,time,outdata,scid,angle0(0:1),datfile,spax_out,/spinplane_a
  printf, LOGF, systime()+'  ... CALIBRATE: spin plane angle' ;;DC;;
endif
;-------------Spin plane offset fit-----------------------------------
if aflag eq 3 then begin  angle0=offsetsc(1:2,K2)
  if outboard then spinaxisa,time,indata,scid,angle0(0:1),datfile,spax_out,/spinplane_offs else $
        spinaxisa,time,outdata,scid,angle0(0:1),datfile,spax_out,/spinplane_offs
  printf, LOGF, systime()+'  ... CALIBRATE: spacecraft offset' ;;DC;;
;  offsetsc[1,k2]=spax_out[0]
;  offsetsc[2,k2]=spax_out[1]
;  savecfg2file, 'updated.cfg', k2
endif




;;DC;; ->
;---------------- line 1 columns 23 fit --------
if aflag eq 4 then begin  
  angle0=[mtrxr(1,0,range,K2),mtrxr(2,0,range,K2)]
  if outboard then begin
    spinaxisa,time,indata, scid,angle0(0:1),datfile,spax_out,/l1c23
  endif else begin
    spinaxisa,time,outdata,scid,angle0(0:1),datfile,spax_out,/l1c23
  endelse
  printf, LOGF, systime()+'  ... CALIBRATE: l1c23' ;;DC;;
endif
;;DC;; <-








END ;=====END of the calibration procedure==============================

;--------------------------------------------------
FUNCTION tticks, axis, index, value
;     xticks in hh:mm:ss format
;      eg@mpe.mpg.de
;--------------------------------------------------
hour = LONG(value)/3600
minute = LONG(value-3600 * hour) / 60
sec = value mod 60
RETURN, STRING(hour, minute, sec, $
        FORMAT="(i2.2, ':', i2.2, ':', i2.2)")
END

;========MAIN========MAIN==============MAIN========MAIN======
PRO cls,isc
;==============================================================
COMMON VALUES
COMMON  MATOFF
COMMON KSAVE
COMMON RECORD
COMMON PATH_CFG
COMMON FILES

cfgdir='/home/FGM/cfg/'

noopen=1 & nofirst=0 & lastcfg=0 & adc=0
inpcfgf=cfgdir+'cls.cfg' & datfile=''
nli=file_lines(inpcfgf) & incfg=strarr(nli)


if nli lt 7 then begin print,'ERROR in '+inpcfgf &  print,'cfg-file must have 7 lines: ' & $
print,'FGM-inputpath, calf-outputpath, ADC, init-pattn(cfg/neu), calf-version, init-path, log-path' & stop & end
openr,11,inpcfgf & readf,11,incfg & close,11
scid=string(isc,format="(i1)") & isc=isc-1
adc=fix(strmid(incfg(2),0,1))
if strupcase(!d.name) eq 'X' then slash='/' else slash='\'
inp=strmid(incfg(0),0,rstrpos(incfg(0),slash)+1)
outp=strmid(incfg(1),0,rstrpos(incfg(1),slash)+1)
ext=strmid(incfg(3),0,3)
version=strmid(incfg(4),0,3) 
initpath=strmid(incfg(5),0,rstrpos(incfg(5),slash)+1)
logpath=strmid(incfg(6),0,rstrpos(incfg(6),slash)+1)
;;DC;; ->
if strpos(inp,'_') gt 0 then begin
month=strmid(inp,strpos(inp,'_')+1,2)
yy=strmid(inp,strpos(inp,'_')-2,2)
openw, LOGF, logpath+'dailycal_'+yy+month+'.log', /get_lun, /append
printf, LOGF, systime()+' IDL> cls, '+strcompress(string(isc+1))
;;DC;; <-
endif else begin
openw,LOGF,logpath+'ex.log',/get_lun,/append
printf, LOGF, systime()+' IDL> cls, '+strcompress(string(isc+1))
endelse

cfgread
cfgcalc

wttle='   CLUSTER_'+scid+' TOOL       >>IGM TU-Braunschweig<<'
base = WIDGET_BASE(TITLE=wttle,/Column)
;-------------------------------------------------------------
;=======The Buttons frame=========================================
knopf=WIDGET_BASE(base,/ROW,/FRAME)

;;DC;; ->
;dinorm=1.*[850,600] & device,get_screen_size=di
;wscf=di/dinorm*[0.3,0.5]
;ysi=fix(di(1)*wscf(1)) & xsi=fix(di(0)*wscf(0));& print,dinorm,di,wscf,xsi,ysi
device,get_screen_size=di
xsi=fix(600.<di(0)/2.)
ysi=fix(xsi*850./600.<di(1))
;;DC;; <-

dframe = WIDGET_BASE(base, /COLUMN,Y_SCROll_SIZE=ysi,X_SCROll_SIZE=xsi)
wxsi=fix(ysi*0.6) & wysi=fix(ysi/3.1)
;*********************************************** Window of the Bx component
optionx = ['Bx      ','FFT      ','FFTzoom']
drawx = WIDGET_BASE(dframe, /ROW)
listx = WIDGET_DROPLIST(drawx,VALUE=optionx,UVALUE='BXBUTTON')
windowx = WIDGET_DRAW(drawx, XSIZE=wxsi, YSIZE=wysi,retain=2)
;*********************************************** Window of the Byz(Bperp)
optiony = ['Byz     ','FFT      ','FFTzoom']
drawy = WIDGET_BASE(dframe, /ROW)
listy = WIDGET_DROPLIST(drawy,VALUE=optiony,UVALUE='BYZBUTTON')
windowy = WIDGET_DRAW(drawy, XSIZE=wxsi, YSIZE=wysi,retain=2)
;*********************************************** Window of the Magnitude B
optionb = ['B       ','FFT      ','FFTzoom']
drawb = WIDGET_BASE(dframe, /ROW)
listb = WIDGET_DROPLIST(drawb,VALUE=optionb,UVALUE='BBUTTON')
windowb = WIDGET_DRAW(drawb, XSIZE=wxsi, YSIZE=wysi,retain=2)
;***************************************************
menu = CW_PdMenu(knopf, /RETURN_NAME, '0\   Select input file   ',uvalue='THEMENU')
menucfg = CW_PdMenu(knopf, /RETURN_NAME, ['1\    Calibration    ',$
    '0\Show cal-table','0\Align spin axis','0\Spin plane angle',$
    '0\Spin plane offset',$
    '0\Spin axis angles and gain' ,$ ;;DC;;
    '2\   Sinus test    '],uvalue='CFGMENU')
menuoff=CW_PdMenu(knopf, /RETURN_NAME, '0\        CLOSE        ',uvalue='MOFF')
;=============================================================
WIDGET_CONTROL, base, /REALIZE
;=============================================================
;      GET  the Window Number of each Draw Widget
WIDGET_CONTROL, windowx, GET_VALUE=valuex
WIDGET_CONTROL, windowy, GET_VALUE=valueyz
WIDGET_CONTROL, windowb, GET_VALUE=valueb
;=============================================================
XManager, "cls", base, $               ;register the widgets with the XManager
EVENT_HANDLER = "clus_ev", $           ;and pass through the group leader if this
GROUP_LEADER = base, /NO_BLOCK         ;routine is to be called from some group leader.


END
