forward_function data, cfgread, cfgcalc, savecfg2file, save_calfile, $
                 calibrate, check_minvar, nlines

compile_opt idl2


PRO CLS_INI, isc
;*************************************************************************
COMMON VALUES, valuex, valueyz, valueb
COMMON MATOFF,offset, offsetsc, mtrxr, mtrxdr,mtrxsc,angle,ocal,mcal
COMMON RECORD,adc,sensor,mod1,mod2,dt,scid,outboard,range,tbstr
COMMON COUNTER, count
COMMON INOUT, indata,outdata,time
COMMON FILES,datfile,calname,ext,version
COMMON PATH_CFG,inp,outp,slash,initpath
COMMON KSAVE, K2,noopen,lastsensor,icancel,nofirst,lastcfg
COMMON EDITMAT,ofst01,ofst02,ofst03,$
ofstwdgt1,ofst11,ofst12,ofst13,$
ofstwdgt2,ofst21,ofst22,ofst23,$
ofstwdgt3,ofst31,ofst32,ofst33,$
ofstwdgt4,ofst41,ofst42,ofst43,$
ofstwdgt5,ofst51,ofst52,ofst53,$
ofstwdgtsc,ofstsc1,ofstsc2,ofstsc3,$
mtrx011,mtrx012,mtrx013,mtrx021,mtrx022,mtrx023,mtrx031,mtrx032,mtrx033,$
mtrx111,mtrx112,mtrx113,mtrx121,mtrx122,mtrx123,mtrx131,mtrx132,mtrx133,$
mtrx211,mtrx212,mtrx213,mtrx221,mtrx222,mtrx223,mtrx231,mtrx232,mtrx233,$
mtrx311,mtrx312,mtrx313,mtrx321,mtrx322,mtrx323,mtrx331,mtrx332,mtrx333,$
mtrx411,mtrx412,mtrx413,mtrx421,mtrx422,mtrx423,mtrx431,mtrx432,mtrx433,$
mtrx511,mtrx512,mtrx513,mtrx521,mtrx522,mtrx523,mtrx531,mtrx532,mtrx533,$
mtrxsc11,mtrxsc12,mtrxsc13,mtrxsc21,mtrxsc22,mtrxsc23,mtrxsc31,mtrxsc32,mtrxsc33,$
mtrxdr11,mtrxdr12,mtrxdr13,mtrxdr21,mtrxdr22,mtrxdr23,mtrxdr31,mtrxdr32,mtrxdr33,$
winkel1,winkel2,winkel3

sflag   = 0
aflag   = 3

;**********************************************************
; read cls.cfg
noopen=1 & nofirst=0 & lastcfg=0 & adc=0                                           
inpcfgf='/home/FGM/cfg/cls_ini.cfg' & datfile=''
nli=nlines(inpcfgf) & incfg=strarr(nli)
openr,11,inpcfgf & readf,11,incfg & close,11
scid=string(isc,format="(i1)") & isc=isc-1
adc=fix(strmid(incfg(2),0,1))
if strupcase(!d.name) eq 'X' then slash='/' else slash='\'
inp=strmid(incfg(0),0,rstrpos(incfg(0),slash)+1) 
outp=strmid(incfg(1),0,rstrpos(incfg(1),slash)+1)
ext=strmid(incfg(3),0,3)
version=strmid(incfg(4),0,3)
yy=strmid(incfg(5),0,2)
y=strmid(incfg(5),1,1)
mm=strmid(incfg(6),0,2)
ddbeg = strmid(incfg(7),0,2)
ddend = strmid(incfg(8),0,2)
inp=inp+slash+yy+'_'+mm+slash

initpath='/home/FGM/data/ini/'

;**********************************************************

;;DC;; ->
openw, LOGF, '/home/FGM/log/dailycal/dailycal_'+yy+mm+'.log', /get_lun, /append  
printf, LOGF, 'IDL> cls_ini, '+strcompress(string(isc+1))
free_lun, LOGF
;;DC;; <-

yymm  = yy+mm
ddarr = STRING(FINDGEN(31)+1.0, FORMAT='(I2.2)')
dd    = ddarr[ WHERE(ddarr GE ddbeg AND ddarr LE ddend) ]

rstr = 'r2'

ndd = N_ELEMENTS(dd)
FOR idd=0, ndd-1 DO BEGIN

  inpfile = inp + 'c' + scid + '_' + yymm + dd[idd] + '*' + rstr + '{,_}.uncal'
  inarray = FILE_SEARCH(inpfile, COUNT=nfiles)
  
  ;;DC;; ->
  IF nfiles EQ 0 THEN BEGIN
          PRINT, yymm + dd[idd] +': '+ inpfile + ': no data availible in ' + rstr
          spawn, '/usr/bin/beep -f 50 -l 300'
          continue
  ENDIF
  ;;DC;; <-
  
  IF nfiles EQ 1 THEN datfile = inarray[0]
  ; if more than one *.uncal files exists in r2 
  ; then choose file with lowest variance
  IF nfiles GT 1 THEN CHECK_MINVAR, inarray, nfiles, index ELSE index = 0
  datfile = inarray[index]

  ;**********************************************************
  DATA
  if (count ne 0) then begin
    CFGREAD
    CFGCALC
    CALIBRATE, sflag, aflag
    CFGCALC

    ;**********************************************************
    isensor=2*adc+outboard
    ssensor=string(isensor+1,format="(i1)")
    fname='/home/FGM/data/ini/cal'+scid+'_'+ssensor+'d.neu' & print,fname
    savecfg2file,fname,isensor

    ;**********************************************************

    isensor=adc+mod1(0) & tbst=strmid(tbstr,0,2)+strmid(tbstr,3,2)
    ssensor=string(isensor,format="(i1)")
    fname=datfile+' '
    strput,fname,'_'+version+'.cf',strpos(fname,'.uncal') 
    fname=outp+strtrim(fname)+'gnew' & print,outp+calname 
    print,'saving basic calibration parameters to: ',fname
    savecfg2file,fname,isensor 
    save_calfile
  endif
ENDFOR ; idd

spawn, '/usr/bin/beep -f 10000 -l 10 -r2'

END

;==============================================================
; A procedure to input  the CLUSTER FGM files in FS coordinates
;==============================================================
PRO data
  ;--------------------------------------------------------------
  COMMON COUNTER
  COMMON INOUT
  COMMON RECORD
  COMMON PATH_CFG
  COMMON FILES
  COMMON KSAVE
  if strupcase(!d.name) ne 'X' then $
          while(strpos(inp,'/') ge 0) do strput,inp,'\',strpos(inp,'/')
  ;datfile = DIALOG_PICKFILE(FILTER='c'+scid+'*.uncal',path=inp)
  if strlen(datfile) lt 2 then begin icancel=1 &  return & end else icancel=0
  lslash=strpos(datfile,slash, /REVERSE_SEARCH) & undrsc=strpos(strmid(datfile,lslash),'_')
  date=strmid(datfile,undrsc+lslash+1,6) 
  calname='C'+scid+'_20'+date+'_'+version+'.fgmcal' 
  count=nlines(datfile) & print,count,'  '+datfile,format="(i5,a)"
  ;--------------------------------------------------------------
  ;- parts[0]                     :time[hours] / UTC (ISO)
  ;- [parts[1], parts[2],parts[3]]        :[Bx,By,Bz]
  ;- parts[4]                                     :B
  ;- parts[8]                             :0/1 (OB/IB)
  ;- parts[7]                             :range
  ; - parts[5]                            :freq[Hz] jetzt aus Zeitstatistik ausgerechnet
  ;---------------------------------------------------------------

  if (count ne 0) then begin
    fstr=strarr(count)                      ;To copy the input file
    time = dblarr(count)
    sensor = DBLARR(3,count,2)         ;To save vector of the used sensor0:OB,1:IB
    mod1 = INTARR(count)                  ;To save the first digit of the mod
    mod2 = INTARR(count)                  ;To save the second digit of the mod
    print, 'Datfile: ', datfile
    OPENR,10,datfile & readf,10,fstr & close,10
    datfile=strmid(datfile,lslash+1) & ii = 0L 
    WHILE (ii LT count) DO BEGIN
      parts=str_sep(strcompress(strtrim(fstr[ii],2)),' ')
      if strpos(parts[0],':') ge 0 then begin
          if ii eq 0 then tbstr=strmid(parts(0),strpos(parts[0],':')-2,5)
          dt=1./float(parts[5]) & print,'only nominal frequency - time in ISO-string format!'
      endif else begin 
          if (ii eq 0 ) then begin 
              ti=double(parts[0]) & hh=fix(ti) & mm=fix((ti-hh)*60.)
                    tbstr=string(hh,mm,format="(i2,':',i2)")  & ti=ti*3600. 
              while(strpos(tbstr,' ') ge 0 ) do strput,tbstr,'0',strpos(tbstr,' ') 
           endif else begin if (ii lt 20) then ti=[ti,double(parts[0])*3600.]  & end
      endelse
      time(ii)=double(parts[0])  & mod1(ii) = fix(parts[8]) & mod2(ii) = fix(parts[7])
      outboard=mod1(ii) & range=median(mod2)-2
      sensor(0,ii,outboard) = double(parts[1])
      sensor(1,ii,outboard) = double(parts[2])
      sensor(2,ii,outboard) = double(parts[3])
      ii = ii + 1
    ENDWHILE
    if noopen eq 1 then lastsensor=2*adc+outboard
    if noopen eq 0 and (2*adc+outboard) ne lastsensor then noopen=1
    dete=ti-shift(ti,1) & dete=dete(where( dete gt 0)) & dt=median(dete)
    print,'data aquisition frequency: ',1./dt,' Hz'
  endif else begin
    print, '### file '+datfile+' is empty! ###'
    spawn, '/usr/bin/beep -f 50 -l 1000'
  endelse
END

;===========================================================
PRO cfgread

  COMMON MATOFF
  COMMON RECORD
  COMMON FILES
  COMMON PATH_CFG
  ;===========================================================
  strng = STRARR(28)
  offset = DBLARR(3,6,4)
  offsetsc = DBLARR(3,4)
  mtrxr = DBLARR(3,3,6,4)
  mtrxsc = DBLARR(3,3,4)
  mtrxdr = DBLARR(3,3,4)
  angle =  DBLARR(3,4)
  strngc = ''
  cary1 = 0.0d0
  cary2 = 0.0d0
  cary3 = 0.0d0

  ;=============================================================
  ;   READ ALL CONFIGURATION PARAMETERS
  ;   by means of a main FOR LOOP on the parameter K
  ;=============================================================
  L = 2
  FOR K=0,3 DO BEGIN
    ssensor=string(K+1,format="(i1)")
    nrranges=5
    fcfgnam=         initpath+'cal'+scid+'_'+ssensor+'d.'+ext
    ;fcfgnam='/home/FGM/data/ini/cal'+scid+'_'+ssensor+'d.'+ext
    if file_lines(fcfgnam) gt 40 then nrranges=6
    OPENR,L, fcfgnam
    ;print, fcfgnam
    ;=============================================================
    ;  INPUT OF the OFFSETS of all ranges
    ;=============================================================
    FOR I=0,nrranges-1 DO BEGIN
      READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
      strng[I] = strngc
      offset[0,I,K] = cary1
      offset[1,I,K] = cary2
      offset[2,I,K] = cary3
    ENDFOR
    READF, L, FORMAT='(/)'
    ;=============================================================
    ;         To input the offset spacecraft matrix
    ;=============================================================
    READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
    strng[nrranges] = strngc
    offsetsc[0,K] = cary1
    offsetsc[1,K] = cary2
    offsetsc[2,K] = cary3

    READF, L, FORMAT='(/)'
    ;=============================================================
    ;  INPUT of the MATRIX_r for all ranges
    ;=============================================================
    ; The multiplication of the range factors given by Uli Ausster
    ; will be taken into consideration only at the calculation
    ; program
    ;-------------------------------------------------------------
    FOR J=0,nrranges-1 DO BEGIN
      FOR I=0,2 DO BEGIN
        READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
        strng[5] = strngc
        mtrxr[0,I,J,K] = cary1
        mtrxr[1,I,J,K] = cary2
        mtrxr[2,I,J,K] = cary3
      ENDFOR
      READF, L, FORMAT='(/)'
    ENDFOR
    ;============================================================
    ;         INPUT of the spacecraft matrix_sc
    ;===========================================================
    FOR I=0,2 DO BEGIN
      READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
      mtrxsc[0,I,K] = cary1
      mtrxsc[1,I,K] = cary2
      mtrxsc[2,I,K] = cary3
    ENDFOR
    READF, L, FORMAT='(/)'
    ;===========================================================
    ;        INPUT of the rotation matrx_dr
    ;===========================================================
    FOR I=0,2 DO BEGIN
      READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
      mtrxdr[0,I,K] = cary1
      mtrxdr[1,I,K] = cary2
      mtrxdr[2,I,K] = cary3
    ENDFOR
    READF, L, FORMAT='(/)'
    ;===========================================================
    ;    To read the angle array
    ;===========================================================
    READF, L, FORMAT='(A10,3(F0))', strngc,cary1,cary2,cary3
    angle[0,K] = cary1
    angle[1,K] = cary2
    angle[2,K] = cary3
    CLOSE, L
    ;==========================================================
  ENDFOR   ;To end the FOR  K loop
  ;==========================================================
END ;====End of the Configuration-READ============================








;==========================================================
PRO cfgcalc
  ;==Calculation of the Calibration Matrices and Offsets===
  COMMON  MATOFF
  PI = !dpi
  ;==(1) The Rotation matrix MROT===================================
  xymtrx = DBLARR(3,3,4)
  xzmtrx = DBLARR(3,3,4)
  yzmtrx = DBLARR(3,3,4)
  mrot = DBLARR(3,3,4)
  mcal = DBLARR(3,3,6,4)
  ocal = DBLARR(3,6,4)
  ;-----------------------------------------------------------
  FOR K=0,3 DO BEGIN
    xymtrx[0,0,K] = cos(angle[0,K]*(PI/180.d0))
    xymtrx[1,0,K] = sin(angle[0,K]*(PI/180.d0))
    xymtrx[2,0,K] = 0.d0
    ;
    xymtrx[0,1,K] = -sin(angle[0,K]*(PI/180.d0))
    xymtrx[1,1,K] = cos(angle[0,K]*(PI/180.d0))
    xymtrx[2,1,K] = 0.d0
    ;
    xymtrx[0,2,K] = 0.d0
    xymtrx[1,2,K] = 0.d0
    xymtrx[2,2,K] = 1.d0
    ;-----------------------------------------------------------
    xzmtrx[0,0,K] = cos(angle[1,K]*(PI/180.d0))
    xzmtrx[1,0,K] = 0.d0
    xzmtrx[2,0,K] = sin(angle[1,K]*(PI/180.d0))
    ;
    xzmtrx[0,1,K] = 0.d0
    xzmtrx[1,1,K] = 1.d0
    xzmtrx[2,1,K] = 0.d0
    ;
    xzmtrx[0,2,K] = -sin(angle[1,K]*(PI/180.d0))
    xzmtrx[1,2,K] = 0.d0
    xzmtrx[2,2,K] = cos(angle[1,K]*(PI/180.d0))
    ;-----------------------------------------------------------
    yzmtrx[0,0,K] = 1.d0
    yzmtrx[1,0,K] = 0.d0
    yzmtrx[2,0,K] = 0.d0
    ;
    yzmtrx[0,1,K] = 0.d0
    yzmtrx[1,1,K] = cos(angle[2,K]*(PI/180.d0))
    yzmtrx[2,1,K] = sin(angle[2,K]*(PI/180.d0))
    ;
    yzmtrx[0,2,K] = 0.d0
    yzmtrx[1,2,K] = -sin(angle[2,K]*(PI/180.d0))
    yzmtrx[2,2,K] = cos(angle[2,K]*(PI/180.d0))
    ;
    mrot[*,*,K] = yzmtrx[*,*,K] ## xzmtrx[*,*,K] ## xymtrx[*,*,K] ## mtrxdr[*,*,K]
  ENDFOR
  ;-------------------------------------------------------------
  ;==(2) The Calibration  matrix MCAL====================================
  factor = [1.0d0,1.0d0,1.0d0,1.0d0,1.0d0,1.0d0]
  FOR K=0,3 DO BEGIN
    FOR J=0,5 DO mcal[*,*,J,K] =  mrot[*,*,K] ## mtrxsc[*,*,K] ## (mtrxr[*,*,J,K]*factor[J])
  ENDFOR
    ;==(3) The Calibration Offset OCAL=====================================
  FOR K=0,3 DO BEGIN
    FOR J=0,5 DO ocal[*,J,K] = mrot[*,*,K] ## mtrxsc[*,*,K] ## offsetsc[*,K] +  $
                               mrot[*,*,K] ## mtrxsc[*,*,K] ## (mtrxr[*,*,J,K]*factor[J]) ## offset[*,J,K]
  ENDFOR
  ;-------------------------------------------------------------
  ;PRINT, ocal,mcal
  ;--Opening files to out put the OCAL and MCAL Matrices---------------------
  ;--------------------------------------------------------------
  ;OPENW,20,'ofstcal.dat' & printf,20,ocal & CLOSE,20
  ;OPENW,20,'matcal.dat' & printf,20,mcal & CLOSE,20
END;==========End of the calibrations calculations=========================


;===============================================================
PRO savecfg2file,fname,isensor 
  ;---------------------------------------------------------------
  ;-------Output of the new Basic calibration parameters in "*.neu" files------------
  ;---------------------------------------------------------------
  COMMON KSAVE
  COMMON EDITMAT
  COMMON MATOFF
  COMMON RECORD
  result1 = DBLARR(3,6,4)
  result2 = DBLARR(3,4)
  result3 = DBLARR(3,3,6,4)
  result4 = DBLARR(3,3,4)
  result5 = DBLARR(3,3,4)
  result6 = DBLARR(3,4)
  I=isensor & m=15 
  OPENW,m,fname
  ;------------------------------
  FOR T=0,5 DO BEGIN
    result1 = offset[*,T,I]
    name = STRCOMPRESS('Offset_r'+STRING(T)+'=',/REMOVE_ALL)
    PRINTF,m,name,result1
  ENDFOR
  PRINTF,m,' '
  ;------------------------------
  result2 = offsetsc[*,I]
  PRINT, 'SAVE ', result2, offsetsc[*,I]
  PRINTF,m,FORMAT='(A10,F13.7,2x,F13.7,2x,F13.7)','offset_sc=',result2
  PRINTF,m,' '
  ;------------------------------
  FOR T=0,5 DO BEGIN
    FOR Y=0,2 DO BEGIN
      result3 = mtrxr[*,Y,T,I]
      name = STRCOMPRESS('Matrix_r'+STRING(T)+'=',/REMOVE_ALL)
      PRINTF,m,FORMAT='(A10,F13.7,2x,F13.7,2x,F13.7)',name,result3
    ENDFOR
    PRINTF,m,' '
  ENDFOR
  ;------------------------------
  FOR Y=0,2 DO BEGIN
    result4 = mtrxsc[*,Y,I]
    PRINTF,m,FORMAT='(A10,F13.7,2x,F13.7,2x,F13.7)','Matrix_SC= ',result4
  ENDFOR
  PRINTF,m,' '
  ;-----------------------------
  FOR Y=0,2 DO BEGIN
    result5 = mtrxdr[*,Y,I]
    PRINTF,m,FORMAT='(A10,F13.7,2x,F13.7,2x,F13.7)','Matrix_dr= ',result5
  ENDFOR
  PRINTF,m,' '
  ;-----------------------------
  result6 = angle[*,I]
  PRINTF,m,FORMAT='(A10,F13.7,2x,F13.7,2x,F13.7)','Matrix_xyz',result6
  PRINTF,m,' ' & CLOSE,15
END ;save  basic parameters to ./cal#_id.neu' files or to output directory for statistics

;-----------------------------------------------------------
PRO save_calfile
  ;----To output the OCAL values in the MUENCHEN Format-------
  COMMON MATOFF
  COMMON RECORD
  COMMON FILES
  COMMON PATH_CFG

  ;;;DC;; ->
  ;;; saving here range 7 calibration parameters to daily range 7 calfile MUST be renamed for use in FGM s/w
  ;calf_r7=outp+strmid(calname,0,strpos(calname,'_V'))+'range7.fgmcal'
  ;openw,21,calf_r7
  ;for j=0,2 do printf,21,ocal(j,5,0)
  ;for l=0,2 do for j=0,2 do printf,21,mcal(j,l,5,0)
  ;close,21
  ;;; end save range 7
  ;;;DC;; <-

  OPENW,21,outp+calname
  if adc eq 0 then PRINTF,21,'1  T24:00:00.000' else PRINTF,21,'2  T24:00:00.000'
  FOR S=0,3 DO BEGIN
    FOR J=0,2 DO BEGIN
      calvalue1 = ocal(J,0,S)
      calvalue2 = ocal(J,1,S)
      calvalue3 = ocal(J,2,S)
      calvalue4 = ocal(J,3,S)
      calvalue5 = ocal(J,4,S)
      label = STRCOMPRESS('S'+STRING(S+1)+'_0'+STRING(J+1),/REMOVE_ALL)
      fo1='(5(F14.7),3x,A5)
      PRINTF,21,FORMAT=fo1,calvalue1,calvalue2,calvalue3,calvalue4,calvalue5,label
      ;
    ENDFOR
    ;----To output the MCAL values in the MUENCHEN Format-------
    ;
    FOR L=0,2 DO BEGIN
      FOR J=0,2 DO BEGIN
        calvalue1 = mcal(J,L,0,S)
        calvalue2 = mcal(J,L,1,S)
        calvalue3 = mcal(J,L,2,S)
        calvalue4 = mcal(J,L,3,S)
        calvalue5 = mcal(J,L,4,S)
        label=STRCOMPRESS('S'+STRING(S+1)+'_'+STRING(L+1)+STRING(J+1),/REMOVE_ALL)
        ;
        PRINTF,21,FORMAT=fo1,calvalue1,calvalue2,calvalue3,calvalue4,calvalue5,label
        ;
      ENDFOR
    ENDFOR
  ENDFOR
  PRINTF,21,''
  PRINTF,21,'S1 = OB + ADC1, S2 = IB + ADC1, S3 = OB + ADC2, S4 = IB + ADC2'
  PRINTF,21,'ranges = 2,3,4,5,6 => 64, 256, 1024, 4096, 16384 nT'
  gr_text=['F9_fsr, data from ground calibration tu-bs magnetsrode 08/09 1999',$
           'F6_fsr, data from ground calibration tu-bs magnetsrode 11 1998',$
           'F7_fsr, data from ground calibration tu-bs magnetsrode 01/02 1999',$
           'F8_fsr, data from ground calibration tu-bs magnetsrode 07/08 1999']
  PRINTF,21,gr_text(fix(scid)-1)
  sensstr=['OB','IB']
  PRINTF,21,sensstr(mod1(0))+'  r',mod2(0),'  '+tbstr,format="(a,i1,a)"
  PRINTF,21,calname
  CLOSE,21
END;==========End of save calibration file

;---------------------------------------------------------------
PRO calibrate,sflag,aflag  
;======= A procedure to calibrate the FGM Data acquiered by the  Data Procedure===
;---------------------------------------------------------------
COMMON MATOFF
COMMON COUNTER
COMMON RECORD
COMMON PATH_CFG
COMMON INOUT
COMMON FILES
outdata = DBLARR(3,count)
indata =  DBLARR(3,count)
I = 0l & k2=2*adc+outboard 
;---------------------------------------------------------------
FOR I = 0L,(count-1)  DO BEGIN               ;to determine the range 
CASE mod2[I] OF
2: irange = 0
3: irange = 1
4: irange = 2
5: irange = 3
6: irange = 4
7: irange = 5
ELSE: MESSAGE, "NOTHING"
ENDCASE
;----------------------
 outboard = mod1[i]                          ;to determine the sensor (OB/IB)
;----------------------
if (outboard) then $
indata[*,I]=(mcal[*,*,irange,k2] ## sensor[*,I,outboard])-$
		ocal[*,irange,k2] else $
outdata[*,I]=(mcal[*,*,irange,k2] ## sensor[*,I,outboard]) -$
		 ocal[*,irange,k2]
ENDFOR
;-------------Sinus test----------------------------------------
if sflag gt 0 then begin  
	comment='yz' & offsc=offsetsc(1:2,K2) 
	scratio=mtrxr(2,2,range,K2) &  ayz=mtrxr(1,2,range,K2)
  	if outboard then 	testsinwa,time,indata,offsc,ayz,scratio,inp+datfile,comment else $
  		 	testsinwa,time,outdata,offsc,ayz,scratio,inp+datfile,comment 
endif

;-------------Spin axis angles fit-----------------------------------
if aflag eq 1 then begin  angle0=angle(*,k2) 
if outboard then 	spinaxisa_multi,time,indata,scid,angle0(0:1),datfile else $
  		spinaxisa_multi,time,outdata,scid,angle0(0:1),datfile
endif
;-------------Spin plane angle fit-----------------------------------
if aflag eq 2 then begin  angle0=[mtrxr(1,2,range,K2),mtrxr(2,2,range,K2)]
if outboard then 	spinaxisa_multi,time,indata,scid,angle0(0:1),datfile,/spinplane_a else $
  		spinaxisa_multi,time,outdata,scid,angle0(0:1),datfile,/spinplane_a
endif
;-------------Spin plane offset fit-----------------------------------
if aflag eq 3 then begin  angle0=offsetsc(1:2,K2) 
if outboard then 	spinaxisa_multi,time,indata ,scid,angle0(0:1),afinal,datfile,/spinplane_offs else $
  		        spinaxisa_multi,time,outdata,scid,angle0(0:1),afinal,datfile,/spinplane_offs
endif

temp_oy = ' '
temp_oz = ' '
diff = afinal - angle0
;IF ABS(diff[0]) LT 0.35 AND ABS(diff[1]) LT 0.35 THEN offsetsc[1:2,K2] = afinal ELSE BEGIN $
IF ABS(diff[0]) LT 0.75 AND ABS(diff[1]) LT 0.75 THEN offsetsc[1:2,K2] = afinal ELSE BEGIN $
	spawn, '/usr/bin/beep -f 50 -l 50 -r 3'
        PRINT, 'DIFF TOO LARGE', diff
	READ, temp_oy, PROMPT='Enter new parameter Oy: '
	IF temp_oy EQ '' THEN afinal = angle0 ELSE BEGIN
		READ, temp_oz, PROMPT='Enter new parameter Oz: '
		afinal = [DOUBLE(temp_oy), DOUBLE(temp_oz)]
	ENDELSE
	offsetsc[1:2,K2] = afinal
ENDELSE

END ;=====END of the calibration procedure==============================


PRO check_minvar, inarray, nfiles, index

minvar   = DBLARR(nfiles)
;!P.MULTI = [0, 1, nfiles]

print, 'more than one uncal file found !!'
spawn, '/usr/bin/beep -f 50 -l 1000'

FOR i=0, nfiles-1 DO BEGIN
	record = READ_ASCII(inarray[i])
	time   = DOUBLE(record.FIELD01[0,*])
	bx     = DOUBLE(record.FIELD01[1,*])
	by     = DOUBLE(record.FIELD01[2,*])
	bz     = DOUBLE(record.FIELD01[3,*])
	b      = DOUBLE(record.FIELD01[4,*])
	bperp  = SQRT(by*by + bz*bz)

	minvar[i]  = STDDEV(bperp, /NAN)
	;PLOT, time, bperp

ENDFOR

temp = MIN(minvar, index)
PRINT, minvar
PRINT, index

END ;=====END of check_minvar==============================


;---------------------------------------------------------    
FUNCTION nlines,file
;      INPUT :  filename for an ASCII file
;      OUTPUT:  number of lines
;      to be used instead spawn,'wc -l '+file for windows IDL compatibility                       
;      eg@mpe.mpg.de
;----------------------------------------------------------    
usg='USAGE : result=nlines(file)'
if n_elements(file) eq 0 then begin print,usg & return,-1 & end
if strupcase(!d.name) eq 'X' then begin
  spawn,'wc -l '+file,nrli & i=long(nrli(0)) & end else begin
  i=0l & ss=strarr(1) & openr,11,file
  while not eof(11) do begin readf,11,ss & $
       if strlen(ss(0)) gt 1 then i=i+1l & end
  close,11 & endelse
return,i
END


