; Spectral analysis of magnetic field magnitude and/or components
; mod. 15/11/2001 for Cluster (eg@mpe.mpg.de)
; accepts 2 time-formats: hour-of-day and iso-time-string
; PLOT saved as "bmp" for !d.name='win' and "gif" for !d.name='x'
; 20/06/2002 by eg => reads B,Bx,Byz,
;				   => makes spectro for B & min([Bx,Byz])
;				   => padds with zero missing values
; 18/03/2003 keeps input-filename for output
; 10/03/2004 add file path to output directory -> outpdir                   SebSch
; 11/03/2004 input and output file path depends on operating system         SebSch
;            delete .gif output option, .bmp output works also with linux   SebSch
;
; 2009       added one hour markings to the spectrogram     DC
;            read cfg from fgm_spectra.cfg                  DC
; Sep 2009   added range change markings                    DC
; Oct 2009   fix the spectrogram scale                      DC
; Mar 2010   add range labels                               DC
; Oct 2013   add single range uncal times markings          DC
; Feb 2016   fix spectrogram scale for power < maxcolor		DC
;			 removed interp keyword from congrid			DC

; this version should run on deimos not on libs!!!


forward_function data, read_spg, plot_spctgm, plot_spgt, nlines

compile_opt idl2


;---------------------------------------------------MAIN----------------
PRO fgm_spectra;,n_time;,inf
;---------------------------------------------------MAIN----------------

CLOSE, /ALL

;*********************************************************
; input and output filepath
;version = '03'
;inpdir  = '/export/cluster2/pp/output/cal/'
;outpdir = '/export/cluster2/pp/output/cal/specpictures/'
;outpdir = '/export/cluster2/pp/output/cal/formember/me/2005_me_050612_5hz/'

inpdir  = '/home/FGM/data/cal/'
outpdir = '/home/FGM/data/cal/specpictures/'
; outpdir = '/home/FGM/data/cal/specpictures/tmp/'

;********************************************************
; input parameter

cfgf='fgm_spectra.cfg'
nli=nlines(cfgf) & cfgarr=strarr(nli)
openr,11,cfgf & readf,11,cfgarr & close,11
ymstr='20'+strmid(cfgarr(0),0,4) 
sc='{'+strmid(cfgarr(1),0,strpos(cfgarr(1),' '))+'}'
datearray=ymstr + strsplit(strmid(cfgarr(2),0,strpos(cfgarr(2),' ')),',',/extract) 
version=strmid(cfgarr(3),0,2) 

FOR istr=0, N_ELEMENTS(datearray)-1 DO BEGIN

	date = datearray[istr]

	;;;scfiles = FINDFILE( inpdir + 'c'+sc+'_' + date + '_cfdv01.cal', COUNT=n_scfiles)
        scfiles = file_search( inpdir + 'c'+sc+'_' + date + '_cfdv'+version+'.cal', COUNT=n_scfiles)

	PRINT, scfiles

	FOR isc=0, n_scfiles-1 DO BEGIN

		inf = scfiles[isc]

		strsc = STRSPLIT(inf, '_' + date, /EXTRACT, /REGEX)
		strsclen = STRLEN(strsc[0])
		nsc = STRMID(strsc[0], strsclen-1, 1)
		print, nsc

		nrp=2048. & frqlim=1.       ; 1024,2048, 1.

		;;================ don't change anything below this line ===============

		ovl=0.0 & ny=nrp/2 & n_time=0 & nx=0 & nlim=nrp*1500.
		inpf=strmid(inf,0,strpos(inf,'.')) & print,nrp
		inff = inf ;inff=inpdir+inf
		n_time=nlines(inff[0]) & print,inf,n_time
		txt=['',''] & if strpos(strupcase(inff),'FSR') gt 0 then $
		txt=[' (spin-aligned)',' (perpendicular to spin-axis)']

		if n_time lt 2.*nlim then load_file3,bmag,t,n_time,inff[0] $
		else begin $
		   while last_n+nrp le n_time do begin
	;         	loadsequ,bmag,t,n_time,inff[0],tformat
	;         	padd_zero,bmag,t
	;         	spectro
	;         	save_reduced
	   		endwhile
		endelse

		; find gaps in time
		reso=0. & get_gaps,t,nrgaps,gappos,gaplen,reso,nrres,resint

		; define other timeseries: Bspin=Bx, magnitude=B, Bperp=Byz
		; det. smaller component between Bx and Byz (mi=0/1)
		llbl=['B','Bx','Byz'] & ytt=llbl+' [nT]'
		mi=max(bmag(1,*)) gt max(bmag(2,*))
		if mi eq 0 then $
		   print,'SMALLEST COMPONENT IS: '+llbl[1]+txt(0) else $
		   print,'SMALLEST COMPONENT IS: '+llbl[2]+txt(1)

		; select time series, split into same-reso intervals & padd with zeroes
		for sele=0,2 do begin

		for j=0,nrres-1 do begin
		  x=bmag(sele,*)
		  if nrres eq 1 then begin
		     sample_rate=reso
		     first=resint(0) & last=resint(1)
		     gaps=nrgaps
		     endif else begin
		     sample_rate=reso(j)
		     first=resint(0,j) & last=resint(1,j)
		     gaps=resint(2,j)
		     endelse
		  nrpt=last-first+1l
		  x=x(first:last)
		  if gaps gt 0 then begin
		     inside=where(gappos gt first and gappos lt last)
		     pos=gappos(inside)-first & len=gaplen(inside)
		     fill_gaps,x,nrpt,gaps,pos,len
		  endif

		;; make spectrogramm
		  fnam=llbl[sele];+'fft'+string(j,format="(i1)")
		  freso=1.d0/nrp/sample_rate
		  minfres=0.02
		  if freso gt minfres then fact=round(freso/minfres) else fact=1.
		  nx=0 & ny=(fact*nrp)/2
		  make_spgt,x,nrpt,nx,ny,ovl,fnam

		;; save reduced x
		nrlim=20000 & if nrpt gt nrlim then reduce,x,nrpt,nrlim
		fsampl=1./sample_rate
		fnyq=string(fsampl/2.,format="(f4.0)")+' Hz'
		fres=string(1./2./ny/sample_rate,format="(f6.4)")+' Hz'
		flow=string(3./2./ny/sample_rate,format="(f6.4)")+' Hz'
		fhigh=string(frqlim,format="(f4.0)")+' Hz'
		print,'Freq. resolution: '+fres & print,'Nyquist freq.: '+fnyq
		ttle=[inf+'  Sampling='+string(fsampl,format="(f4.1)")+' Hz',$
		      'FFT spectrogram, freq.limits=['+flow+','+fhigh+$
		      '], freq.res:'+fres,ytt(sele)]

		plot_spgt,x,sample_rate,nx,ny,frqlim,ttle,t(first),t(last),fnamn, NSC=nsc, FILENAM=fnam, DATE=date
;		img=tvrd(true=1) & im2=color_quan(img,1,r,g,b)
;		img=tvrd()

		;if strlowcase(!d.name) eq 'x' then begin
		;   spawn,'echo $HOSTTYPE|grep alpha',hstt
		;   if strpos(hstt(0),'alpha') ge 0 then $
		;        write_gif,inpf+'_'+fnam+'.gif',tvrd() $
		;    else write_gif,inpf+'_'+fnam+'.gif',im2,r,g,b & endif else $
		;write_bmp, outpdir + inpf+'_'+fnam+'.bmp',im2,r,g,b

;		write_jpeg, outpdir + 'c' + nsc + '_' + date + '_cfdv01_' + fnam + '.jpeg', img, TRUE=1, QUALITY=90
;		write_png, outpdir + 'c' + nsc + '_' + date + '_cfdv01_' + fnam + '.png', img, red, green, blue

		endfor ;nrres
		endfor ;sele

	ENDFOR ;isc
ENDFOR ;istr

CLOSE, /ALL

spawn, "echo -e '\a';sleep 0.1;echo -e '\a';sleep 0.2;echo -e '\a';sleep 0.2;echo -e '\a';sleep 0.1;echo -e '\a'" ;;;DC;;;

END

;-------------------------------------------------------------------------
; Spectrogramm PLOT - Module
; saves as gif under unix,linux and bmp in windows
; eg@mpe.mpg.de
; 18/03/2003 image saved in main
; 12/02/2003 add information string "produced by FGM-Team TU
;            Braunschweig" to output plots                    SebSch
;-------------------------------------------------------------------------
pro read_spg,spg,nx_spg,ny_spg,filename
;-------------------------------------------------------------------------
openr,unit,filename,/get_lun
spg=dblarr(nx_spg,ny_spg)
readf,unit,spg
free_lun,unit
end

;-------------------------------------------------------------------------
Pro plot_spctgm, sgx, sample_rate,t_start,$
                 t_end,freq_axis_end, $
                 Xsize = xsize, $
                 Ysize = ysize, $
                 Xpos = xpos, $
                 Ypos=ypos, $
                 title=title, $
                 xtitle=xtitle, $
                 ytitle=ytitle, $
                 Khz=Khz, $
                 Xticks=xticks, $
                 Yticks=yticks, $
                 RCtimes=rctimes,$
                 ranges=ranges,$
                 SRtimes=srtimes
;-------------------------------------------------------------------------
   ;+
   ; Pune axe in jurul spectrogramei
   ;
   ; Input:
   ;   SGX -   spectrograma care va fi citita din fisier ( 2-D array)
   ;   Sample_rate - perioada de esantionare a semnalului original
   ;   t_start,t_end - intervalul de timp al semnalului in secunde
   ; Keywords:
   ;   Xsize - X-size, in pixeli, dimens. X a imaginii.
   ;   Ysize - Y-size, in pixeli, dimens. X a imaginii
   ;   Xpos - X-position, in pixeli, coltul din stinga jos al imag.
   ;   Ypos - Yposition, in pixeli, coltul din stinga jos al imag.
   ;   Title - Plot title
   ;   Xtitle - X-axis title
   ;   Ytitle - Y-axis title
   ;   Khz - daca e prezent si diferit de zero pune KHz in loc de Hz
   ;   xticks - nr de major ticks pe axa x
   ;   yticks - nr de major ticks pe axa y.
   ;
   ;-
   ;Plot title
   IF NOT KEYWORD_SET(title) THEN title = 'FFT Spectrogram'
   ;x-axis title
   IF NOT KEYWORD_SET(xtitle) THEN xtitle = 'UTC '
   ;x-axis title
   IF NOT KEYWORD_SET(ytitle) THEN ytitle = 'Frequency [Hz]'
   IF KEYWORD_SET(Khz) THEN ytitle = 'Frequency [kHz]'
   ;X-Size of image in pixels
   IF KEYWORD_SET(xsize) THEN xdim = float(xsize(0)) ELSE xdim = 500.
   ;Y-Size of image in pixels
   IF KEYWORD_SET(ysize) THEN ydim = float(ysize(0)) ELSE ydim = 400.
   ;X-starting point of image in pixels
   IF KEYWORD_SET(xpos) THEN xstart = float(xpos(0)) ELSE xstart = xdim/5
   ;Y-starting point of image in pixels
   IF KEYWORD_SET(ypos) THEN ystart = float(ypos(0)) ELSE ystart = ydim/8
   IF KEYWORD_SET(xticks) THEN xticks =long(xticks(0)) ELSE xticks = !x.ticks
   IF KEYWORD_SET(yticks) THEN yticks =long(yticks(0)) ELSE yticks = !y.ticks
   
   ;;;DC;;;
   IF NOT KEYWORD_SET(RCtimes) THEN rctimes = [0]  
   IF NOT KEYWORD_SET(SRtimes) THEN srtimes = [0]  
   IF NOT KEYWORD_SET(ranges)  THEN ranges  = ['']  
   ;;;DC;;;
   
   ; Save system parameters
   bang_p = !P
   ;  Set position of plot axes w.r.t. position of image..
   !P.position = [ (xstart - 1)/!D.x_size, $
                   (ystart - 1)/!D.y_size, $
                   (xstart + xdim + 1)/!D.x_size, $
                   (ystart + ydim + 1)/!D.y_size]
;   !P.ticklen = -.005            ;Make tick go outside axes

   smpl_rate = double(sample_rate(0))
   if freq_axis_end eq 0 then begin
   freq_axis_end = 1./(2*smpl_rate) ;Upper limit on frequency axis (in Hz)
   IF Keyword_set(kHz) THEN freq_axis_end = freq_axis_end/1000.
   endif
   xtint=max([1,floor((t_end-t_start)/xticks/3600)])*3600
   plot, findgen(xdim)/xdim, findgen(ydim)/ydim, /nodata, /noerase, $
     xstyle = 1, ystyle = 1, $
     xtitle = xtitle, $
     ytitle = ytitle, $
     title = title, $
     xr = [t_start, t_end], $
     yr = [0, freq_axis_end], $
     ;xticks = xticks, $
     xtickformat='tticks', $
     xtickinterval=xtint, $
     yticks = yticks,xticklen=-0.025,yticklen= -.008
   ;rez= congrid(sgx, xdim, ydim,/interp) ;;DC;;
   rez= congrid(sgx, xdim, ydim) ;;DC;;
   tvscl,rez, xstart, ystart
   
   ;;DC;; ->
   ; plot hourly and range change markers
   for nmark=long(0),floor((t_end-t_start)/3600) do $   
     oplot, nmark*long([3600,3600]),[0,freq_axis_end], linestyle=1, color=255
   for n_rct=0, n_elements(rctimes)-1 do begin                     
     oplot, [rctimes[n_rct],rctimes[n_rct]],[0.85,1.0], color=255  
     oplot, [rctimes[n_rct],rctimes[n_rct]],[0.00,0.1], color=255 
     xyouts, rctimes[n_rct],0.9,' '+ranges[n_rct], color=255, alignment=0.25 
   endfor                                                          
   ; plot single range uncal times
   for n_srt=0,n_elements(srtimes)-1 do begin
     oplot, [srtimes[n_srt],srtimes[n_srt],$
             srtimes[n_srt]+300l,srtimes[n_srt]+300l],$
            [.28-.01,.28,.28,.28-.01], color=255
     oplot, [srtimes[n_srt],srtimes[n_srt],$
             srtimes[n_srt]+300l,srtimes[n_srt]+300l],$
            [.2+.01,.2,.2,.2+.01], color=255
            
     oplot, [srtimes[n_srt],srtimes[n_srt],$
             srtimes[n_srt]+300l,srtimes[n_srt]+300l],$
            [.52-.01,.52,.52,.52-.01], color=255
     oplot, [srtimes[n_srt],srtimes[n_srt],$
             srtimes[n_srt]+300l,srtimes[n_srt]+300l],$
            [.44+.01,.44,.44,.44+.01], color=255
   
   
   endfor
   ;;DC;; <-
   
   ; Reset system parameters.
   !p = bang_p
END

;-------------------------------------------------------------------------
pro plot_spgt,x,sample_rate,nx,ny,frqlim,ttle,t_start,t_end,fnam, NSC=nsc, FILENAM=filenam, DATE=date
;ntime nr. de puncte din semnalul original
;-------------------------------------------------------------------------
cx=['x','yz'] & fname=filenam+'.dat'
fract=2.*ny*frqlim*sample_rate & fract=fix(fract)
read_spg,mat,nx,ny,fname
xs = 780 & ys = 540   ;700x550 dimensiunile ferestrei in pixeli
SET_PLOT, 'Z'
DEVICE, SET_RESOLUTION=[xs, ys]
;device,decompose=0
;window, xs = xs, ys = ys, RETAIN=2
;loadct,39 & !p.charsize = 1.
LOADCT, 39
!P.CHARSIZE=0.77
TVLCT, red, green, blue, /GET
maxc=!d.n_colors-1l & !p.color=0 & !p.background=maxc
;set_plot,'ps' & device,file='spg.ps',/landscape,/color
nrpt=n_elements(x)
;;DC;; log scale for B
minx=0.01>min(abs(x[where(x ne 0.)]))

;;
;ticks = LOGLEVELS([minx,max(x)])
;nticks = N_Elements(ticks)
;plot, abs(x) ,/nodata, position = [.15*xs, .55*ys, .85*xs, .95*ys], $
;     /device, xst = 5, ystyle = 1,yrange=[minx,max(x)], $
;     title=ttle[0],ytitle=ttle[2],/ylog, $
;     YTICKS=nticks-1, YTICKV=ticks;
;;

;print, "#############>"
;print, "nrpt", nrpt
;print, "minmax", min(x),max(abs(x))
;print, "<#############"

;plot, abs(x) ,/nodata, position = [.15*xs, .55*ys, .85*xs, .95*ys], $
;     /device, xst = 5, ystyle = 1,yrange=[minx,max(x)], title=ttle[0],ytitle=ttle[2],/ylog ;

plot, abs(x) ,/nodata, position = [.15*xs, .55*ys, .85*xs, .95*ys], $
     /device, xst = 5, ystyle = 1,yrange=[minx,max(abs(x))], $
     title=ttle[0],ytitle=ttle[2],/ylog ;




oplot, abs(x), psym=3 & plots,[0,nrpt-1l],[minx,minx]
;oplot, x, psym=3 & plots,[0,nrpt-1l],[0,0]




XYOUTS, 0.6, 0.01, 'produced by FGM-Team TU Braunschweig', SIZE=0.8, /NORM

matt=(mat>0.001) & matt=matt[*,0:fract-1]
minmat=min(matt) & mat=20.0d*alog10(matt)
mincolor=min(mat) & maxcolor=max(mat) ;& print,min(mat), max(mat)

;;DC;;->
; fix the spectrogram scale
maxcolor=0 & mincolor=-60
mat=(mat>mincolor) & mat=(mat<maxcolor)
mat[0:1,0:1]=maxcolor & mat[0:1,2:3]=mincolor
;;DC;;<-

imat=(!d.n_colors-1)*(mat-mincolor)/(maxcolor-mincolor)

;;DC;;->
; find range changes times
rcfdir='/home/FGM/data/uncal/'+strmid(date,2,2)+'_'+strmid(date,4,2)+'/'
rcfregex=rcfdir + 'c' + nsc + '_' + strmid(date,2,6) + '_????r?f?.uncal' 
rcfiles= file_search(rcfregex, COUNT=n_rcf)
if (n_rcf ge 1) then begin
  rctimes=lonarr(n_rcf)
  ranges=strarr(n_rcf)
  for i_rc=0, n_rcf-1 do begin
    rc_time=strmid(rcfiles[i_rc], 13,4,/reverse_offset)
    ranges[i_rc]=strmid(rcfiles[i_rc], 8,1,/reverse_offset)
    rc_h=fix(strmid(rc_time,0,2))
    rc_m=fix(strmid(rc_time,2,2))
    rc_time=rc_h*3600l+rc_m*60l
    rctimes[i_rc]=rc_time
  endfor
endif else begin
  rctimes=[0]
  ranges=['']
endelse

; find single range uncal times
r_regex=rcfdir + 'c' + nsc + '_' + strmid(date,2,6) + '_????r?.uncal'
r_files=file_search(r_regex, COUNT=n_rf)
if (n_rf ge 1) then begin
  r_times=lonarr(n_rf)
  for i_r=0, n_rf-1 do begin
    r_time=strmid(r_files[i_r], 11,4,/reverse_offset)    
    r_h=fix(strmid(r_time,0,2))
    r_m=fix(strmid(r_time,2,2))
    r_time=r_h*3600l+r_m*60l
    r_times[i_r]=r_time
  endfor
endif else begin
  r_times=[0]
endelse
;;DC;;<-

plot_spctgm, imat, sample_rate,t_start,t_end,frqlim, $
   xticks=6,yticks=4,Title=ttle[1], $
   xs =.7*xs, ys = .35*ys, xpos = .15*xs, ypos = .1*ys, $
   RCtimes=rctimes, ranges=ranges, SRtimes=r_times
   c = intarr(25, 100)

; Display the color table too.
   FOR i = 0, 24 DO c(i, *) = indgen(100)
   tvscl, congrid(c, .02*xs, .35*ys), .88*xs, .1*ys
   axis,.93*xs,yaxis=1,/device,yrange=[mincolor,maxcolor],charsize=0.75,$
       ytitle='nT/sqrt(Hz), dB'

outpdir = '/home/FGM/data/spectra/'
img=tvrd()
pngname=outpdir + 'c' + nsc + '_' + strmid(date,2,6) + '_' + filenam + '.png'
FILE_DELETE, pngname, /ALLOW_NONEXISTENT ;;;DC;;;
write_png,  pngname, img, red, green, blue

end


;---------------------------------------------------------    
FUNCTION nlines,file
;      INPUT :  filename for an ASCII file
;      OUTPUT:  number of lines
;      to be used instead spawn,'wc -l '+file for windows IDL compatibility                       
;      eg@mpe.mpg.de
;----------------------------------------------------------    
usg='USAGE : result=nlines(file)'
if n_elements(file) eq 0 then begin print,usg & return,-1 & end
if strupcase(!d.name) eq 'X' then begin
  spawn,'wc -l '+file,nrli & i=long(nrli(0)) & end else begin
  i=0l & ss=strarr(1) & openr,11,file
  while not eof(11) do begin readf,11,ss & $
       if strlen(ss(0)) gt 1 then i=i+1l & end
  close,11 & endelse
return,i
END



