;-----------------------------------------------------------------
pro fill_gaps,x,nrpt,nrgaps,gappos,gaplen
; to be used together with get_gaps.pro
; INPUT :   x      - time series with gaps
;           nrgaps - nr. gaps, 
;           gappos - ind. in time where gaps exist, lonarr(nrgaps),
;           gaplen - nr. of missing points, lonarr(nrgaps),
; OUTPUT:   x      - time series; gaps filled with 0  
; 
;-----------------------------------------------------------------
if nrgaps gt 0 then begin
nrpto=nrpt & nrpt=nrpt+total(gaplen)
buff=fltarr(nrpt) & buff(0:gappos(0))=x(0:gappos(0))
if nrgaps gt 1 then $
for i=0,nrgaps-2l do $
    buff(gappos(i)+1l+total(gaplen(0:i)):gappos(i+1)+$
              total(gaplen(0:i)))=x(gappos(i)+1l:gappos(i+1))
buff(gappos(nrgaps-1l)+1l+total(gaplen):nrpt-1l)=$
                                x(gappos(nrgaps-1l)+1l:nrpto-1l)
endif else buff=x
x=buff

END