;-------------------------------------------------------------------------
pro get_gaps,t,nrgaps,gappos,gaplen,reso,nrres,resint
; INPUT :   t      - time [s], [reso] - time resolution, if known
; OUTPUT:   nrgaps - nr. gaps,
;           gappos - ind. in original vector where gaps, lonarr(nrgaps),
;           gaplen - nr. of missing points, lonarr(nrgaps),
;           reso   - sampling-rate(s), max-dim: dblarr(nrgaps+1)
;           nrres  - nr of different t-resolutions (>=1)
;           resint - time interval limits for reso & nrgaps, lonarr(3,nrres)
;
;-------------------------------------------------------------------------

; DC apr 2022 changed the hard-wired "1000" from "more sample-rates" to "5000" (two occurrences)

if n_elements(reso) ne 1 then reso=0.
td=transpose(t)-shift(transpose(t),1)
td(0)=td(1) & min_sampling=min(td(where(td gt 0.)))
ratio=reso/min_sampling & cond=ratio gt 0.9 and ratio lt 1.1
if reso gt 0.0 and cond then sample_rate=reso else sample_rate=min_sampling
indi=where(td gt 1.5*min_sampling,nrgaps) & nrres=1
i1=where(td gt 0.9*sample_rate and td lt 1.2*sample_rate, nr1)
sample_rate=mean(td(i1)) & resint=[min(i1),max(i1)]

 ;; => more sample-rates
while nrgaps gt 5000 do begin
   min_sampling=min(td(indi))
   ii=where(td lt 1.5*min_sampling and td gt 1.5*sample_rate,nrmi)
   if nrmi gt 5000 then begin
      sample_rate=[sample_rate,min_sampling]
      indi=where(td gt 1.5*min_sampling,nrgaps)
      nrres=nrres+1
   endif
endwhile

if nrres gt 1 then begin
   print,nrres,' different sampling-rates found!'
   print,'    time reso[s]       from         to        nr_gaps'
;; check for gaps in the small reso interval
   ii=where(td(resint(0):resint(1)) gt 1.5*sample_rate[0],nrgaps)
   if nrgaps gt 0 then begin $
      nrmissing=long(td(ii+resint(0))/sample_rate[0])-1l &$
      indi=ii+resint(0) & end
   nresi=lonarr(3,nrres) & nresi(0:1,0)=resint & nresi(2,0)=nrgaps
   for j=1,nrres-1 do begin
     i1=where(td gt 0.9*sample_rate(j) and td lt 1.2*sample_rate(j), nr1)
     nresi(0,j)=min(i1) & nresi(1,j)=max(i1)
     sample_rate(j)=mean(td(i1))
;; check for gaps in this reso interval
     ii=where(td(nresi(0,j):nresi(1,j)) gt 1.5*sample_rate[j],nrgapsj)
     if nrgapsj gt 0 then begin nresi(2,j)=nrgapsj
        nrmissingj=long(td(ii+nresi(0,j))/sample_rate[j])-1l
        indij=ii+nresi(0,j)
        if nrgaps gt 0 then begin
           nrmissing=[nrmissing,nrmissingj] & indi=[indi,indij]
           endif else begin
           nrmissing=nrmissingj & indi=indij & endelse
        nrgaps=nrgaps+nrgapsj
      endif
   endfor
   reso=sample_rate & resint=nresi
   gappos=indi-1l & gaplen=nrmissing
   for j=0, nrres-1 do print,reso[j],resint[*,j]
endif else begin
 ;; => real gaps

 if nrgaps gt 0 then begin $
      nrmissing=long(td(indi)/sample_rate)-1l
      gappos=indi-1l & gaplen=nrmissing
      reso=sample_rate
      resint=[resint,nrgaps]
      endif else begin
 ;; => no gaps
      reso=sample_rate
      gappos=0 & gaplen=0
      endelse
endelse

END