; reads cluster fgm-files in format:
; h_day, bx, by, bz,....and iso-time-string, bx, by, bz, x, y, z
; returns, s_day + 3 signals : Bmagnitude + Bx + Bxy
; 20/06/2002 eg@mpe.mpg.de
;-------------------------------------------------------------------------
pro load_file3,b,t,n_time,inf
;-------------------------------------------------------------------------
;
if n_time eq 0 then nrl=nlines(inf) else nrl=n_time
if nrl eq 0 then begin print,'File read error: empty file' & stop & end
ss=strarr(1)
openr,inunit1,inf,/get_lun & readf,inunit1,ss & free_lun,inunit1
diez=where(strpos(ss,'Z') ge 0 and strpos(ss,':') ge 0,ndi)
nrtail=2 & nrl=nrl-nrtail
if ndi eq 0 then begin 
  form='(f12.8,3f9)' & ma=dblarr(4,nrl)
  openr,inunit1,inf,/get_lun   
  readf,inunit1,ma,format=form & free_lun,inunit1 
  b=dblarr(3,nrl) & b[1,*]=ma(1,*) & b[0,*]=magn(ma(1:3,*)) 
  b[2,*]=sqrt(ma(3,*)*ma(3,*)+ma(2,*)*ma(2,*))
  t=ma(0,*) & ma=0 & t=t*3600.0d0 
endif else begin
  sss=strarr(nrl)
  openr,inunit1,inf,/get_lun & readf,inunit1,sss & free_lun,inunit1
  tpos=strpos(sss(0),'T') & zpos=strpos(sss(0),'Z')
  tt=strmid(sss,tpos+1,zpos-tpos-1) & t=str2ms(tt)/1000. 
  sss=strmid(sss,zpos+1,27) & ma=dblarr(3,nrl) & form="(3f9)"
  reads,sss,ma,format=form & sss=0 & b=dblarr(3,nrl)
  b[1,*]=ma(0,*) & b[0,*]=magn(ma(0:2,*))
  b[2,*]=sqrt(ma(1,*)*ma(1,*)+ma(2,*)*ma(2,*))
endelse
n_time=nrl & ma=0 
end
;