forward_function OUTPOSITION

PRO PLOT_RC, sc, yymmdd

CLOSE, /ALL

sc = STRING(sc, FORMAT='(I1.1)')
yymmdd = STRING(yymmdd, FORMAT='(I6.6)')

version='02'

yy = STRMID(yymmdd, 0, 2)
mm = STRMID(yymmdd, 2, 2)
dd = STRMID(yymmdd, 4, 2)

datestr = yy + '_' + mm

titlestr = 'C' + sc +  $
	   '  ' + yy + '-' + mm + '-' + dd

inpath  = '/home/FGM/log/cd_log/' + datestr + '/'
infile  = FILE_SEARCH(inpath + 'C' + sc + '_' + yy + mm + dd + '*.NSlog', COUNT=nfile)
outpath = '/home/FGM/data/cfcal/'
;***************************************************************
; find times of range changes
;print, infile

strr3 = 'R  3>FGM sensor range 3'
strr4 = 'R  4>FGM sensor range 4'
strr5 = 'R  5>FGM sensor range 5'

; read log file
NREC, set, infile, n
record = STRARR(n)
line = ''
OPENR, log, infile, /GET_LUN
FOR i=0, n-1 DO BEGIN
READF, log, line
	record[i] = line
ENDFOR
CLOSE, /ALL

; search for range change 2->3, 3->4, 4->5
istrr3 = WHERE(record EQ strr3, nstrr3)
tr3    = istrr3 + 3
istrr4 = WHERE(record EQ strr4, nstrr4)
tr4    = istrr4 + 3
istrr5 = WHERE(record EQ strr5, nstrr5)
tr5    = istrr5 + 3

;print, istrr3[0], istrr4[0], istrr5[0]


IF istrr3[0] NE -1 THEN rc3 = REPLICATE('R3: ', nstrr3) ELSE BEGIN 
			  rc3 = 'R3: '
			  record[tr3] = 'None'
		    ENDELSE
IF istrr4[0] NE -1 THEN rc4 = REPLICATE('R4: ', nstrr4) ELSE BEGIN
			  rc4 = 'R4: '
			  record[tr4] = 'None'
		    ENDELSE
IF istrr5[0] NE -1 THEN rc5 = REPLICATE('R5: ', nstrr5) ELSE BEGIN
			  rc5 = 'R5: '
			  record[tr5] = 'None'
		    ENDELSE

rc_record = [record[tr3], record[tr4], record[tr5]]
rc_strarr = [rc3, rc4, rc5]

;print, rc_strarr

;intstart = WHERE( STRMATCH(rc_record, '*20*Z') EQ 0 AND STRMATCH(rc_record, 'None') EQ 0)
intstart = WHERE( STRMATCH(rc_record, 'B 20*T*Z') EQ 0 AND STRMATCH(rc_record, 'None') EQ 0)

;print, intstart

;stop

IF intstart[0] NE -1 THEN BEGIN
	rc_strarr = SHIFT(rc_strarr, 1)
	rc_record[intstart] = 'A  Begin in this range'
	rc_record = SHIFT(rc_record, 1)
ENDIF

sort_rc   = SORT(rc_record)
rc_record = rc_record[sort_rc]
rc_strarr = rc_strarr[sort_rc]

FOR x=0, N_ELEMENTS(rc_record)-1 DO BEGIN
	;test = STRCMP(rc_record[x], 'B 200', 5)
	test = STRCMP(rc_record[x], 'B 20', 4)
        IF test EQ 1 THEN BEGIN
		dummystr = STRSPLIT(rc_record[x], 'T', /EXTRACT)
		rc_record[x] = 'B  T' + dummystr[1]
	ENDIF
ENDFOR

FOR x=1, N_ELEMENTS(rc_record)-1 DO BEGIN
	test = STRCMP(rc_record[x], 'B  T', 4)
	IF test EQ 1 THEN BEGIN

		dummystr = STRSPLIT(rc_record[x], 'T', /EXTRACT)
		timestr = STRSPLIT(dummystr[1], ':', /EXTRACT)
		hour   = FLOAT(timestr[0])
		minute = FLOAT(timestr[1])
		dsecond = timestr[2]
		second = STRMID(dsecond, 0, 2)
		msec   = STRMID(dsecond, 3, 3)

		hbeg = hour
		mbeg = minute - 1.0
		hend = hour
		mend = minute + 1.0
		IF mbeg LT 0.0 THEN BEGIN
			mbeg = 60.0 + mbeg
			hbeg = hour - 1.0
		ENDIF
		IF mend GE 60.0 THEN BEGIN
			mend = mend - 60.0
			hend = hour + 1.0
		ENDIF

		IF (60.0*hour + minute) GE 1.0 AND (60.0*hour + minute) LE 1439.0 THEN BEGIN
		IF rc_strarr[x] EQ 'R4: ' AND rc_record[x] NE 'None' $
					   AND rc_strarr[x-1] EQ 'R3: ' THEN BEGIN
			tbeg = STRING(hbeg, FORMAT='(I2.2)') + ':' + STRING(mbeg, FORMAT='(I2.2)') + $
			       ':' + second + '.' + msec
			tend = STRING(hend, FORMAT='(I2.2)') + ':' + STRING(mend, FORMAT='(I2.2)') + $
			       ':' + second + '.' + msec
			PRINT, 'Plot RC 3-4'
			PRINT, yy, mm, dd, sc, tbeg, tend
			PRINT, 'source /home/FGM/scripts/cal_out.sh ' + $
				yy + ' ' + mm + ' ' + dd + ' ' + tbeg + ' ' + tend + ' ' + sc + $
                                ' r34' + ' ' + version
			SPAWN, 'source /home/FGM/scripts/cal_out.sh  ' + $
				yy + ' ' + mm + ' ' + dd + ' ' + tbeg + ' ' + tend + ' ' + sc + $
                                ' r34' + ' ' + version
		ENDIF
		IF rc_strarr[x] EQ 'R5: ' AND rc_record[x] NE 'None' $
					   AND rc_strarr[x-1] EQ 'R4: ' THEN BEGIN
			tbeg = STRING(hbeg, FORMAT='(I2.2)') + ':' + STRING(mbeg, FORMAT='(I2.2)') + $
			       ':' + second + '.' + msec
			tend = STRING(hend, FORMAT='(I2.2)') + ':' + STRING(mend, FORMAT='(I2.2)') + $
			       ':' + second + '.' + msec
			PRINT, 'Plot RC 4-5'
			PRINT, yy, mm, dd, sc, tbeg, tend
			SPAWN, 'source /home/FGM/scripts/cal_out.sh ' + $
				yy + ' ' + mm + ' ' + dd + ' ' + tbeg + ' ' + tend + ' ' + sc + $
                                ' r45' + ' ' + version
		ENDIF
		ENDIF ELSE record[x] = 'RC before 00:01 or after 23:59'

	ENDIF ; test
ENDFOR ; x

CLOSE, /ALL

;***************************************************************
; read cftest.cal

outplot = outpath + 'cf_C' + sc + '_20' + yy + mm + dd + '.ps'

input = FILE_SEARCH(outpath + 'cf_c' + sc + '_20' + yy + mm + dd + '_r??.cal', COUNT=nrcfiles)

SET_PLOT, 'ps'
LOADCT, 39, NCOLORS=255
;DEVICE, FILENAME=outplot, XOFFSET=0.3, XSIZE=28.5, YOFFSET=29, YSIZE=20.0,  FONT_SIZE=14, $
;/LANDSCAPE, /BOLD, /COLOR, BITS_PER_PIXEL=8

DEVICE, FILENAME=outplot, $
        YSIZE=20.0,  $
        XSIZE=28.5, $
        FONT_SIZE=14, $
        ;/LANDSCAPE, $
        /BOLD, /COLOR, BITS_PER_PIXEL=8


!P.FONT     = 0
!P.THICK    = 5.0
!P.CHARSIZE = 1.5
!X.THICK    = 5.0
!Y.THICK    = 5.0
!X.STYLE    = 1
!Y.STYLE    = 1
!P.POSITION = 0
!X.TICKFORMAT = '(A1, " ")'

rccolor = 160

FOR ircf=0, nrcfiles-1 DO BEGIN

	record = READ_ASCII(input[ircf])
	time   = DOUBLE(record.FIELD01[0,*])
	bx     = DOUBLE(record.FIELD01[1,*])
	by     = DOUBLE(record.FIELD01[2,*])
	bz     = DOUBLE(record.FIELD01[3,*])
	b      = DOUBLE(record.FIELD01[4,*])
	range  = DOUBLE(record.FIELD01[7,*])
	bperp  = SQRT(by*by + bz*bz)

	;**************************************************************
	; find time of range change

	ir3 = WHERE(range EQ 3, nr3)
	ir4 = WHERE(range EQ 4, nr4)
	ir5 = WHERE(range EQ 5, nr5)

	;**************************************************************
	; plotting section

;	!P.MULTI = [0, 1, 4]
	!P.MULTI = [0, 1, 3]
;	pos  = OUTPOSITION([0.08, 0.98, 0.21, 0.97, 3])
	pos  = OUTPOSITION([0.08, 0.98, 0.05, 0.95, 3])

;	pos4 = [0.08, 0.05, 0.98, 0.20]

	IF ir3[0] NE -1 AND ir4[0] NE -1 THEN BEGIN
		
		!X.RANGE = [MIN(time)+30.0/3600, MAX(time)-30.0/3600]

	;**************************************************************
	; determine slopes of b and bperp in both ranges
		time_ra = time[ir3]
		time_rb = time[ir4[10:nr4-1]]
		b_ra    = b[ir3]
		b_rb    = b[ir4[10:nr4-1]]
		pra_b   = LINFIT(time_ra, b_ra, YFIT=fit_ra_b)
		prb_b   = LINFIT(time_rb, b_rb, YFIT=fit_rb_b)
		bp_ra   = bperp[ir3]
		bp_rb   = bperp[ir4[10:nr4-1]]
		pra_bp  = LINFIT(time_ra, bp_ra, YFIT=fit_ra_bp)
		prb_bp  = LINFIT(time_rb, bp_rb, YFIT=fit_rb_bp)

		PRINT, pra_bp[1], pra_b[1]
		PRINT, prb_bp[1], prb_b[1]

	;**************************************************************

		tra = time[ir3[nr3-1]]
		trb = time[ir4[0]]

		PLOT, time, bx, POSITION=pos[0,*], /NODATA, $
		       YTITLE='bx [nT]', YMINOR=2, ygridstyle=1,yticklen=1
		OPLOT, [tra, tra], [MIN(bx), MAX(bx)], COLOR=rccolor, THICK=3, LINESTYLE=1
		OPLOT, [trb, trb], [MIN(bx), MAX(bx)], COLOR=rccolor, THICK=3, LINESTYLE=1
		OPLOT, time, bx, psym=1, symsize=0.3

		PLOT, time, bperp, POSITION=pos[1,*], /NODATA, $
		       YTITLE='bperp [nT]', YMINOR=2
		OPLOT, [tra, tra], [MIN(bperp), MAX(bperp)], COLOR=rccolor, THICK=3, LINESTYLE=1
		OPLOT, [trb, trb], [MIN(bperp), MAX(bperp)], COLOR=rccolor, THICK=3, LINESTYLE=1
		OPLOT, time, bperp, COLOR=90
		OPLOT, time_ra, fit_ra_bp, THICK=2
		OPLOT, time_rb, fit_rb_bp, THICK=2

		PLOT, time, b, POSITION=pos[2,*], /NODATA, $
		       YTITLE='b [nT]', YMINOR=2
		OPLOT, [tra, tra], [MIN(b), MAX(b)], COLOR=rccolor, THICK=3, LINESTYLE=1
		OPLOT, [trb, trb], [MIN(b), MAX(b)], COLOR=rccolor, THICK=3, LINESTYLE=1
		OPLOT, time, b, COLOR=230
		OPLOT, time_ra, fit_ra_b, THICK=2
		OPLOT, time_rb, fit_rb_b, THICK=2

;		PLOT, time, range, POSITION=pos4, /NODATA, $
;		       YTITLE='range', YRANGE=[0.9, 7.1], YTICKINTERVAL=1, YMINOR=1
;		OPLOT, [tra, tra], [0.9, 7.1], COLOR=rccolor, THICK=3, LINESTYLE=1
;		OPLOT, [trb, trb], [0.9, 7.1], COLOR=rccolor, THICK=3, LINESTYLE=1
;		OPLOT, time, range, THICK=10, COLOR=230

		AXIS, XAXIS=0, XTICKINTERVAL=0.005, XMINOR=5, XTICKFORMAT='(F8.3)', XTITLE='Hours of day'
		XYOUTS, 0.1, 0.96, titlestr+',  range 3 to 4', /NORM

	ENDIF ; ir4

	IF ir4[0] NE -1 AND ir5[0] NE -1 THEN BEGIN
		
		;!X.RANGE = [MIN(time), MAX(time)]
		;!X.RANGE = [MIN(time) + 1.0/120.0, MAX(time) - 1.0/120.0]
                !X.RANGE = [MIN(time)+45.0/3600, MAX(time)-45.0/3600]
	;**************************************************************
	; determine slope of b in both ranges
		time_ra = time[ir4]
		time_rb = time[ir5[10:nr5-1]]
		b_ra    = b[ir4]
		b_rb    = b[ir5[10:nr5-1]]
		pra_b   = LINFIT(time_ra, b_ra, YFIT=fit_ra_b)
		prb_b   = LINFIT(time_rb, b_rb, YFIT=fit_rb_b)
		bp_ra   = bperp[ir4]
		bp_rb   = bperp[ir5[10:nr5-1]]
		pra_bp  = LINFIT(time_ra, bp_ra, YFIT=fit_ra_bp)
		prb_bp  = LINFIT(time_rb, bp_rb, YFIT=fit_rb_bp)

		PRINT, pra_bp[1], pra_b[1]
		PRINT, prb_bp[1], prb_b[1]

	;**************************************************************

		tra = time[ir4[nr4-1]]
		trb = time[ir5[0]]

		PLOT, time, bx, POSITION=pos[0,*], /NODATA, $
		       YTITLE='bx [nT]', YMINOR=2, ygridstyle=1,yticklen=1
		OPLOT, [tra, tra], [MIN(bx), MAX(bx)], COLOR=rccolor, THICK=3, LINESTYLE=1
		OPLOT, [trb, trb], [MIN(bx), MAX(bx)], COLOR=rccolor, THICK=3, LINESTYLE=1
		OPLOT, time, bx, psym=1, symsize=0.3

		PLOT, time, bperp, POSITION=pos[1,*], /NODATA, $
		       YTITLE='bperp [nT]', YMINOR=2
		OPLOT, [tra, tra], [MIN(bperp), MAX(bperp)], COLOR=rccolor, THICK=3, LINESTYLE=1
		OPLOT, [trb, trb], [MIN(bperp), MAX(bperp)], COLOR=rccolor, THICK=3, LINESTYLE=1
		OPLOT, time, bperp, COLOR=90
		OPLOT, time_ra, fit_ra_bp, THICK=2
		OPLOT, time_rb, fit_rb_bp, THICK=2

		PLOT, time, b, POSITION=pos[2,*], /NODATA, $
		       YTITLE='b [nT]', YMINOR=2
		OPLOT, [tra, tra], [MIN(b), MAX(b)], COLOR=rccolor, THICK=3, LINESTYLE=1
		OPLOT, [trb, trb], [MIN(b), MAX(b)], COLOR=rccolor, THICK=3, LINESTYLE=1
		OPLOT, time, b, COLOR=230
		OPLOT, time_ra, fit_ra_b, THICK=2
		OPLOT, time_rb, fit_rb_b, THICK=2

;		PLOT, time, range, POSITION=pos4, /NODATA, $
;		       YTITLE='range', YRANGE=[0.9, 7.1], YTICKINTERVAL=1, YMINOR=1
;		OPLOT, [tra, tra], [0.9, 7.1], COLOR=rccolor, THICK=3, LINESTYLE=1
;		OPLOT, [trb, trb], [0.9, 7.1], COLOR=rccolor, THICK=3, LINESTYLE=1
;		OPLOT, time, range, THICK=10, COLOR=230

		AXIS, XAXIS=0, XTICKINTERVAL=0.002, XMINOR=2, XTICKFORMAT='(F8.3)', XTITLE='Hours of day'
		XYOUTS, 0.1, 0.96, titlestr+',  range 4 to 5', /NORM

	ENDIF ; ir4


ENDFOR ; ircf

DEVICE, /CLOSE

!X.RANGE=0

spawn, 'cp '+outplot+' rc_tmp.ps'

;spawn, 'gv --orientation=seascape '+outplot

END

;****************************************************************************
;****************************************************************************

FUNCTION OUTPOSITION, outposarr

posx1  = outposarr[0]
posx2  = outposarr[1]
posbeg = outposarr[2]
posend = outposarr[3]
posn   = outposarr[4]


possize = posend - posbeg
posd    = possize / posn
pos     = FLTARR( FIX(posn), 4 )

Apos = posbeg + posd*FINDGEN( FIX(posn) )
Bpos = Apos + posd - 0.01
posd    = possize / posn
pos     = FLTARR( FIX(posn), 4 )

Apos = posbeg + posd*FINDGEN( FIX(posn) )
Bpos = Apos + posd - 0.01

FOR p=0, posn-1 DO pos[posn-p-1,*] = [ posx1, Apos[p], posx2, Bpos[p] ]

RETURN, pos


END

PRO NREC, set, file, i
OPENR, set, file, /GET_LUN
line = ''
i = 0L
WHILE NOT EOF(set) DO BEGIN
	READF, set, line
	i=i+1
ENDWHILE
CLOSE, set
END
