;      PRO SPINAXISA
;      fits spin axis angles for Cluster based on spin tone minimization in spin axis component
;      eg@mpe.mpg.de
;----------------------------------------------------------------
pro init_filtfre,tim,n_time,n_ini
common spadata,b,fre,ini,ini2,inoise,sm,ma
if n_elements(n_ini) eq 0 then n_ini=0
tt=tim(n_ini+0:n_ini+n_time-1l)
if tt(0) ne min(tt) and tt(0) gt 86300 then begin
   diff=tt-shift(tt,1) & diff(0)=0
   daych=where(diff lt 0) 
   tt(daych[0]:n_ini+n_time-1)=tt(daych[0]:n_ini+n_time-1)+86400
endif
tint=double(max(tt)-min(tt)) 
fnyq=n_time/2.d0/tint & ord=301 
if fnyq gt 20. then ord=ord*3 
fre=findgen(n_time/2)/tint 


;;DC 2023.11.10;;->
; ini=where(fre ge 0.23 and fre le 0.27) 
; ini2=where(fre ge 0.48 and fre le 0.52)
; In July 2001 the spin frequencies were:
; C1	0.249
; C2	0.250
; C3	0.250
; C4	0.249
; In July 2023 the spin frequencies were:
; C1	0.230
; C2	0.235
; C3	0.235
; C4	0.239
; -> min=0.23, max=0.24 -> we should use 0.235+/-0.02Hz
; for 2nd harm: 0.47+/-0.02Hz
; ini=where(fre ge 0.23 and fre le 0.27)        
; ini2=where(fre ge 0.48 and fre le 0.52)
fspin=0.235
dfspin=0.02
srng=[fspin-dfspin, fspin+dfspin]
ini=where(fre ge srng[0] and fre le srng[1]) 
ini2=where(fre ge 2*srng[0] and fre le 2*srng[1])
;;DC 2023.11.29;;<-       

inoise=where(fre ge 1.02 and fre le 1.06)
sm=digital_filter(0.18d0/fnyq,1.d0,50,ord)
end

;--------------------------------------------------------------    
FUNCTION magn,vector
;      computes the magnitude of a vector or of an array of vectors
;      INPUT:   vector=dblarr(3) 
;      OUTPUT:  magnitude
;      eg@mpe.mpg.de
;---------------------------------------------------------------    
ns=size(vector) & ndim=ns[0] & n1=long(ns[1]) & n2=long(ns[2])
v2=vector*vector
if n1 eq 3 then begin
if ndim eq 1 then begin m=sqrt(total(v2)) & goto,endlbl & end else begin $
m=dblarr(n2) & for i=0l,n2-1l do m[i]=sqrt(total(v2[*,i]))& end
endif
if ndim eq 2 and n2 eq 3 then begin m=dblarr(n1) & $
for i=0l,n1-1l do m[i]=sqrt(total(v2[i,*])) & end
endlbl:
return,m 
end

;----------------------------------------------------------------
function psd,signal,frqint 
common spadata
ssi=size(signal) & if ssi(0) eq 2 then $
newsig=convol(transpose(signal),sm,/center,/edge_truncate) else $
newsig=convol((signal),sm,/center,/edge_truncate)
newsig=(newsig)-mean(newsig)
ftsig=fft(newsig,-1,/double) & fts=abs(ftsig)^2
minfre=fre(min(frqint)) & maxfre=fre(max(frqint))
psd=sqrt(total(fts(frqint))/(maxfre-minfre))
maxpsd=max(fts(frqint),ma) & ma=ma ;& stop
return,1.e3*psd 	; returns pT/sqrt(Hz)
end

;----------------------------------------------------------------
function funcbx,sins
common spadata
bx=b(0,*)+b(1,*)*sins[0]+b(2,*)*sins[1]    
funcbx=psd(bx,ini)
return,funcbx
end

;----------------------------------------------------------------
function funcbp,scz
common spadata
bb=sqrt(b[1,*]^2+(b[2,*]*scz[1]+b[1,*]*scz[0])^2)  
funcbp=psd(bb,ini2)
return,funcbp
end

;---------------------------------------------------------------
function funcbyz,offs
common spadata
bnew=b & bnew(1,*)=bnew(1,*)-offs(0)    
bnew(2,*)=bnew(2,*)-offs(1) & bbn=sqrt(bnew(1,*)^2+bnew(2,*)^2)
funcbyz=psd(bbn,ini)
return,funcbyz
end

;---------------------------------------------------------------
pro rotx,sins,mrot
common spadata
coss=sqrt(1.d0-sins^2)
m_xy=dblarr(3,3) & m_xz=m_xy 
;rotation around Oz
m_xy[0,0] = coss[0] & m_xy[1,0] = sins[0] & m_xy[2,0] = 0  
m_xy[0,1] = -sins[0] & m_xy[1,1] = coss[0] & m_xy[2,1] = 0 
m_xy[0,2] = 0 & m_xy[1,2] = 0 & m_xy[2,2] = 1 
;rotation around Oy
m_xz[0,0] = coss[1] & m_xz[1,0] = 0 & m_xz[2,0] = sins[1]  
m_xz[0,1] = 0 & m_xz[1,1] = 1 & m_xz[2,1] = 0  
m_xz[0,2] = -sins[1] & m_xz[1,2] = 0 & m_xz[2,2] = coss[1] 
mrot=m_xz ## m_xy
newb=b
for i=0l,n_elements(b[0,*])-1l do newb[*,i]=transpose(mrot) # (b[*,i])
b=newb
end

;--MAIN-------------------------MAIN--------------------MAIN------
PRO spinaxisa_multi,t,mag,sc,angle0,afinal,fname,spinplane_a=spinplane_a,spinplane_offs=spinplane_offs
; t : time in hours_day
; mag: magnetic field vectors in FSR coordinates 
; angle0: spin axis angles from applied calfile
; fname: input filename
; CHANGES: display calculated offset *** SebSch June 23, 2006
;--MAIN-------------------------MAIN--------------------MAIN------
common spadata

logdir='/home/FGM/log/dailycal/'

n_time=n_elements(t) & b=mag & bx=mag(0,*) & proc1=0
bsangle=!radeg*acos(abs(mean(bx))/mean(magn(b)))
if keyword_set(spinplane_a) then proc1=1 else if keyword_set(spinplane_offs) then proc1=2

eql="================================================="
eql=eql+eql      
head0=['P_bx-> power density [pT/sqrt(Hz)] of spin tone in Bx (i/f:initial/final)',$
     	'Rz(Axy),Ry(Axz): rotation angles around z,y axes',  $
	'<B,S>: angle between B and spin axis in degrees',eql]
head=[[' Rzi[deg]   Ryi[deg]  P_bxi  P_bxf  Rzf[deg] Ryf[deg]   P_n   nrp   <B,S>    FILENAME',eql],$
	['  Ayzi[deg]   Sczi[deg]  P_byz2i  P_byz2f  Ayzf[deg] Sczf[deg]   P_n   nrp   <B,S>    FILENAME',eql],$
	['  Oyi[deg]   Ozi[deg]  P_byzi  P_byzf  Oyf[deg] Ozf[deg]   P_n   nrp   <B,S>    FILENAME',eql] ]
 
;; open logfile to append
ext=['spina.logf' , 'sczAyz.logf', 'OyOz.logf']
fna3=strmid(fname,0,3) & if strmid(fna3,2,1) eq 'i' then fna3=fna3+'_'
close,9 & logf=logdir+fna3+ext(proc1) & fnam=findfile(logf,count=count) 
openw,9,logf,/append 
if count eq 0 then printf,9,head0,head(proc1),format='(a)'

init_filtfre,t*3600.d0,n_time

case proc1 of
 
0:BEGIN
;; perform fit
;test if fit needed on Bx
	sins0=[0.d0,0.d0] & coss0=[1.d0,1.d0] & minf=1. & sins=sins0 & coss=coss0
	p0a=psd(bx,ini) & fmina=p0a & pnois=psd(bx,inoise) & diff=pnois
	if ma gt 0 or diff lt 0. then begin Ftol=1.e-6 & xi=identity(2)
	   POWELL, sins, Xi, Ftol, Fmina, 'funcbx', iter=it 
	   coss=sqrt(1.d0-sins^2) & fmina=fmina & minf=fmina/p0a
 	   angls=[acos(coss[0])*!radeg*sins(0)/abs(sins(0)),$
		 acos(coss[1])*!radeg*sins(1)/abs(sins(1))]
	    endif
	if minf gt 0.98 then begin print,'NO change of spin axis direction!',p0a,fmina,minf &$ 
  	     fmina=p0a & sinss=sins0 & coss=coss0 & angls=sins & endif else rotx,sins,mrot
	afinal=angls+angle0
	print,'OLD Axy, Axz:'+string(angle0,p0a,format='(2(f9.5)," [deg], P_bxi: ",f5.1," [pT/Hz^1/2]")')
	print,'NEW Axy, Axz:'+string(afinal,fmina,format='(2(f9.5)," [deg], P_bxf: ",f5.1," [pT/Hz^1/2]")')
	print, bsangle, format='("<angle B to spin axis>: ", f9.5," [deg]")'
	logline=string(angle0,p0a,fmina,afinal,pnois,n_time,bsangle,'  '+fname,$
	format="(2f9.5,f9.1,f7.1,2f9.5,f7.1,i7,f7.1,a)")
	printf,9,logline & close,9
	END

1:BEGIN
;test the necessity of fit for scaling factor on z axis & yz angle
;scz -> [angle_yz, sc_z]
	bb=sqrt(b[1,*]^2+b[2,*]^2) & minf=1. & scz=[0.d0,1.d0] 
	Ftol=1.e-6 & xi=identity(2) & p0s=psd(bb,ini2) & pnois=psd(bb,inoise) 
	POWELL, scz, Xi, Ftol, Fmins, 'funcbp', iter=it  & sfact=fmins/p0s
	afinal=angle0 & afinal(0)=angle0(0)+scz(0) & afinal(1)=angle0(1)*scz(1)
	print,'OLD Ayz, Scz:'+string(angle0,p0s,format='(2(f9.5),", P_byzi_2: ",f5.1," [pT/Hz^1/2]")')
	print,'NEW Ayz, Scz:'+string(afinal,fmins,format='(2(f9.5),", P_byzf_2: ",f5.1," [pT/Hz^1/2]")')
	logline=string(angle0,p0s,fmins,afinal,pnois,n_time,bsangle,'  '+fname,$
	format="(2f9.5,f9.1,f7.1,2f9.5,f7.1,i7,f7.1,a)")
	printf,9,logline & close,9	
	print, bsangle, format='("<angle B to spin axis>: ", f9.5," [deg]")'
	END

2:BEGIN
;offs -> [offset_y, offset_z]
	offs0=[0.d0,0.d0] & bb=sqrt(b[1,*]^2+b[2,*]^2) & minf=1. & offs=offs0
	p0=psd(bb,ini) & fmin=p0 & pnois=psd(bb,inoise) 
;test the necessity of fit for offsets
	if ma ge 0 then begin Ftol=1.e-4 & xi=identity(2)
 	   POWELL, offs, Xi, Ftol, Fmin, 'funcbyz', iter=it & minf=fmin/p0
	endif
	if minf gt 0.95 then begin print,'NO change of spin plane offsets!',p0,fmin,minf & $
	   offs=offs0 & fmin=p0 & end 
	afinal=angle0+offs
	print,'OLD Oy, Oz:'+string(angle0,p0,format='(2(f9.5)," [nT], P_byzi: ",f6.1," [pT/Hz^1/2]")')
	print,'NEW - OLD :'+string(afinal-angle0,fmin-p0,format='(2(f9.5)," [nT], P_byzi: ",f6.1," [pT/Hz^1/2]")')
	print,'NEW Oy, Oz:'+string(afinal,fmin,format='(2(f9.5)," [nT], P_byzf: ",f6.1," [pT/Hz^1/2]")')
	logline=string(angle0,p0,fmin,afinal,pnois,n_time,bsangle,'  '+fname,$
	format="(2f9.5,f9.1,f7.1,2f9.5,f7.1,i7,f7.1,a)")
	printf,9,logline & close,9	
	print, bsangle, format='("<angle B to spin axis>: ", f9.5," [deg]")'
	END
ELSE: print,'input error!'
ENDCASE

END
