#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Aug  7 09:20:16 2025

Exports some constants:
    paths
    default calibration version
    reference frame names
    calibration parameters names

@author: dragos
"""
import numpy as np


PATHS = {'FGMroot':      '/home/FGM/',
         'FGMpath':      '/home/FGM/data/dcalf/',
         'exePath':      '/home/FGM/bin/',
         'scriptPath':   '/home/FGM/scripts/',
         'sattPath':     '/home/FGM/log/atorb/',
         'orbitPath':    '/home/FGM/log/atorb/',
         'dataDir':      '/home/FGM/data/',
         'tmpDir':       '/home/FGM/data/tmp/',
         'archiveDir':   '/home/FGM/archive/',
         'GRMBdir':      '/mnt/space/dragos/data/Cluster/GRMB_location/'
         }


FGMVERSION=3

COORDS = ('sr',  #  for spin-reference system (ortho, spining, z-ax=spin axis),
          'scs', #  for spacecraft-sun system (despun, z-axis=spin axis),
          'gse', #  for geocentric solar ecliptic system (default),
          'gsm', #  for geocentric solar magnetospheric system,
          'sm',  #  for solar magnetic system, or
          'j2k'  #  for geocentric equatorial inertial system of epoch J2000.
          )

FIRSTDAY=np.datetime64('2000-08-01')
LASTDAY=np.datetime64('2024-09-30')
ETALONDAY=np.datetime64('2004-06-30')

ETALONOZ={'C1': 2.45, 'C2': -0.77, 'C3': -2.26, 'C4': -14.05}

FIRSTdayInRng={'1': FIRSTDAY,
               '2': FIRSTDAY,
               '3': FIRSTDAY,
               '4': FIRSTDAY,
               '5': np.datetime64('2006-10-18'),
               '6': np.datetime64('2009-10-04'),
               '7': np.datetime64('2009-11-17') }

          # GUI         File
FGMNAMES={'offset_r2': 'Offset_r0',
          'offset_r3': 'Offset_r1',
          'offset_r4': 'Offset_r2',
          'offset_r5': 'Offset_r3',
          'offset_r6': 'Offset_r4',
          'offset_r7': 'Offset_r5',
          'offset_sc': 'offset_sc',
          'Matrix_r2': 'Matrix_r0',
          'Matrix_r3': 'Matrix_r1',
          'Matrix_r4': 'Matrix_r2',
          'Matrix_r5': 'Matrix_r3',
          'Matrix_r6': 'Matrix_r4',
          'Matrix_r7': 'Matrix_r5',
          'Matrix_sc': 'Matrix_SC',
          'Matrix_dr': 'Matrix_dr',
          'Angle_xyz': 'Matrix_xyz'}
