#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Aug 19 10:09:12 2025

Adjust the spacecraft spin axis offset in the cal files. The adjusted value
is derived from the (second level) yearly offsets interpolated to daily values.

@author: dragos
"""
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import sys
from warnings import warn
import os
from pathlib import Path
Cpath=str(Path(__file__).parent.parent)+'/modules/'
if not Cpath in sys.path: sys.path.append(Cpath)
import Cluster.load as load
import Cluster.calibration as cal
import Cluster.config as cfg
import shutil



#%% load yearly and etalon offsets

spacecraft='1234'
oldVersion='last'
newVersion='V04'
etalonDay=cfg.ETALONDAY

offY=pd.concat([pd.read_csv(cfg.PATHS['archiveDir']+'/calfiles/cfgnew/spin_axis_offset/C'
                           +_+'_offZ_yearly_interpolated.csv', index_col=0, parse_dates=[0])
               for _ in spacecraft], axis=1)
offY.columns=['C'+_ for _ in spacecraft]

etalonFiles={sc: (load.cfgnew_file_name(day=etalonDay, spacecraft=sc, debug=True,
                                        version='last', maxV=3, archive=True))[0]
             for sc in spacecraft}
etalonOff={'C'+sc: load.cfgnew_pars(etalonFiles[sc], GUInames=True)['offset_sc'][0,0].copy()
           for sc in spacecraft}

# offY.plot()



#%% adjust spin axis offset and save

for sc in spacecraft:#'3':#
    for day in offY.index:#offY.index[offY.index >= pd.Timestamp('2008-09-17')]:#
    # for day in offY.index[350:360]:

        # load the last calibration parameters
        count=[0]
        cfgnewFile,V = load.cfgnew_file_name(day=day, spacecraft=sc, debug=True,
                                                 version=oldVersion, maxV=3,
                                                 archive=True, count=count)
        fromPast=bool(count[0])
        if not cfgnewFile: continue
        cfgnewPars=load.cfgnew_pars(cfgnewFile, GUInames=True)

        # adjust the spin axis offset
        deltaO=offY['C'+sc].loc[day]
        try:
            cfgnewPars['offset_sc'][0,0]=etalonOff['C'+sc]+deltaO
        except:
            warn('failed to set offset for file '+cfgnewFile)
            continue
        newCfgnewFile=cal.write_cfgnew(cfgnewPars, version=newVersion)

        # save the adjusted calfiles to the archive
        oldV=cfgnewFile[-10:-7]
        if newVersion == oldV: raise Exception("output V same with input V")
        archiveCfgnewFile=cfgnewFile.replace(cfgnewFile[-10:-7],newVersion)
        if not fromPast: shutil.copy(newCfgnewFile, archiveCfgnewFile)

        newFgmcalFile=cal.cgfnew_to_fgmcal(cfgnewfile=newCfgnewFile, debug=True)
        archiveFgmcalFile=(cfg.PATHS['FGMroot']
                    +'archive/calfiles/fgmcal/'
                    +str(day)[:8].replace('-','/')+'C'+sc+'_'
                    +str(day)[:10].replace('-','')+'_'+newVersion+'.fgmcal')
        shutil.copy(newFgmcalFile, archiveFgmcalFile)

        # cleanup
        newR7File=newFgmcalFile[:-11]+'range7.fgmcal'
        for tmpFile in (newCfgnewFile, newFgmcalFile, newR7File):
            if tmpFile[:19] == cfg.PATHS['tmpDir']:
                try: os.remove(tmpFile)
                except: pass

        print('out cfgnew: '+archiveCfgnewFile)
        print('out fgmcal: '+archiveFgmcalFile)
