package FGMperl;
require Exporter;

@ISA       = qw(Exporter);
@EXPORT    = qw(readcalfile calfilestr selectraw %FGM_names);

%FGM_names=(offset_r2 => 'Offset_r0', 
            offset_r3 => 'Offset_r1', 
            offset_r4 => 'Offset_r2', 
            offset_r5 => 'Offset_r3', 
            offset_r6 => 'Offset_r4',
            offset_r7 => 'Offset_r5',
            offset_sc => 'offset_sc',                
            Matrix_r2 => 'Matrix_r0', 
            Matrix_r3 => 'Matrix_r1', 
            Matrix_r4 => 'Matrix_r2', 
            Matrix_r5 => 'Matrix_r3', 
            Matrix_r6 => 'Matrix_r4',
            Matrix_r7 => 'Matrix_r5',
            Matrix_sc => 'Matrix_SC',                                       
            Matrix_dr => 'Matrix_dr',                                       
            Angle_xyz => 'Matrix_xyz');


#--------------------------------------------------------------------
sub readcalfile {
  my $file = shift;
  my %param=();
  my @record=();
  open (CFILE,"<$file");
  while (<CFILE>){
    next unless /\S+/;
    s/=//g;
    @record=split;
    push @{$param{$record[0]}},@record[1..3]
  }
  close CFILE;
  return %param;
}
#--------------------------------------------------------------------

#--------------------------------------------------------------------
sub calfilestr {
  my $paramref=shift;
  my %param=%$paramref;
  my $string='';
  $param{'blank'}=0;
  my $key ='blank';
  if (grep(/_r5/,keys(%param)) eq 0) {
    @{$param{'Offset_r5'}}=(0,0,0);
    @{$param{'Matrix_r5'}}=(1,0,0,0,1,0,0,0,1);
  }
  my @keys=('Offset_r0', 'Offset_r1', 'Offset_r2', 'Offset_r3', 'Offset_r4', 'Offset_r5', 'blank',
            'offset_sc',                                                     'blank',
            'Matrix_r0',                                                     'blank',
            'Matrix_r1',                                                     'blank',
            'Matrix_r2',                                                     'blank',
            'Matrix_r3',                                                     'blank',
            'Matrix_r4',                                                     'blank',
            'Matrix_r5',                                                     'blank',
            'Matrix_SC',                                                     'blank',
            'Matrix_dr',                                                     'blank',
            'Matrix_xyz');
  foreach $key (@keys) {$string.=formatrecord($key,$param{$key});}
  return $string;
}
#--------------------------------------------------------------------



#--------------------------------------------------------------------
sub formatrecord {
  my ($key,$arrayref)=@_;
  $^A='';
  if ($key eq 'Matrix_xyz') {
formline <<END_OF_FORMAT, ($key,@$arrayref);
@<<<<<<<<<    @###.########    @###.########    @###.########
END_OF_FORMAT
  } elsif ($#$arrayref eq 2) {
formline <<END_OF_FORMAT, ($key,@$arrayref);
@<<<<<<<<=    @###.########    @###.########    @###.########
END_OF_FORMAT
  } elsif ($#$arrayref eq 8) {
    for (my $j=0;$j<=2;$j++){
formline <<END_OF_FORMAT, ($key,@{$arrayref}[3*$j..3*$j+2]);
@<<<<<<<<=    @###.########    @###.########    @###.########
END_OF_FORMAT
    }
  } elsif ($key eq 'blank'){
  return " \n";
} else {die 'something is wrong'}
  return $^A;
}
#--------------------------------------------------------------------



#--------------------------------------------------------------------
sub selectraw {
  my(%args)=@_;
  my $ICL=$args{'ICL'};
  my $yy=$args{'yy'};
  my $dd=$args{'dd'};
  my $mm=$args{'mm'};
  my $sc=$args{'sc'};
  my $bs=$args{'bs'};  
  my $dv=$args{'dv'};  
  my ($ipath,$rawf,$mf,$file);
  my $last_v = $dv;
  my @files=(); my @files_allv=(); my @versions=();
  if (length($yy) eq 1) {$yy ='0'.$yy;}
  if (length($mm) eq 1) {$mm ='0'.$mm;} 
  if (length($dd) eq 1) {$dd ='0'.$dd;}
  if ($dv eq 'last') {$dv='?';}
     
  if ($ICL) {
    $ipath = $ENV{FGMROOT}."/data/raw/ICL/$yy"."_$mm";
    if ($bs eq 'NS') {
      $rawf = "$ipath/C$sc"."_$yy$mm$dd".'_B.NS';
    } elsif ($bs eq 'BSNS') {
      $rawf = "$ipath/C$sc"."_$yy$mm$dd".'_B.?S';
    } elsif ($bs eq 'BS') {
      $rawf = "$ipath/C$sc"."_$yy$mm$dd".'_B.BS';
    }
    foreach $mf (glob("$rawf*")) {push @files, $mf unless -z $mf;} 
  } else {
    $ipath = $ENV{FGMROOT}."/data/raw/ESTEC/";
    if ($bs eq 'NS') {
      $rawf="$ipath/cluster$sc/?sd_$sc/$yy$mm$dd".'fn.?'."$dv$sc";
    } elsif ($bs eq 'BSNS') {
      $rawf = "$ipath/cluster$sc/?sd_$sc/$yy$mm$dd".'f?.?'."$dv$sc";
    } elsif ($bs eq 'BS') {
      $rawf="$ipath/cluster$sc/?sd_$sc/$yy$mm$dd".'fb.?'."$dv$sc";
    }
    foreach $mf (glob("$rawf*")) {
      next if -z $mf;
      push @files, $mf;
      if ($dv eq '?') {
        $mf =~/\.\d(\w)$sc$/;
        push @versions, $1; # store data versions
      }
    }
    if ($dv eq '?') {
      @versions=sort(@versions);
      $last_v=$versions[$#versions-1];    
      @files_allv=@files;@files=();
      foreach $file (@files_allv) {
        push @files, $file if $file=~/\.\d$last_v$sc$/;
      }
    }
  }
    
  # context sensitive return 
  if ( wantarray() ) {
    return @files;
  }
  elsif ( defined wantarray() ) {
    return $last_v;
  }
  else {
    print "$rawf \n";
  }

}


#--------------------------------------------------------------------





1;

__END__



=head1 NAME

FGMperl - Collection of routines for the Cluster FGM calibration.

=head1 SYNOPSIS

 Use FGMperl;

 %p=readcalfile($CalFile);
 $p{$FGM_names{$key}}[$j]=$off;
 print CFILE calfilestr(\%p);


=head1 DESCRIPTION

This perl module contains a collection of routines and variables which are
used by various scripts for the Cluster FGM daily calibration. 

=head1 EXPORTED VARIABLES

=over 

=item C<%FGM_names> 

Correspondence hash between calibration parameter names
as saved in the F<cfgnew> files and those appearing in the I<cls.pro> 
"calibration table".

=back

=head1 EXPORTED FUNCTIONS

=over 

=item C<readcalfile($file_name)> 

returns a hash with the calibration
parameters from F<$file_name>. 

=item C<calfilestr(\%p)> 

returns the string in I<cfgnew> format for the 
calibration parameters in the C<%p> hash. If the hash
does not include range 7 parameters (introduced later),
they will be assigned default (0 offset, unit matrix) values.


=item C<< selectraw(ICL=>$ICL,sc=>$sc,bs=>$bs,yy=>$yy,mm=>$mm,dd=>$dd,dv=>$dv) >>

In list context returns a list of names of non-empty raw data files found.

Arguments:

ICL=>n : Search path. n=1 for the Imperial College data F<$ENV{FGMROOT}."/data/raw/ICL/$yy"."_$mm>
         n=2 for the ESTEC data F<$ENV{FGMROOT}."/data/raw/ESTEC/>.

sc=>n  : Data for spacecraft n

bs=>s  : s='BS' for burst science, s='NS' for normal science, s='BSNS' for both

yy=>y  : year

mm=>m  : month

dd=>d  : day

dv=>dv : Data version. One character ('a','b', ...) or 'last' to select the last version available.

In scalar context returns the last available raw data version ('a','b', ...)

In void context prints the regex for the names of the raw data files.

=back

=head1 AUTHOR

Dragos Constantinescu <d.constantinescu@tu-bs.de>

=cut







