#!/usr/bin/perl -w
use Getopt::Long qw(:config no_ignore_case bundling);
use lib $ENV{HOME}."/perl/modules";
use Utils;
use Pod::Usage;
use FGMperl;

$yy      = substr((localtime())[5],1);
$scstr   = '1 2 3 4';
$day     = '??';
$log     = 1;
$ICL     = 0;
$inboard = '';
$reverse = 0;
$All     = 0;
$jump    = 1;

$me="$0 @ARGV";

GetOptions ('h|help|?+'      => \$help,
            'y|year=i'       => \$yy,
            'm|month=i'      => \$mm,    
            'i|inboard'      => \$inboard,
            's|spacecraft:s' => \$scstr,
            'd|day:s'        => \$day,
            'a|all'          => \$all,
            'A|All'          => \$All,
            'c|centered'     => \$mix,
            'I|ICL'          => \$ICL,
            'l|log!'         => \$log,
            'j|jump=i'       => \$jump,
            'r|reverse'      => \$reverse);

pod2usage( -verbose => $help, -noperldoc => 1) if $help;

die 'Please use the --month option' unless $mm;

if (length($yy)   eq 1) {$yy   ='0'.$yy;}
if (length($mm)   eq 1) {$mm   ='0'.$mm;}  
if (length($day)  eq 1) {$day  ='0'.$day;}
if ($All) {$All='-a'} else {$All=''}       

@scarr=split ' ', $scstr ;

$ENV{FGMROOT}  = '/home/FGM/'                unless $ENV{FGMROOT};
$ENV{SATTPATH} = "$ENV{FGMROOT}/log/atorb/"  unless $ENV{SATTPATH};
$ENV{FGMPATH}  = "$ENV{FGMROOT}/data/dcalf/" unless $ENV{FGMPATH};
$exepath  = "$ENV{FGMROOT}/bin";

#if ($ICL) {
#  $ipath = $ENV{FGMROOT}."/data/raw/ICL/$yy"."_$mm";
#} else {
#  $ipath = $ENV{FGMROOT}."/data/raw/ESTEC/";
#}

$logfiledir = "$ENV{FGMROOT}/log/cd_log/$yy"."_$mm";
$opath      = "$ENV{FGMROOT}/data/uncal/$yy"."_$mm/";

mkdir $opath; `chmod g+s $opath`;

open  LOG, ">>$ENV{FGMROOT}/log/dailycal/dailycal_$yy$mm.log";
print LOG localtime()." $ENV{USER} $me\n" if $log;
close LOG;

foreach $sc (@scarr) {
  @logfiles=glob("$logfiledir/C$sc"."_$yy$mm$day"."_B.{NS,BSNS,BS}log");
  foreach $logfile (@logfiles){
    next unless -e $logfile;
    $logfile=~/_$yy$mm(\d\d)_B\.(NS|BSNS|BS)log/;
    $dd=$1;$bs=$2;
    
    next if ((($bs eq 'NS') or ($bs eq 'BS')) 
             and -e "$logfiledir/C$sc"."_$yy$mm$day"."_B.BSNSlog");
        
#    if ($ICL) {
#      if ($bs eq 'NS') {
#        $rawf = "$ipath/C$sc"."_$yy$mm$dd".'_B.NS';
#      } elsif ($bs eq 'BSNS') {
#        $rawf = "$ipath/C$sc"."_$yy$mm$dd".'_B.?S';
#      } elsif ($bs eq 'BS') {
#        next if -e "$logfiledir/C$sc"."_$yy$mm$day"."_B.BSNSlog";
#        $rawf = "$ipath/C$sc"."_$yy$mm$dd".'_B.BS';
#      }
#    } else {
#      if ($bs eq 'NS') {
#        $rawf="$ipath/cluster$sc/?sd_$sc/$yy$mm$dd".'fn.?a'."$sc";
#      } elsif ($bs eq 'BSNS') {
#        $rawf = "$ipath/cluster$sc/?sd_$sc/$yy$mm$dd".'f?.?a'."$sc";
#      } elsif ($bs eq 'BS') {
#        next if -e "$logfiledir/C$sc"."_$yy$mm$day"."_B.BSNSlog";
#        $rawf="$ipath/cluster$sc/?sd_$sc/$yy$mm$dd".'fb.?a'."$sc";
#      }
#    }
#    
##    @mrgfiles=glob($rawf);  # remove empty files
##    $fn=0;
##    foreach $mf (@mrgfiles) {
##      splice @mrgfiles, $fn, 1 if -z $mf;
##      $fn++;
##    }
#        
#    
#    @files=glob("$rawf*");@mrgfiles=();  # remove empty files and decompress
#    foreach $mf (@files) {                                    
#      next if -z $mf;       
#      $mff=$mf; $mff=~s/\.gz//; push @mrgfiles, $mff;  
#      `gunzip $mf` if $mf =~/\.gz$/;                           
#    }                                                         
    
    
    
        @mrgfiles=selectraw(ICL=>$ICL,sc=>$sc,bs=>$bs,yy=>$yy,mm=>$mm,dd=>$dd,dv=>'last');
    
    
    
    
    #print "@mrgfiles\n";next;
    #next if -z $mrgfile or ! -e $mrgfile;
    open LOGF, "<$logfile";
    $new_range=0;   $old_range=$new_range;
    $begin='00:00'; $end=$begin;
    while (<LOGF>) {
      if (/R\s+(\d)>FGM\s+sensor\s+range\s+(\d)/) {
        $new_range=$1;
        die 'something wrong with range identification' unless ($new_range eq $2);
        if ($new_range=~/2|6|7/) {$new_range=0 unless $all}
      } elsif (/B\s+\d{4}-\d\d-\d\dT(\d\d:\d\d):\d\d\.\d\d\dZ/) {
        $begin=$1;
        $reverse ? ($direction=-1) : ($direction=1) ;
        $direction*=$jump;
        if (($new_range - $old_range) eq $direction) {
          next if (($new_range == 0) or ($old_range == 0));
          $ms_begin=timp1($begin)+60000;
          if ($ms_begin >= 86100000) {
            print "too late\n";
            $old_range=$new_range;
            next;
          } 
          $ms_end=timp1($end);#-60000;
          if ($ms_begin <= 300000) {
            print "too early\n";
            $old_range=$new_range;
            next;
          }
          $old_begin = timp2($ms_end-300000);
          $old_end   = timp2($ms_end);
          $old_begin =~/(\d\d):(\d\d):\d\d\.\d\d\d/;
          $oh=$1; $om=$2;
          $old_ofile=
           "c$sc"."_$yy$mm$dd"."_$oh$om"."r$old_range".'to'."$new_range.uncal";
          $old_iofile=
           "c$sc"."i_$yy$mm$dd"."_$oh$om"."r$old_range".'to'."$new_range.uncal";
          unlink "$opath/$old_ofile", "$opath/$old_iofile";
          system "$exepath/ddsmrg @mrgfiles                    |
                  $exepath/ddscut -b T$old_begin -e T$old_end  |
                  $exepath/fgmtel $All                         |
                  $exepath/fgmcut -r $old_range                |
                  $exepath/fgmvec -a -m -f -t3 -r -o $opath/$old_ofile";

          if ($inboard) {
            system "$exepath/ddsmrg @mrgfiles                    |
                    $exepath/ddscut -b T$old_begin -e T$old_end  |
                    $exepath/fgmtel -s $All                         |
                    $exepath/fgmcut -r $old_range                |
                    $exepath/fgmvec -a -m -f -t3 -r -o $opath/$old_iofile";
          }
          
          $new_begin = timp2($ms_begin);
          $new_begin =~/(\d\d):(\d\d):\d\d\.\d\d\d/;
          $nh=$1; $nm=$2;
          $new_end   = timp2($ms_begin+300000);
          $new_ofile=
           "c$sc"."_$yy$mm$dd"."_$nh$nm"."r$new_range".'f'."$old_range.uncal";
          $new_iofile=
           "c$sc"."i_$yy$mm$dd"."_$nh$nm"."r$new_range".'f'."$old_range.uncal";
          unlink "$opath/$new_ofile", "$opath/$new_iofile";
          system "$exepath/ddsmrg @mrgfiles                    |
                  $exepath/ddscut -b T$new_begin -e T$new_end  |
                  $exepath/fgmtel $All                         |
                  $exepath/fgmcut -r $new_range                |
                  $exepath/fgmvec -a -m -f -t3 -r -o $opath/$new_ofile";
          
          if ($inboard) {
            system "$exepath/ddsmrg @mrgfiles                    |
                    $exepath/ddscut -b T$new_begin -e T$new_end  |
                    $exepath/fgmtel -s $All                         |
                    $exepath/fgmcut -r $new_range                |
                    $exepath/fgmvec -a -m -f -t3 -r -o $opath/$new_iofile";
          }
          
          
          if ($mix) {
            $mix_begin = timp2($ms_end  -150000);
            $mix_end   = timp2($ms_begin+150000);
            $mix_begin =~/(\d\d):(\d\d):\d\d\.\d\d\d/;
            $mixh=$1; $mixm=$2;
            $mix_ofile=
            "c$sc"."_$yy$mm$dd"."_$mixh$mixm"."r$old_range".'and'."$new_range.uncal";
            $mix_iofile=
            "c$sc"."i_$yy$mm$dd"."_$mixh$mixm"."r$old_range".'and'."$new_range.uncal";
            unlink "$opath/$mix_ofile", "$opath/$mix_iofile";
            system "$exepath/ddsmrg @mrgfiles                      |
                    $exepath/ddscut -b T$mix_begin -e T$mix_end    |
                    $exepath/fgmtel $All                           |
                    $exepath/fgmcut                                |
                    $exepath/fgmvec -a -m -f -t3 -r -o $opath/$mix_ofile";
            if ($inboard) {
              system "$exepath/ddsmrg @mrgfiles                      |
                      $exepath/ddscut -b T$mix_begin -e T$mix_end    |
                      $exepath/fgmtel -s $All                           |
                      $exepath/fgmcut                                |
                      $exepath/fgmvec -a -m -f -t3 -r -o $opath/$mix_iofile";
            }
          }
        }
        $old_range=$new_range;
      } elsif (/E\s+\d{4}-\d\d-\d\dT(\d\d:\d\d):\d\d\.\d\d\dZ/) {
        $end=$1;
      }
    } 
    
#    # recompress 
#    foreach $mf (@files) {                                    
#      next if -z $mf;       
#      if ($mf=~/\.gz$/){substr($mf,-3,3)=''; `gzip $mf`;}                 
#    }           
                                                  
    close LOGF;
  }
}

#-------------------------------------------------------------------------

1;

__END__

=head1 NAME

findRC.pl - Finds the range changes times and produces the FGM F<uncal> files
for them.

=head1 SYNOPSIS

B<findRC.pl> B<--month> I<month> [B<--day> I<day>] [B<--year> I<year>] [B<--inboard>]
[B<--spacecraft> I<spacecraft>] [B<--(no)log>] [B<--all>] [B<--All>] [B<--centered>] 
[B<--reverse>] [B<--ICL>] [B<--help>]

=head1 DESCRIPTION

This script finds the range changes times and produces the 5 minutes  FGM
F<uncal> files used for calibration. The times for the range changes are read
from the log files produced by  the B<listfgm.pl> script. Then the FGM F<uncal>
files for the 5 minutes  immediately before and immediately after the range
change are produced. Compressed input files are transparently managed. By 
default only increasing range changes are processed. This can be changed with 
the B<-reverse> option.


=head1 OPTIONS

=over 4

=item B<-m> I<month>, B<--month> I<month> 

The month. One or two digits. Mandatory argument.

=item B<-d> I<day>, B<--day> I<day>

The day. One or two digits. Without this option all days of the month are
processed.

=item B<-y> I<year>, B<--year> I<year>

The year. One or two digits. Default is the current year.

=item B<-s> I<spacecraft>, B<--spacecraft> I<spacecraft>

The spacecraft number (1-4) or list of spacecraft e.g B<-s> C<'1 3 4'>. 
Default all spacecraft.

=item B<-a>, B<--all>

If given, all range changes are processed. If omitted, the range 
changes from range 2 and range changes to and from range 6 and 7 are omitted.

=item B<-A>, B<--All>

Pass the option '-a' to fgmtel. As a result all vectors, including 
range changes, calibration mode, and eclipses data will be produced. 
See the fgmtel man page. Default is to produced only non-marked vectors. 

=item B<-c>, B<--centered>

If given, also 5 minutes intervals centered on the range changes are produced.
By default only the before and after intervals are produced.

=item B<-i>, B<--inboard>

Produce uncal files also for the inboard sensors.

=item B<-I>, B<--ICL>

Use the Imperial College London raw data. 
Default is to use the ESTEC raw data.

=item B<-r>, B<--reverse>

Process decreasing range changes instead of the default increasing.

=item B<-j>, B<--jump> I<number of ranges>

By default I<number of ranges> is set to 1, i.e  consecutive ranges. 
However, since 2014 Cluster 1 begun jumping over one range (e.g. going
directly from r3 to r5 before falling to r4). Setting I<number of ranges> 
to 2 identifies these anomalous range changes.

=item B<-l>, B<--log>

Record the run to dailycal log file. Default is enabled. 
Can be disbled using the B<--nolog> option.

=item B<-h>, B<-?>, B<--help>

Prints a brief help message.

=back

=head1 DEPENDENCES

This script uses the following:

 ddscut,
 fgmtel,
 fgmcut,
 fgmvec.

=head1 ENVIRONMENT

=over 4

=item FGMROOT

Root for the FGM calibration directory structure. Default to F</home/FGM/> if
not set.

=item SATTPATH

Path to orbit parameters files. Default to F<$FGMROOT/log/atorb/> if not set.

=item FGMPATH

Path to calibration files (*.fgmcal and *.cfgnew). Default to
F<$FGMROOT/data/dcalf/> if not set.

=back

=head1 FILES

F<$FGMROOT/data/raw/ICL/$YY_$MM/> - Imperial input path

F<$FGMROOT/data/raw/ESTEC/cluster$sc/[n|b]sd_$sc/> - ESTEC (default) input path

F<$FGMROOT/log/cd_log/$YY_$MM/> - path to log files 

F<$FGMROOT/data/uncal/$YY_$MM/> - output path

F<C$sc_$YY$MM$DD_B.[NS/BS](.gz)> - Imperial input files

F<$YY$MM$DD.f[n|b].?a$sc(.gz)> - ESTEC (default) input files

F<C$sc_$YY$MM$DD_B.[NS/BSNS]log> - log files

F<c$sc_$YY$MM$DD_$hh$mmr$old_rangeto$new_range.uncal> - pre range change 
uncal files

F<c$sc_$YY$MM$DD_$hh$mmr$new_rangef$old_range.uncal> - post range change 
uncal files

F<c$sc_$YY$MM$DD_$hh$mmr$new_rangeand$old_range.uncal> - mixed range change 
uncal files

F<$FGMROOT/log/dailycal/dailycal_$YY$MM.log> - Dailycal log file.

=head1 AUTHOR

Dragos Constantinescu <d.constantinescu@tu-bs.de>

=cut







