#!/usr/bin/perl -w
use Getopt::Long qw(:config no_ignore_case bundling);
use lib $ENV{HOME}."/perl/modules";
use File::Basename;
use Pod::Usage;
use FGMperl;

$yy  = substr((localtime())[5],1);
$dd  = '??';
$sc  = '?';
$log = 1;
$ICL = 0;

@NSfiles=@BSfiles=();

$me="$0 @ARGV";

GetOptions ('h|help|?+'      => \$help, 
            'y|year=s'       => \$yy,
            'm|month=s'      => \$mm,
            'd|day=s'        => \$dd,
            's|spacecraft=s' => \$sc,
            'I|ICL'          => \$ICL,
            'l|log!'         => \$log);

pod2usage( -verbose => $help, -noperldoc => 1) if $help;

die 'Please use the --month option' unless $mm;

if (length($yy) eq 1) {$yy  ='0'.$yy}
if (length($mm) eq 1) {$mm  ='0'.$mm}
if (length($dd) eq 1) {$dd  ='0'.$dd}

$ENV{FGMROOT} =  '/home/FGM/'                unless $ENV{FGMROOT};
$ENV{FGMPATH} =  "$ENV{FGMROOT}/data/dcalf/" unless $ENV{FGMPATH};
$ENV{SATTPATH} = "$ENV{FGMROOT}/log/atorb/"  unless $ENV{FGMPATH};


#print "$data_v\n";die;

if ($ICL) {
  $inpath = $ENV{FGMROOT}."/data/raw/ICL/$yy"."_$mm";
  @NSfiles=glob("$inpath/C$sc"."_$yy$mm$dd".'_B.NS*');
  @BSfiles=glob("$inpath/C$sc"."_$yy$mm$dd".'_B.BS*');
} else {
  $inpath = $ENV{FGMROOT}."/data/raw/ESTEC/";
  @NSfiles=glob("$inpath/cluster$sc/nsd_$sc/$yy$mm$dd".'fn.??'."$sc".'{,.gz}');
  @BSfiles=glob("$inpath/cluster$sc/bsd_$sc/$yy$mm$dd".'fb.??'."$sc".'{,.gz}');
}
$outp   = $ENV{FGMROOT}."/log/cd_log/$yy"."_$mm";
$exep   = $ENV{FGMROOT}.'/bin';

open  LOG, ">>$ENV{FGMROOT}/log/dailycal/dailycal_$yy$mm.log";
print LOG localtime()." $ENV{USER} $me\n" if $log;
close LOG;

mkdir $outp;`chmod g+s $outp`;

################### Normal Science ############
$csc=$cday=0;
foreach $ifile (@NSfiles) {
  @stat=stat($ifile);
  next if ($stat[7] <= 250000); # no useful data here
  if ($ICL) {
    $ofile=$outp.'/'.basename($ifile).'log';
    $ofile=~s/\.gzlog/\.log/;
    $ifiles=$ifile;
  } else {
  
  
  
  
    basename($ifile)=~/(\d{6})fn\.\d\w(\d)/;
    $day=$1;$s=$2;
    next if (($day eq $cday) and ($s eq $csc));
    
$data_vns=selectraw(ICL=>$ICL,sc=>$s,bs=>'NS',yy=>$yy,mm=>$mm,dd=>substr($day,-2),dv=>'last');
        
    $ofile="$outp/C$s"."_$day".'_B.NSlog';
    $ifiles=$ifile; $ifiles=~s/\.\d$data_vns/\.\?$data_vns/;
    $csc=$s;$cday=$day;
  }
  
  
  
  
  
  
#  @NSmrgfiles=glob($ifiles);  # remove empty files    
#  $fn=0;                                            
#  foreach $mf (@NSmrgfiles) {                         
#    splice @NSmrgfiles, $fn, 1 if -z $mf;             
#    $fn++;                                          
#  }  
  
  @files=glob($ifiles);@NSmrgfiles=();  # remove empty files and decompress
  foreach $mf (@files) {                                      
    next if -z $mf;                                           
    $mff=$mf; $mff=~s/\.gz//; push @NSmrgfiles, $mff;  
    `gunzip $mf` if $mf =~/\.gz$/;                       
  }                                                           
      
  system "$exep/ddsmrg @NSmrgfiles | 
          $exep/fgmtel | 
          $exep/fgmls > $ofile";
  
  foreach $mf (@files) {  # recompress
    next if -z $mf;       
    if ($mf=~/\.gz$/){substr($mf,-3,3)=''; `gzip $mf`;}                 
  }
  
  print "-> $ofile\n";
}
###########################



#################### Burst Science ################## 
$csc=$cday=0;
foreach $BSfile (@BSfiles) {
  @stat=stat($BSfile);
  next if ($stat[7] <= 250000); # no useful data here
  if ($ICL) {
    $ofile=$outp.'/'.basename($BSfile).'log';
    $ofile=~s/\.gzlog/\.log/;
    $ifiles=$BSfile;
  } else {
    basename($BSfile)=~/(\d{6})fb\.\d\w(\d)/;
    $day=$1;$s=$2;
    next if (($day eq $cday) and ($s eq $csc));
    $data_vbs=selectraw(ICL=>$ICL,sc=>$s,bs=>'BS',yy=>$yy,mm=>$mm,dd=>substr($day,-2),dv=>'last');
    $ofile="$outp/C$s"."_$day".'_B.BSlog';
    $ifiles=$BSfile;$ifiles=~s/\.\d$data_vbs/\.\?$data_vbs/;
    $csc=$s;$cday=$day;
  }
  
#  @BSmrgfiles=glob($ifiles);  # remove empty files    
#  $fn=0;                                            
#  foreach $mf (@BSmrgfiles) {                         
#    splice @BSmrgfiles, $fn, 1 if -z $mf;             
#    $fn++;                                          
#  }         
  
        
  @files=glob($ifiles); @BSmrgfiles=();  # remove empty files and decompress 
  foreach $mf (@files) {                                      
    next if -z $mf;                                           
    $mff=$mf; $mff=~s/\.gz//; push @BSmrgfiles, $mff;  
    `gunzip $mf` if $mf =~/\.gz$/;                                                     
  }                                                           
   
  system "$exep/ddsmrg @BSmrgfiles | 
          $exep/fgmtel | 
          $exep/fgmls > $ofile";
     
  foreach $mf (@files) {  # recompress
    next if -z $mf;       
    if ($mf=~/\.gz$/){substr($mf,-3,3)=''; `gzip $mf`;}                 
  }
  
  print "-> $ofile\n";
  
  $NSfile=$BSfile; 
  if ($ICL) {
    $NSfile=~s/_B\.BS/_B\.NS/;
    $NSfiles=$NSfile;
  } else {
    $NSfile=~s/fb\./fn\./;
    $NSfile=~s/bsd_/nsd_/;
    
    $data_vns=selectraw(ICL=>$ICL,sc=>$s,bs=>'NS',yy=>$yy,mm=>$mm,dd=>substr($day,-2),dv=>'last');
    
    
    $NSfiles=$NSfile;$NSfiles=~s/\.\d$data_vns/\.\?$data_vns/;
  }
  next unless -e $NSfile;
  
  @files=glob($NSfiles);@NSmrgfiles=();  # remove empty files and decompress 
  foreach $mf (@files) {                                      
    next if -z $mf;                                          
    $mff=$mf; $mff=~s/\.gz//; push @NSmrgfiles, $mff;  
    `gunzip $mf` if $mf =~/\.gz$/;                                                    
  } 
  
  #$ofile=$outp.'/'.basename($BSfile).'NSlog';
  #$ofile="$outp/C$sc"."_$yy$mm$dd".'_B.BSNSlog';
  $ofile=~s/_B\.BSlog/_B\.BSNSlog/;
  
  system "$exep/ddsmrg @NSmrgfiles @BSmrgfiles | 
          $exep/fgmtel | 
          $exep/fgmls > $ofile";
  
  foreach $mf (@files) {  # recompress
    next if -z $mf;       
    if ($mf=~/\.gz$/){substr($mf,-3,3)=''; `gzip $mf`;}                 
  }

  print "=> $ofile\n";
}
#######################




#-------------------------------------

1;

__END__

=head1 NAME

listfgm.pl - Produces FGM log files.

=head1 SYNOPSIS

B<listfgm.pl> B<--month> I<month> [B<--year> I<year>] [B<--ICL>] 
[B<--spacecraft> I<spacecraft>] [B<--day> I<day>] [B<--(no)log>] [B<--help>]

=head1 DESCRIPTION

This script produces FGM log files containing records of data gaps and 
range changes. Compressed input files are transparently managed. 

=head1 OPTIONS

=over 4

=item B<-m> I<month>, B<--month> I<month> 

The month. One or two digits. Mandatory argument.

=item B<-y> I<year>, B<--year> I<year>

The year. One or two digits. Default is the current year.

=item B<-s> I<spacecraft>, B<--spacecraft> I<spacecraft>

The spacecraft number (1-4). Default all spacecraft.

=item B<-d> I<day>, B<--day> I<day>

The day. One or two digits. Default are all days in month.

=item B<-I> ,B<--ICL>

Use the Imperial College London raw data. 
Default is to use the ESTEC raw data.

=item B<-l>, B<--log>

Record the run to dailycal log file. Default is enabled. 
Can be disbled using the B<--nolog> option.

=item B<-h>, B<-?>, B<--help>

Prints a brief help message.

=back

=head1 ENVIRONMENT

=over 4

=item FGMROOT

Root for the FGM calibration directory structure. Default to F</home/FGM/> if
not set.

=item FGMPATH

Path to calibration files (*.fgmcal and *.cfgnew). Default to
F<$FGMROOT/data/dcalf/> if not set.

=back

=head1 FILES

F<$FGMROOT/data/raw/ICL/$yy_$mm/> - Imperial input path

F<$FGMROOT/data/raw/ESTEC/cluster$sc/[n|b]sd_$sc/> - ESTEC (default) input path

F<$FGMROOT/log/cd_log/$yy_$mm> - output path

F<C$sc_$yy$mm$dd_B.[N/B]S(.gz)> - Imperial input files

F<$yy$mm$dd.f[n|b].?a$sc(.gz)> - ESTEC (default) input files

F<C$sc_$yy$mm$dd_B.[N/B]Slog> - log files

F<$FGMROOT/log/dailycal/dailycal_$yy$mm.log> - Dailycal log file.

=head1 DEPENDENCES

This script uses the following:

 fgmtel,
 fgmls.

=head1 AUTHOR

Dragos Constantinescu <d.constantinescu@tu-bs.de>

=cut





