#!/usr/bin/perl -w
use Getopt::Long qw(:config no_ignore_case bundling);
use Pod::Usage;

# this version should run on deimos (not on libs)

$yy     = substr((localtime())[5],1);
$scstr  = '1 2 3 4';
$help   =  0;
$log    =  1;
$idl    =  1;
$ICL    =  0;
$merge  =  0;
$b      =  1;
$e      = 31;
$tbegin = '00:00:10.000';
$tend   = '23:59:50.000';

$ENV{FGMVERSION} ? ($version=$ENV{FGMVERSION}) : ($version='3');

$me="$0 @ARGV";

#$wd='/export/cluster2/pp/';

GetOptions ('h|help|?+'      => \$help, 
            'y|year:i'       => \$yy,
            'm|month:i'      => \$mm,
            'b|begin:s'      => \$b,
            'e|end:s'        => \$e,
            'd|days:s'       => \$dstr,
            's|spacecraft:s' => \$scstr,
            'I|ICL'          => \$ICL,
            'M|Merge'        => \$merge,
            'l|log!'         => \$log,
            'i|idl!'         => \$idl,
            'v|version:s'    => \$version);

pod2usage( -verbose => $help, -noperldoc => 1) if $help;

die 'Please use the --month option' unless $mm;

if (length($yy)      eq 1) {$yy       = '0'.$yy}
if (length($mm)      eq 1) {$mm       = '0'.$mm}
if (length($version) eq 1) {$version  = '0'.$version}

@scarr=split ' ', $scstr ;

@days=();
if ($dstr) {
  @days_list=split ' ', $dstr;
  foreach $element (@days_list) {
    if ($element=~/^\d{1,2}$/) {
      push @days, $element
    } elsif ($element=~/^(\d{1,2})-(\d{1,2})$/) {
      for ($dd=$1;$dd<=$2;$dd++) {push @days, $dd}
    } else {die "incorrect day specification!"}
  }
} else {
  if (length $b ge 3){
    $tbegin='00:00:00.000';
    substr($tbegin,0,length($b)-2)=substr($b,2);
    $b= substr $b,0,2;
  }
  if (length $e ge 3){
    $tend='00:00:00.000';
    substr($tend,0,length($e)-2)=substr($e,2);
    $e= substr $e,0,2;
  }
  for ($dd=$b;$dd<=$e;$dd++) {push @days, $dd}
}

foreach $dd (@days) {$dd='0'.$dd if (length($dd) eq 1)}

# $ENV{FGMROOT}  = $wd;                                               
# $ENV{FGMPATH}  = "$ENV{FGMROOT}/precal/";
# $ENV{SATTPATH} = "$ENV{FGMROOT}/input/cddaten/atorb/";        
# $exepath       = "$ENV{FGMROOT}/bin";                               
# $outp          = "$ENV{FGMROOT}/output/cal/";                 
# $idlpath       = "$ENV{FGMROOT}/idl/";

$ENV{FGMROOT}  = '/home/FGM/'                unless $ENV{FGMROOT};
$ENV{FGMPATH}  = "$ENV{FGMROOT}/data/dcalf/" unless $ENV{FGMPATH};
$ENV{SATTPATH} = "$ENV{FGMROOT}/log/atorb/"  unless $ENV{SATTPATH};
$exepath       = "$ENV{FGMROOT}/bin";                               
$outp          = "$ENV{FGMROOT}/data/cal/";                 
$idlpath       = "$ENV{FGMROOT}/idl/";

if ($ICL) {
  #$inpp = $ENV{FGMROOT}."input/pegasus/$yy"."_$mm/";
  $inpp = $ENV{FGMROOT}."/data/raw/ICL/$yy"."_$mm"
} else {
  #$inpp = $ENV{FGMROOT}."input/cddaten/";
  $inpp = $ENV{FGMROOT}."/data/raw/ESTEC/";
}

#print "$inpp\n"; die;

#open  LOG, ">>/export/cluster2/pp/scripts/log/dailycal_$yy$mm.log";
open  LOG, ">>$ENV{FGMROOT}/log/dailycal/dailycal_$yy$mm.log";
print LOG localtime()." $ENV{USER} $me\n" if $log;
close LOG;

chdir($ENV{FGMROOT});

@daysOK=@days; # will contain only days for which data actually exist
@nodata=();

foreach $sc (@scarr) {
  $iday=0;
  foreach $dd (@days) {
    $begin_time = "20$yy-$mm-$dd".'T'.$tbegin.'Z';
    $end_time   = "20$yy-$mm-$dd".'T'.$tend.'Z';
    $calfile    = "C$sc"."_20$yy$mm$dd".'_V'.$version.'.fgmcal';
    $r7daily    = "C$sc"."_20$yy$mm$dd".'range7.fgmcal';
    $r7default  = "C$sc".'_range7.fgmcal';
    $outputfile = "c$sc"."_20$yy$mm$dd".'_cfdv'.$version.'.cal';
    
    if (-e "$ENV{FGMPATH}/$r7daily") {`cp $ENV{FGMPATH}/$r7daily $ENV{FGMPATH}/$r7default`}

    if ($ICL) {
      @NSfiles=glob("$inpp"."/C$sc"."_$yy$mm$dd".'_B.NS*');
      @BSfiles=glob("$inpp"."/C$sc"."_$yy$mm$dd".'_B.BS*');
    } else {
#      @NSfiles=glob("$inpp"."cluster$sc/nsd_$sc/$yy$mm$dd".'fn.?a'."$sc".'{,.gz}');
#      @BSfiles=glob("$inpp"."cluster$sc/bsd_$sc/$yy$mm$dd".'fb.?a'."$sc".'{,.gz}');
    
      $data_vns=selectraw0(sc=>$sc,bs=>'NS',yy=>$yy,mm=>$mm,dd=>$dd,dv=>'last');
      $data_vbs=selectraw0(sc=>$sc,bs=>'BS',yy=>$yy,mm=>$mm,dd=>$dd,dv=>'last');
    
      @NSfiles=glob("$inpp"."cluster$sc/nsd_$sc/$yy$mm$dd".'fn.?'."$data_vns$sc".'{,.gz}');
      @BSfiles=glob("$inpp"."cluster$sc/bsd_$sc/$yy$mm$dd".'fb.?'."$data_vbs$sc".'{,.gz}');
    
#print "$inpp"."cluster$sc/nsd_$sc/$yy$mm$dd".'fn.?'."$data_vns$sc".'{,.gz}'."\n";die;

    }


    # print "-- @NSfiles --\n-- @BSfiles --\n"; die;
    # print "$inpp"."/C$sc"."_$yy$mm$dd".'_B.NS*'."\n"; die;

    @NSmrgfiles=();  # remove empty files from merging list
    foreach $mf (@NSfiles) {                                    
      next if -z $mf;                                         
      push @NSmrgfiles, $mf;                                    
    } 
    @BSmrgfiles=();  
    foreach $mf (@BSfiles) {             
      next if -z $mf;                    
      push @BSmrgfiles, $mf;             
    } 
    
    if ($merge) {
      @ifiles=(@NSmrgfiles,@BSmrgfiles);
    } else {
      if ($#NSmrgfiles eq -1) {
        @ifiles=@BSmrgfiles;
      } else {
        @ifiles=@NSmrgfiles;
      }
    }
    
    $inputfiles="@ifiles";
    $inputfiles=~s/\.gz//g;
    
   # $ENV{inputfiles}  = "C$sc"."_$yy$mm$dd".'_B.NS';
   # $ENV{inputfiles}  = "C$sc"."_$yy$mm$dd".'_B.BS' unless -e "$ENV{INPP}$ENV{inputfiles}";

    # only normal OR burst...  to use both the idl script fill_gaps.pro has
    # to be fixed... see Cluster 4 on 11 04 2010
    #$ENV{inputfiles}  = "C$sc"."_$yy$mm$dd".'_B.BS';
    #$ENV{inputfiles}  = "C$sc"."_$yy$mm$dd".'_B.?S'; # both burst and normal science
    
    #print $ENV{inputfiles};die;
    
    #@ifiles=split( /\s/, $ENV{inputfiles});
    
    foreach $ifile (@ifiles) {`gunzip $ifile` if $ifile =~/\.gz$/;}
    
    system "$exepath/ddsmrg $inputfiles                 |                        
            $exepath/ddscut -b $begin_time -e $end_time |             
            $exepath/fgmtel                             |                                   
            $exepath/fgmcal -a -c \$FGMPATH/$calfile    |                  
            $exepath/fgmvec -a -m -f -t3 -r -o $outp/$outputfile";    
  
    # print "$exepath/ddsmrg $inputfiles                 |                      $
    #         $exepath/ddscut -b $begin_time -e $end_time |
    #         $exepath/fgmtel                             |                      $
    #         $exepath/fgmcal -a -c \$FGMPATH/$calfile    |
    #         $exepath/fgmvec -a -m -f -t3 -r -o $outp/$outputfile";
    # die;

    foreach $ifile (@ifiles) {
      if ($ifile=~/\.gz$/){substr($ifile,-3,3)=''; `gzip $ifile`;}
    }
    
    if (-z "$outp/$outputfile" or not -e "$outp/$outputfile"){
      push @nodata, splice @daysOK, $iday, 1;
      next;
    }
    $iday++;
  }
  @days=@daysOK;
}

$spec_cfg="$idlpath/fgm_spectra.cfg"; 
open  SCFG, ">$spec_cfg";
print SCFG "$yy$mm    # yymm\n";
print SCFG join(',',split(' ',$scstr))."    # sc\n";
print SCFG join(',',@daysOK)."   # days\n";
print SCFG "$version   # version\n";
close SCFG;

if ($idl) {
  chdir($idlpath);
  system "idl -quiet -e '@./fgm_spectra.batch'";
}else{
  print "\a\n";select(undef, undef, undef, 0.3);
  print "\a\n";select(undef, undef, undef, 0.1);
  print "\a\n";select(undef, undef, undef, 0.1);
  print "\a\n";select(undef, undef, undef, 0.3);
  print "\a\n";select(undef, undef, undef, 0.2);
  print "\a";
}

print "\n     ######## WARNING #########
Data not available on: $yy-$mm-@nodata\n\n" if $nodata[0];

#-------------------------------------------------------------------------

#--------------------------------------------------------------------
sub selectraw0 {
  my(%args)=@_;
  my $yy=$args{'yy'};
  my $dd=$args{'dd'};
  my $mm=$args{'mm'};
  my $sc=$args{'sc'};
  my $bs=$args{'bs'};  
  my $dv=$args{'dv'};  
  my ($ipath,$rawf,$mf,$file);
  my $last_v = $dv;
  my @files=(); my @files_allv=(); my @versions=();
  if (length($yy) eq 1) {$yy ='0'.$yy;}
  if (length($mm) eq 1) {$mm ='0'.$mm;} 
  if (length($dd) eq 1) {$dd ='0'.$dd;}
  if ($dv eq 'last') {$dv='?';}
   
  #$ipath = $ENV{FGMROOT}."input/cddaten";
  $ipath = $ENV{FGMROOT}."data/raw/ESTEC";
  if ($bs eq 'NS') {
    $rawf="$ipath/cluster$sc/?sd_$sc/$yy$mm$dd".'fn.?'."$dv$sc";
  } elsif ($bs eq 'BSNS') {
    $rawf = "$ipath/cluster$sc/?sd_$sc/$yy$mm$dd".'f?.?'."$dv$sc";
  } elsif ($bs eq 'BS') {
    $rawf="$ipath/cluster$sc/?sd_$sc/$yy$mm$dd".'fb.?'."$dv$sc";
  }
  foreach $mf (glob("$rawf*")) {
    next if -z $mf;
    push @files, $mf;
    if ($dv eq '?') {
      $mf =~/\.\d(\w)$sc$/;
      push @versions, $1; # store data versions
    }
  }
  if ($dv eq '?') {
    @versions=sort(@versions);
    $last_v=$versions[$#versions-1];    
  }
  print "$rawf\n";
  return $last_v;
}


#--------------------------------------------------------------------

1;

__END__

=head1 NAME

makecal.pl - Produces FGM F<*.cal> files. 

=head1 SYNOPSIS

B<makecal.pl> B<--month> I<month> [B<--year> I<year>] 
[B<--days> I<days_list> | B<--begin> I<day_begin> B<--end> I<day_end>]
[B<--spacecraft> I<spacecraft>] [B<--(no)idl>] [B<--ICL>] [B<--Merge>] 
[B<--version> I<version>] [B<--(no)log>] [B<--help>]

=head1 DESCRIPTION

This script produces the FGM calibrated F<*.cal> files using the calibration 
(F<*.fgmcal>) files. It also produces the cfg file for C<fgm_spectra.pro> idl
script and runs it to produce the spectra. Compressed input files are
transparently managed. If data is missing for one spacecraft on one day, then
calibration files and spectra are not produced for the other spacecraft on that
day either. For this reason, the dates and spacecraft should be choosen
carefuly. If daily calibration files for range 7 are found, they are used, 
otherwise, the default range 7 calibration files are used. 

=head1 OPTIONS

=over 4

=item B<-m> I<month>, B<--month> I<month> 

The month. One or two digits. Mandatory argument.

=item B<-y> I<year>, B<--year> I<year>

The year. One or two digits. Default is the current year.

=item B<-s> I<spacecraft>, B<--spacecraft> I<spacecraft>

The spacecraft number (1-4) or list of spacecraft e.g B<-s> C<'1 3 4'>. 
Default all spacecraft.

=item B<-d> I<days_list>, B<-d-ays> I<days_list>

List of days given as a string. Ranges are permitted,  e.g B<-d> C<'3 12 15-28
30'>. If niether B<--days>, B<--begin>, or B<--end> options are given, than the
entire month is processed. 

=item B<-b> I<day_begin>, B<--begin> I<day_begin>

First day in the sequence. Can be an one or two digits integer in which case 
the starting time is 00:00:00.000, or can have the starting time attached.  In
this last case, the first two digits represent the day and the rest is the 
time. Example: B<-b> C<2> or B<-b> C<2815> or B<-b> C<2815:20>, etc. Default
value for this option is 1.

=item B<-e> I<day_end>, B<--end> I<day_end>

Last day in sequence. Same format as above. Default value is 31.

=item B<-I> ,B<--ICL>

Use the Imperial College London raw data. 
Default is to use the ESTEC raw data.

=item B<-M>, B<--Merge>

Merge normal science with burst science data. The default is to use 
only normal science data when available and only burst science when normal
science is not available (and burst science is..).

=item B<-l>, B<--log>

Record the run to dailycal log file. Default is enabled. 
Can be disbled using the B<-nolog> option.

=item B<-v> I<version>, B<--version> I<version>

Version of the calibration files. If this option is not given then the
environment variable FGMVERSION is used. If FGMVERSION is not set, then the
default version is 3.

=item B<-i>, B<--idl> 

Run the C<fgm_spectra.pro> IDL script to produce the spectra
for the given days. This option is enabled by default. 
To disable it, negate: B<--noidl>.

=item B<-h>, B<-?>, B<--help>

Prints a brief help message.

=back

=head1 ENVIRONMENT

=over 4

=item FGMROOT

Root for the FGM calibration directory structure. Default to
F</export/cluster2/pp/>.

=item FGMPATH

Path to calibration files (*.fgmcal and *.cfgnew). Default to
F<$FGMROOT/precal/>.

=item SATTPATH

Path to orbit parameters files. Default to F<$FGMROOT/input/cddaten/atorb/>.

=item FGMVERSION

Calibration files version.

=back

=head1 FILES

F</export/cluster2/pp/input/pegasus/$yy_$mm/> - input path

F</export/cluster2/pp/output/cal/> - output path

F</export/cluster2/pp/input/pegasus/$yy_$mm/> - path to IC calibration files

F</export/cluster2/pp/input/cddaten/cluster$sc/(n|b)sd_$sc/> - path to ESTEC 
calibration files

F<C$sc_$yy$mm$dd_B.(B|N)S(.gz)> - IC input raw files

F<$yy$mm$ddf(b|n).?a$sc(.gz)> - ESTEC input raw files

F<C$sc_20$yy$mm$dd_V??.fgmcal> - calibration files

F<C$sc_20$yy$mm$dd_range7.fgmcal> - daily range 7 calibration files

F<C$sc_range7.fgmcal> - default range 7 calibration files

F<c$sc_20$yy$mm$dd_cfdv??.cal> - FGM calibrated data files

F</export/cluster2/pp/idl/fgm_spectra.cfg> - Config file for C<fgm_spectra.pro>. 
It contains the spacecraft and days for which spectra are produced.

F</export/cluster2/pp/scripts/log/dailycal_$yy$mm.log> - Dailycal log file.

=head1 DEPENDENCES

This script uses the following:

 ddscut,
 fgmtel,
 fgmcut,
 fgmvec,
 fgm_spectra.pro.

=head1 AUTHOR

Dragos Constantinescu <d.constantinescu@tu-bs.de>

=cut

