#!/usr/bin/perl -w
use Getopt::Long qw(:config no_ignore_case bundling);
use lib $ENV{HOME}."/perl/modules";
use Utils;
use Pod::Usage;
use FGMperl;

$yy      = substr((localtime())[5],1);
$mm      = '';
$inboard = '';
$log     = 1;
$ICL     = 0;
$length  = 5;
$only    = 0;
$check   = 1;
$all     = 0;

$me="$0 @ARGV";

GetOptions ('h|help|?+'  => \$help, 
            'y|year:i'   => \$yy,          
            'm|month:s'  => \$mm,          
            'i|inboard'  => \$inboard,
            'I|ICL'      => \$ICL,
            'L|Length:i' => \$length,
            'A|All'      => \$all,
            'o|only'     => \$only,
            'c|check!'   => \$check,
            'l|log!'     => \$log);    

pod2usage( -verbose => $help, -noperldoc => 1) if $help;


if (length($yy) eq 1) {$yy  ='0'.$yy}
if (length($mm) eq 1) {$mm  ='0'.$mm}

if ($all) {$all='-a'} else {$all=''}

$ENV{FGMROOT}  = '/home/FGM/'                unless $ENV{FGMROOT};
$ENV{FGMPATH}  = "$ENV{FGMROOT}/data/dcalf/" unless $ENV{FGMPATH};
$ENV{SATTPATH} = "$ENV{FGMROOT}/log/atorb/"  unless $ENV{SATTPATH};

$exepath = "$ENV{FGMROOT}/bin";

chdir $ENV{FGMROOT};

if ($mm) {$cfgfile="cfg/uncal_$yy$mm".'.txt';$inboard=1;
} else {$cfgfile='cfg/uncal.txt'}

open CFGF, "<$cfgfile";

$ycfg=$mcfg=0;
while (<CFGF>) {
  $ycfg=$1 if (/^\s*y{1,2}\s*=\s*(\d\d)\s*$/);
  $mcfg=$1 if (/^\s*m{1,2}\s*=\s*(\d\d)\s*$/);
}

$yy=$ycfg if $ycfg;
$mm=$mcfg if $mcfg;

if ($ICL) {
  $ipath = $ENV{FGMROOT}."/data/raw/ICL/$yy"."_$mm";
} else {
  $ipath = $ENV{FGMROOT}."/data/raw/ESTEC/";
}

$opath="$ENV{FGMROOT}/data/uncal/$yy"."_$mm/";

open  LOG, ">>$ENV{FGMROOT}/log/dailycal/dailycal_$yy$mm.log";
print LOG localtime()." $ENV{USER} $me\n" if $log;
close LOG;

mkdir $opath; `chmod g+s $opath`;
@empty_files=@wrong_range=();

seek(CFGF, 0, 0);
while (<CFGF>) {
  if (/^(\d\s+\d\s+\d\s+\d)\s+(\d)\s+(\d\d)\s+(\d\d)\s+(\d\d)\s*$/){
    @sc=split(' ',$1); $range=$2; $dd=$3; $hh=$4; $min=$5;
    $tbegin="20$yy-$mm-$dd"."T$hh:$min:00.000Z";
    $tend="20$yy-$mm-$dd".'T'.timp2(timp1($tbegin)+$length*60*1.e3).'Z';
    
    if ($only) {$fgmcutrange=" -r $range ";} else {$fgmcutrange='';} 
    
    for ($s=1;$s<=4;$s++) {
      next unless $sc[$s-1];
      print "$tbegin -- sc $s in range $range\n";
      
      #$ifile=$ipath."C$s"."_$yy$mm$dd".'_B.NS';
      #$ifile=$ipath."C$s"."_$yy$mm$dd".'_B.BS' unless -e $ifile;
      # try merge the files
      
     # $ifiles=$ipath."C$s"."_$yy$mm$dd".'_B.?S';
      
#      if ($ICL) {
#        $ifiles="$ipath/C$s"."_$yy$mm$dd".'_B.?S';
#      } else {
#        $ifiles="$ipath/cluster$s/?sd_$s/$yy$mm$dd".'f?.?a'."$s";
#      }
#      
#      @files=glob($ifiles.'{,.gz}');@mrgfiles=();  # remove empty files
#      foreach $mf (@files) {
#        next if -z $mf;       
#        $mff=$mf; $mff=~s/\.gz//; push @mrgfiles, $mff;  
#        `gunzip $mf` if $mf =~/\.gz$/;                           
#      }
      
      
      @mrgfiles=selectraw(ICL=>$ICL,sc=>$s,bs=>'BSNS',yy=>$yy,mm=>$mm,dd=>$dd,dv=>'last');
      
      
      $ofile=$opath."c$s"."_$yy$mm$dd"."_$hh$min"."r$range.uncal";
      $iofile=$opath."c$s"."i_$yy$mm$dd"."_$hh$min"."r$range.uncal";
      system "$exepath/ddsmrg @mrgfiles            |
              $exepath/ddscut -b $tbegin -e $tend  |
              $exepath/fgmtel  $all     |
              $exepath/fgmcut       $fgmcutrange               |
              $exepath/fgmvec -a -m -f -t3 -r -o $ofile";
      if (-z $ofile) {
        `/usr/bin/beep -f 45 -l 500`;
        unlink $ofile;
        warn "NO DATA for Cluster$s on day $dd, file $ofile removed";
        push @empty_files, "spacecraft $s on day $dd\n";
      } else {
        open OFIL, "<$ofile";
        while (<OFIL>){
          warn "WRONG FORMAT IN $ofile !" unless ($_=~/^.+(C|D)\s+(\d)\s+\d\s+\d$/);
          next if (($range eq $2) or (not $check) or ($only));
          `/usr/bin/beep -f 45 -l 500`;
          unlink $ofile;
          warn "Wrong range for Cluster$s on day $dd, file $ofile removed";
          push @wrong_range, "spacecraft $s on day $dd\n";
          last;
        }
        close OFIL;#
#        if ($only) {
#          print "found wrong range in $ofile. ";
#          $tmpfile="$opath/tmp.uncal";
#          `cp $ofile $tmpfile`;
#          unlink $ofile;
#          open TMPF, "<tmpfile";
#          open OFIL,  ">$ofile";
#          while (<TMPF>) {
#          warn "WRONG FORMAT IN $ofile !" unless ($_=~/^.+(C|D)\s+(\d)\s+\d\s+\d$/);
#          print " #########################\n" if ($range eq $2);
#          
#          print OFIL if ($range eq $2);
#          }
#          close TMPF;
#          close OFIL;
#          
#        }
      }
      if ($inboard) {
        system "$exepath/ddsmrg @mrgfiles            |
                $exepath/ddscut -b $tbegin -e $tend  |
                $exepath/fgmtel -s $all |
                $exepath/fgmcut  $fgmcutrange                     |
                $exepath/fgmvec -a -m -f -t3 -r -o $iofile";
        if (-z $iofile) {
          unlink $iofile;
        } 
      }
      
      # recompress 
#      foreach $mf (@files) {                                  
#        next if -z $mf;       
#        if ($mf=~/\.gz$/){substr($mf,-3,3)=''; `gzip $mf`;}               
#      }   
      
    }
  }
}

close CFGF;

print "No data for:\n @empty_files" unless ($#empty_files eq -1);
print "Wrong range for:\n @wrong_range" unless ($#wrong_range eq -1);

#-------------------------------------------------------------------------

1;

__END__

=head1 NAME

mkuncal.pl - Produces the FGM F<uncal> files.

=head1 SYNOPSIS

B<mkuncal.pl> [B<--month> I<month>] [B<--year> I<year>] [B<--ICL>] [B<--All>] 
[B<--Length> I<length>] [B<--inboard>] [B<--(no)log>] [B<--(no)check>] [B<--help>]

=head1 DESCRIPTION

This script produces the 5 minutes FGM F<uncal> files used for calibration.
The dates, begin times, and ranges for each spacecraft are read from the 
uncal configuration file. Compressed input files are transparently managed. 

=head1 OPTIONS

=over 4

=item B<-m> I<month>, B<--month> I<month> 

The month. One or two digits. If given, the F<uncal_yymm.txt> configuration 
file is used and the B<-inboard> option is set. If omitted, the F<uncal.txt>
file is used instead. In the  latter case, the month must be given in the header
of the file.

=item B<-y> I<year>, B<--year> I<year>

The year. One or two digits. Default is the current year.

=item B<-i>, B<--inboard>

Produce uncal files also for the inboard sensors.

=item B<-I> ,B<--ICL>

Use the Imperial College London raw data. 
Default is to use the ESTEC raw data.

=item B<-A>, B<--All>

Pass the option '-a' to fgmtel. As a result all vectors, including 
range changes, calibration mode, and eclipses data will be produced. 
See the fgmtel man page. Default is to produced only non-marked vectors. 

=item B<-L> I<length>, B<--Length> I<length>

Length of the uncal interval in minutes. Default value is 5 minutes. 

=item B<-c>, B<--check>

Check if the range given in the F<uncal.txt> file corresponds with the 
range of the interval (from the log file). Default is yes.  
Can be disbled using the B<--nocheck> option.

=item B<-l>, B<--log>

Record the run to dailycal log file. Default is enabled. 
Can be disbled using the B<--nolog> option.

=item B<-h>, B<-?>, B<--help>

Prints a brief help message.

=back

=head1 ENVIRONMENT

=over 4

=item FGMROOT

Root for the FGM calibration directory structure. Default to F</home/FGM/> if
not set.

=item FGMPATH

Path to calibration files (*.fgmcal and *.cfgnew). Default to
F<$FGMROOT/data/dcalf/> if not set.

=item SATTPATH

Path to orbit parameters files. Default to F<$FGMROOT/log/atorb/> if not set.

=back

=head1 FILES

F<$FGMROOT/cfg/uncal.txt>, F<$FGMROOT/cfg/uncal_yymm.txt> - 
Configuration file giving the dates, ranges, and begin times for each 
spacecraft.

Format:

Header (optional for F<uncal_yymm.txt>):

C<y  = yy>

C<mm = mm>

Config lines:

C<sc1 sc2 sc3 sc4  range  day  hbeg  mbeg>

sc=0|1, range=2-7, 
day is given as two digits, hbeg is the begining hour (two digits), 
and mbeg is the begining minute (two digits).

F<$FGMROOT/data/raw/ICL/$yy_$mm/> - Imperial input path

F<$FGMROOT/data/raw/ESTEC/cluster$sc/[n|b]sd_$sc/> - ESTEC (default) input path

F<$FGMROOT/data/uncal/$yy_$mm/> - output path

F<C$s_$yy$mm$dd_B.[B|N]S> - Imperial input files

F<$yy$mm$dd.f[n|b].?a$sc> - ESTEC (default) input files

F<c$s_$yy$mm$dd_$hh$minr$range.uncal> - outboard FGM uncal files

F<c$si_$yy$mm$dd_$hh$minr$range.uncal> - inboard FGM uncal files

F<$FGMROOT/log/dailycal/dailycal_$yy$mm.log> - Dailycal log file.

=head1 DEPENDENCES

This script uses the following:

 ddscut,
 fgmtel,
 fgmcut,
 fgmvec.

=head1 AUTHOR

Dragos Constantinescu <d.constantinescu@tu-bs.de>

=cut






