/* cotrans.h -- definitions for performing coordinate transformations, and
 *              for using the CLUSTER FGM Fortran library from C or C++ programs
 *
 * Joerg Warnecke  (joerg@galsun.igpp.ucla.edu) & Tsyganenko (SPHCAR)
 -----------------------------------------------------------------------------*/

#ifndef _FGM_COTRANS_H
#define _FGM_COTRANS_H
#include <math.h>

/* Geographic-geocentric latitude and longitude of northern geomagnetic pole 
  #define MAGLAT   79.5// 79.1
  #define MAGLON  288.2// 288.6
*/

/* Radius of the earth [km] */
#define RE 6371.2

#ifdef __cplusplus
extern "C" {
#endif

/* ESA subroutines */
void   orbit_    ( double *, int *, int *, int *, int *, double *, double * );
void   pr2000_   ( double *, double * );
void   jd2000_   ( double *, int *, int *, int *, int *, int *, double * );
void   dj2000_   ( double *, int *, int *, int *, int *, int *, double * ); 

/* make LINUX compatible */
#ifdef DOUBLE_UNDERSCORE
#define calc_dipole_ calc_dipole__
#define iflu_orb_ iflu_orb__
#define iflu_att_ iflu_att__
#define gei_gse_ gei_gse__ 
#define gei_geo_ gei_geo__ 
#define scs_gse_ scs_gse__
#define gse_gsm_ gse_gsm__
#define gsm_sm_ gsm_sm__
#define MAIN_ MAIN__
#endif

/* Hapgood subroutine for dipole position */
void   calc_dipole_ ( int *, int *, double *, double *);
 
/* Cluster/FGM Fortran subroutines */
int    iflu_orb_ ( int *, char *, int );
int    iflu_att_ ( int *, char *, int );
void   gei_gse_  ( double *, double * );
void   gei_geo_  ( double *, double * );
void   sphcar_   ( float*,float*,float*,float*,float*,float*,int);
void   scs_gse_  ( double *, double *, double *, double * );
void   gse_gsm_  ( double *, double *, double *, double * );
void   gsm_sm_   ( double *, double *, double *, double * );
void   satt_     ( double *, int *, int *, int *, double *, double *,\
                   double *, double *, double *, double *, double * );

/* Cluster/FGM C subroutines */
int    j2ktrans  ( int code, double mjd, double *x, double *y, double *z );

#ifdef __cplusplus
}
#endif

#endif /* !_FGM_COTRANS_H */
