/*
 * Copyright (C) 1994/95/96 IGM TU Braunschweig, 2000/1 MPE Garching
 * new versions for pipeline modules:
 * fgmtel(7.0), fgmcal(6.3), fgmhrt(6.3)
 * - TM-mode switch handling changed
 * - multiple calibration files(recorded without path-info in the names)
 * - new IGRF2000 coefficients introduced in calc-dipole.f
 */

#define PROJECT "CLUSTER FGM DATA PROCESSING"
#define PROGRAM "fgmdp"
#define VERSION "1.1 (2001-06-10)" 
#define PURPOSE "generate high resolution or averaged CLUSTER FGM data"
#define CPRIGHT "Copyright (C) 1994/95/96/2000/01 IGM TU Braunschweig, MPE Garching"
#define USAGE "USAGE:

 fgmdp [<inf>...] [-b <begin>] [-e <end>] [-a <attf>] [-p [<posf>]]
       [-E <eclf>] [ -w [<float>]] [-i] [-x] [-l [<logf>]] [-o [<outf>]]
            
 fgmdp generates high resolution magnetic field vectors in GSE  
                 or averages over a user defined time interval. 
          
 The input file is a normal or burst mode science data file containing
 the raw FGM data, like those distributed on the raw data media (RDM).
 More than one input file may be specified to concatenate data. If no
 input file is given, the data will be read from stdin.  If option '-w'
 not used, default output is high resolution. The default output format
 is binary igm-structure. Use option '-x' to get an ASCII file. 
 ASCII output contains date/time, components of the magnetic field in [nT]
 and position vector components [km] in GSE coordinate system"

#define OPTIONS "OPTIONS:

  -b <begin> define the begin of time interval for the output
  
  -e <end>   define the end of time interval for the output

             The following formats may be used for the  <begin> and <end> 
             strings:
                ISO standard, like '2000-09-01T12:00:04.012Z'
                ISO standard, without date, like 'T12:00:04.012Z'
                seconds of the UNIX epoch, like '978420804.012443596'.

  -w <float>  compute averages over <float> seconds. Averaging intervals start 
              at full UT second. <float> must be larger then the sampling. 
              If option '-w' present, but no <float> specified, 
              spin-averages (PPs) are produced  (spin-offset= 26.3671875 deg).

     <float>  float number specifying the length of an averaging 
              interval in seconds. Fractions of seconds are taken into 
              account only for subunitary numbers.
              
  -a   use <attf> as attitude file. <attf> may contain DDS-headers, i.e.
       the raw attitude file from CDROM (*ga*) may be used.
       Default is to use the merged attitude file '$SATTPATH/satt.cl#',
       #=1,2,3,4 is the satellite number.

  -p   use <posfile> as orbit file (*ba* on the CDROM)for determing the 
       spacecraft's position. The file may, or may not contain DDS-headers. 
       Default is to use the short term orbit file `$ORBITPATH/stof.cl#', 
       (#=1,2,3,4) with DDS-headers beeing removed.
       If -p is used but <posfile> is omitted, the preprocessed long term 
       orbit file `$ORBITPATH/ltof.cl#' will be used.

  -E   read eclipse info from file <eclf>. <eclf> may contain DDS-headers, i.e.
       the raw attitude file from CDROM (*ta*) may be used.
       Default is '$SATTPATH/s{|l}tef.cl#', where #=1,2,3,4.

  -x   ASCII output; default output is binary IGM-format
  
  -i   append calfilename-info to the end of the ASCII output; to be used
       together with option '-x'. Default is to have the used calibration 
       file-name written in a separate file: 'cal.log'. A tailstring
       containing output column names is appended too.        

  -l   re-direct info from stderr to a logfile <logf>;
       if option '-l', but no filename given, default is: 'logfile' 
  
  -o   use <outf> as output file. Default is to write to a file called :
       C#_yyyymmdd_sys.igm or C#_yyyymmdd_sys.txt (if '-x'), 
       where #=1,2,3,4 stands for satellite number and sys for the output 
       coordinate system.

  -V   print version number on stdout, then exit."

#define AUTHOR "AUTHORS:
 
 Edita Georgescu      (eg@mpe.mpg.de)
 Karl-Heinz Fornacon  (k-h.fornacon@tu-bs.de)
 Stephan Buchert      (scb@stelab.nagoya-u.ac.jp)"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static char *errmsg[] =
   {
/* 0 */  "Type '%s -h' for help.\n",
/* 1 */  "ERROR in %s: Illegal option %s.\n",
/* 2 */  "ERROR in %s: Could not open input file %s.\n",
/* 3 */  "ERROR in %s: Could not evaluate command name (length = %d).\n",
   };

int main ( int argc, char *argv[], char *envp[] )
{
 FILE    *infile=NULL;
 char    ddsmrg[384]="", ddscut[128]="", fgmtel[128]="", fgmcal[128]="", 
         fgmhrt[128]="", fgmav[128]="", fgmpos[128]="", igmvec[128]="",
         cmd[1280]="", avgint[15]="", logf[128]="", outf[128]="",
         inp[256]="", copt;
 int     i, cutfl=0, num=0, avgout=0, ascout=0;
 float   avgdt;
 
/* initialize command strings & logfile-name */
fprintf (stdout,"%s\n",CPRIGHT);
 i = strlen ( argv[0] );
 if ( i < 5 )
   {
    fprintf ( stderr, errmsg[3], PROGRAM, i );
    exit(3);
   }
 else if ( i > 5 )
   {
    strncat ( ddsmrg, argv[0], i-5 );
    strncat ( ddscut, argv[0], i-5 );
    strncat ( fgmtel, argv[0], i-5 );
    strncat ( fgmcal, argv[0], i-5 );
    strncat ( fgmhrt, argv[0], i-5 );
    strncat ( fgmav,  argv[0], i-5 );
    strncat ( fgmpos, argv[0], i-5 );
    strncat ( igmvec, argv[0], i-5 );
   }

 strcat ( ddsmrg, "ddsmrg" );
 strcat ( ddscut, "ddscut" );
 strcat ( fgmtel, "fgmtel" );
 strcat ( fgmcal, "fgmcal -i cal.log" );
 strcat ( fgmhrt, "fgmhrt" );
 strcat ( fgmav,  "fgmav" );
 strcat ( fgmpos, "fgmpos" );
 strcat ( igmvec, "igmvec " );

/* get command line parameters */

 i = 1;

 while ( i < argc )
   {
    if (*argv[i] == '-')
      {
       copt = *(argv[i]+1);
       switch(copt)
         {
          case 'h':
             fprintf ( stdout, "\n%s  --  %s\n\n%s\n\n%s\n\n%s\n", \
                       PROGRAM, PURPOSE, USAGE, OPTIONS, AUTHOR );
             exit(0);

          case 'b':
             cutfl = 1; 
             strcat ( ddscut, " -b " );
             if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                i++;
                strcat ( ddscut, argv[i] ); 
               }
             else
                strcat ( ddscut, argv[i]+2 );
             break;

          case 'e': 
             cutfl = 1; 
             strcat ( ddscut, " -e " );
             if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                i++;
                strcat ( ddscut, argv[i] ); 
               }
             else
                strcat ( ddscut, argv[i]+2 );
             break;
             
          case 'a': 
             strcat ( fgmhrt, " -a " );
             if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                i++;
                strcat ( fgmhrt, argv[i] ); 
               }
             else
                strcat ( fgmhrt, argv[i]+2 );
             break;
             
          case 'E': 
             strcat ( fgmtel, " -e " );
             if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                i++;
                strcat ( fgmtel, argv[i] ); 
               }
             else
                strcat ( fgmtel, argv[i]+2 );
             break;

          case 'p': 
             strcat ( fgmpos, " -p " );
             if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                i++;
                strcat ( fgmpos, argv[i] ); 
               }
             else
                strcat ( fgmpos, argv[i]+2 );
             break;

          case 'i': 
             strcat ( igmvec, " -i cal.log" );
             break;
 
          case 'x':
             ascout = 1;
             break;

          case 'w':
             avgout = 1;
             if ( *(argv[i]+2) == '\0' && i+1 < argc )
                {
                if (*argv[i+1] != '-' ){
                   i++;
                   strcat ( avgint, argv[i] ); 
                   }
                }   
                else
                   strcat ( avgint, argv[i]+2 );
             
             if (strlen( avgint ) < 1)
                strcat( fgmav , " -p 26.3671875 ");      
                else
                {    
                avgdt=atof(avgint);
                if (avgdt >=1)
                   { 
                   strcat ( fgmav, " -s " );
                   strcat ( fgmav, avgint );
                   }
                   else
                   {
                   strcpy(avgint,"");
                   sprintf(avgint,"%4d",(int)(1./avgdt));
                   strcat ( fgmav, " -f " );
                   strcat ( fgmav, avgint );
                   }
                }
          break;

          case 'l':
            if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                if (*argv[i+1] != '-' ){
                  i++;
                  strcpy ( logf, argv[i] );
                  } 
                }
             else 
                strcpy ( logf, argv[i]+2 );
            if (strlen( logf ) < 2)
               strcat( logf, "logfile");      
            strcat ( cmd, " rm " );
            strcat ( cmd, logf );
            strcat ( cmd, ";" ); 
            strcat ( ddsmrg, " 2>> " );
            strcat ( fgmtel, " 2>> " );
            strcat ( fgmcal, " 2>> " );
            strcat ( fgmhrt, " 2>> " );
            strcat ( fgmpos, " 2>> " );
            strcat ( fgmav, " 2>> " );
            strcat ( igmvec, " 2>> " );
            strcat ( ddsmrg, logf );
            strcat ( fgmtel, logf );
            strcat ( fgmcal, logf );
            strcat ( fgmhrt, logf );
            strcat ( fgmpos, logf );
            strcat ( fgmav, logf );
            strcat ( igmvec, logf );
            break;
 
          case 'o':
             if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                if ( i+1 < argc && *argv[i+1] != '-' )
                  {
                  i++;
                  strcat ( outf, argv[i] ); 
                  }
               }
             else
                strcat ( outf, argv[i]+2 );
             break;

          case 'V': 
             fprintf ( stdout, "%s %s\n", PROGRAM, VERSION );
             exit(0);

          default:
             fprintf ( stderr, errmsg[1], PROGRAM, argv[i] );
             fprintf ( stderr, errmsg[0], argv[0] );
             exit(1);
         }
      }
    else
      {
       infile = fopen ( argv[i], "r" );
       if ( infile == NULL )
         {
          fprintf ( stderr, errmsg[2], PROGRAM, argv[i] );
          exit(2);
         }
       else 
         {
          fclose ( infile );
          strcat ( inp, " " );
          strcat ( inp, argv[i] );
          num++;
         }
      }
    i++;
   }
   
  
/* concatenate the command string */

 if (num > 1 )
   {
    strcat ( cmd, ddsmrg );
    strcat ( cmd, inp );
    strcat ( cmd, " | " );
   }
   else
   {
    strcat ( cmd, "cat " );
    strcat ( cmd, inp );
    strcat ( cmd, " | " );
   }
 if (cutfl)
   {
    strcat ( cmd, ddscut );
    strcat ( cmd, " | " );
   }
 strcat ( cmd, fgmtel );
 strcat ( cmd, " | " );
 strcat ( cmd, fgmcal );
 strcat ( cmd, " | " );
 strcat ( cmd, fgmhrt );
 strcat ( cmd, " | " );
 if (avgout) 
   {
    strcat ( cmd, fgmav );
    strcat ( cmd, " | " );
   } 
 if (!ascout){
    strcat ( fgmpos, " -o " );
    if (strlen(outf) > 2)
       strcat ( fgmpos, outf );
    strcat ( cmd, fgmpos );
    }
    else
    {
    strcat ( cmd, fgmpos );
    strcat ( cmd, " | " );
    strcat ( igmvec," -o " );
    if (strlen(outf) > 2)
       strcat ( igmvec, outf );
    strcat ( cmd, igmvec );
    } 
 printf( "%s\n",cmd );

/* execute and quit */
 i = system ( cmd );
 exit(i);
}

