/*
 * Copyright (C) 1994/95/96 IGM TU Braunschweig, 2000 MPE Garching
 * - modified V5.0 (1996-12-18)
 * - option l added: re-direction of stderr to a logfile
 * - modified V6.0 (2000-04-15) HELP, to take into account the
 *   modified fgmhrt which accepts <attfile> with DDS-headers
 * - '-e' option for explicitly given STEF file
 * - modified V6.1 (2000-05-25), because of new fgmtel version (V6.5)  
 *   cal_mode data not screened out anymore
 */

#define PROJECT "CLUSTER FGM DATA PROCESSING"
#define PROGRAM "fgm{p|s}pdb"
#define VERSION "6.2 (2001-01-29)"
#define PURPOSE "generate PPDB/SPDB interface files of CLUSTER FGM data"
#define CPRIGHT "Copyright (C) 1994/95/96,2000/1 IGM TU Braunschweig, MPE Garching"
#define USAGE "USAGE:

 fgmppdb [<inf>...] [-a <att>] [-e <ecl>] [-t <tl>] [-l [<log>]] [-o [<out>]]
 fgmspdb [<inf>...] [-a <att>] [-e <ecl>] [-t <tl>] [-l [<log>]] [-o [<out>]]

 fgmppdb generates an interface file (IFF) for the CSDS Prime Parameter
         Data Base of CLUSTER FGM data, containing spin averages of the 
         magnetic field.          
 fgmspdb generates an interface file (IFF) for the CSDS Summary Parameter
         Data Base of CLUSTER FGM data, containing one-minute averages of
         the magnetic field.

 The input file is a normal or burst mode science data file containing
 the raw FGM data, like those distributed on the raw data medium (RDM).
 More than one input file may be specified to concatenate data. If no
 input file is given, the data will be read from stdin."

#define OPTIONS "OPTIONS:

  -a   use <att> as attitude file. <att> may contain DDS-headers, i.e.
       the raw attitude file from CDROM (*ga*) may be used.
       Default is to use the merged attitude file '$SATTPATH/satt.cl#',
       where '#' is replaced by the satellite number.

  -e   read eclipse info from file <ecl>. <ecl> may contain DDS-headers, i.e.
       the raw attitude file from CDROM (*ta*) may be used.
       Default is '$SATTPATH/s{|l}tef.cl#', where #=1,2,3,4.

  -t   use <tl> as timelist file, containing start, end, and tag times
       for each averaging interval.
       Default: fgmppdb will use a spin phase offset of 26.367 degrees
       with respect to the sun reference pulses as start times, whereas
       fgmspdb will use full minutes as start times.

  -o   use <out> as output file. If -o is used but <out> is omitted,
       output is written to stdout.
       Default is to write to a file whose name is generated according
       to the IFF file naming convention.
         
  -l   re-direct info from stderr to a logfile <log>. 
       If -l is used but <log> is omitted, output is written to 'logfile'

  -V   print version number on stdout, then exit."

#define AUTHOR "AUTHORS:

 Edita Georgescu  (eg@mpe.mpg.de)
 Stephan Buchert  (scb@geophys.nat.tu-bs.de)
 Reinhold Kempen  (reinhold@geophys.nat.tu-bs.de)
 Joerg Warnecke   (joerg@geophys.nat.tu-bs.de)"


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


static char *errmsg[] =
   {
/* 0 */  "Type '%s -h' for help.\n",
/* 1 */  "ERROR in %s: Illegal option %s.\n",
/* 2 */  "ERROR in %s: Could not open input file %s.\n",
/* 3 */  "ERROR in %s: Could not evaluate command name (length: %d).\n",
   };

int main ( int argc, char *argv[], char *envp[] )
{
 FILE     *infile=NULL, *tmpfile;
 char     ddsmrg[384]="", fgmtel[128]="", fgmcal[128]="", 
          fgmhrt[128]="", fgmav[128]="", fgmiff[128]="",
          cmd[1024]="", logf[128]="", tmpname[L_tmpnam], copt;
 int      i, tlf=0, ppdb, num=0;


/* initialize command strings */
 fprintf (stdout,"%s\n",CPRIGHT);
 i = strlen ( argv[0] );
 if ( i < 7 )
   {
    fprintf ( stderr, errmsg[3], PROGRAM, i );
    exit(3);
   }
 else if ( i > 7 )
   {
    strncat ( ddsmrg, argv[0], i-7 );
    strncat ( fgmtel, argv[0], i-7 );
    strncat ( fgmcal, argv[0], i-7 );
    strncat ( fgmhrt, argv[0], i-7 );
    strncat ( fgmav,  argv[0], i-7 );
    strncat ( fgmiff, argv[0], i-7 );
   }

 strcat ( ddsmrg, "ddsmrg" );
 strcat ( fgmtel, "fgmtel -a 2" );
 strcat ( fgmcal, "fgmcal" );
 strcat ( fgmhrt, "fgmhrt" );
 strcat ( fgmav,  "fgmav"  );
 strcat ( fgmiff, "fgmiff"  );

 if (!strcmp(argv[0]+i-7,"fgmppdb"))
   {
/*  prime parameter data base */
    strcat ( fgmiff, " -p" );
    ppdb = 1;
   }
 else if (!strcmp(argv[0]+i-7,"fgmspdb"))
   {
/*  summary parameter data base */
    strcat ( fgmiff, " -s" );
    ppdb = 0;
   }
 else
   {
    fprintf ( stderr, errmsg[3], PROGRAM, i );
    exit(3);
   }
 
/* create a temporary file for storing the calibration file names */

 tmpnam ( tmpname );
 tmpfile = fopen ( tmpname, "w" );
 if ( tmpfile != NULL )
    fclose ( tmpfile );
 strcat ( fgmcal, " -i " );
 strcat ( fgmcal, tmpname );
 strcat ( fgmiff, " " );
 strcat ( fgmiff, tmpname );

/* get command line parameters */

 i = 1;

 while ( i < argc )
   {
    if (*argv[i] == '-')
      {
       copt = *(argv[i]+1);
       switch(copt)
         {
          case 'h':
             fprintf ( stderr, "\n%s  --  %s\n\n%s\n\n%s\n\n%s\n", \
                       PROGRAM, PURPOSE, USAGE, OPTIONS, AUTHOR );
             exit(0);

          case 'a':
             strcat ( fgmhrt, " -a " );
             if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                i++;
                strcat ( fgmhrt, argv[i] ); 
               }
             else
                strcat ( fgmhrt, argv[i]+2 );
             break;
            
          case 'e': 
             strcat ( fgmtel, " -e " );
             if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                i++;
                strcat ( fgmtel, argv[i] ); 
               }
             else
                strcat ( fgmtel, argv[i]+2 );
             break;

          case 't':
             strcat ( fgmav, " -t " );
             tlf = 1;
             if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                i++;
                strcat ( fgmav, argv[i] ); 
               }
             else
                strcat ( fgmav, argv[i]+2 );
             break;
 
          case 'l':
            if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                if (*argv[i+1] != '-' ){
                  i++;
                  strcat ( logf, argv[i] );
                  } 
                }
             else 
                strcat ( logf, argv[i]+2 );
            if ( strlen (logf) < 2)
                strcat ( logf, "logfile" );  
            strcat ( cmd, " rm ");
            strcat ( cmd, logf );
            strcat ( cmd, ";" ); 
            strcat ( ddsmrg, " 2>> " );
            strcat ( fgmtel, " 2>> " );
            strcat ( fgmcal, " 2>> " );
            strcat ( fgmhrt, " 2>> " );
            strcat ( fgmav, " 2>> " );
            strcat ( fgmiff, " 2>> " );
            strcat ( ddsmrg, logf );
            strcat ( fgmtel, logf );
            strcat ( fgmcal, logf );
            strcat ( fgmhrt, logf );
            strcat ( fgmav, logf );
            strcat ( fgmiff, logf );
            break;
 
          case 'o':
             strcat ( fgmiff, " -o " );
             if ( *(argv[i]+2) == '\0') 
               {
                if ( i+1 < argc && *argv[i+1] != '-' )
                  {
                   i++;
                   strcat ( fgmiff, argv[i] ); 
                  }
               }
             else
                strcat ( fgmiff, argv[i]+2 );
             break;

          case 'V': 
             fprintf ( stdout, "%s %s\n", PROGRAM, VERSION );
             exit(0);

          default:
             fprintf ( stderr, errmsg[1], argv[0], argv[i] );
             fprintf ( stderr, errmsg[0], argv[0] );
             exit(1);
         }
      }
    else
      {
       infile = fopen ( argv[i], "r" );
       if ( infile == NULL )
         {
          fprintf ( stderr, errmsg[2], argv[0], argv[i] );
          exit(2);
         }
       else 
         {
          fclose ( infile );
          strcat ( ddsmrg, " " );
          strcat ( ddsmrg, argv[i] );
          num++;
         }
      }
    i++;
   }

 if ( tlf == 0 )
   {
    if (ppdb)
      {
/*     spin averages with default phase offset */
       strcat ( fgmav, " -p 26.3671875" );
      }
    else
      {
/*     one minute averages */
       strcat ( fgmav, " -m" );
      }
   }

        
/* concatenate the command string */

 if (num)
   {
    strcat ( cmd, ddsmrg );
    strcat ( cmd, " | " );
   }
 strcat ( cmd, fgmtel );
 strcat ( cmd, " | " );
 strcat ( cmd, fgmcal );
 strcat ( cmd, " | " );
 strcat ( cmd, fgmhrt );
 strcat ( cmd, " | " );
 strcat ( cmd, fgmav );
 strcat ( cmd, " | " );
 strcat ( cmd, fgmiff );
 printf( "%s\n",cmd );

/* execute, remove the temporary file, and quit */

 i = system ( cmd );
 remove ( tmpname );
 exit(i);
}
