/*
 * Copyright (C) 1995/96 IGM TU Braunschweig, 2000 MPE Garching
 * last version: 5.0 (1996-12-18)
 * timespec_t -> timesp !! for Alpha-DEC
 * libutil.h
 * reads header as array of bytes and uses new function read_ddsheadc
 * write_ddshead out, to assure portability Alpha-DEC, SUN, etc.  
 * last change: 17/5/00
 */

#define PROJECT "CLUSTER FGM DATA PROCESSING"
#define PROGRAM "ddsmrg"  
#define VERSION "6.0 (2000-04-15)"
#define PURPOSE "merge telemetry raw data files"
#define USAGE "USAGE:

  ddsmrg <file>... | ...

  The program reads telemetry raw data files, sorts the data packets in
  ascending order of DDS header time stamps, and writes them to stdout.
 
  Telemetry packets which are read twice, i.e. packets with the same
  time stamp and with the same data source type, are only written once."

#define OPTIONS "OPTIONS:

  -V        print the version number on stdout, then exit."

#define AUTHOR "AUTHORS:
 
 Edita Georgescu  (eg@mpe.mpg.de)
 Stephan Buchert  (scb@stelab.nagoya-u.ac.jp)
 Reinhold Kempen  (reinhold@tu-bs.de)
 Joerg Warnecke   (joerg@igpp.ucla.edu)"

static char *errmsg[] =                           /* error messages */
  {
/*  0 */  "Use `%s -h' for help.\n",
/*  1 */  "ERROR in %s: Illegal option %s.\n",
/*  2 */  "ERROR in %s: Number of files exceeds maximum (%d).\n",
/*  3 */  "ERROR in %s: Cannot open file %s.\n",
/*  4 */  "ERROR in %s: No input files specified.\n",
/*  5 */  "ERROR in %s: Could not read DDS header of file %s.\n",
/*  6 */  "ERROR in %s: Could not allocate memory for telemetry data.\n",
/*  7 */  "ERROR in %s while reading telemetry data from file %s.\n",
/*  8 */  "ERROR in %s while writing %s to stdout.\n",
   };

#include "libutil.h"

#define MAX_INFILES 16

int main ( int argc, char *argv[] )
  {
   FILE            *infile[MAX_INFILES];
   static timesp   ts[MAX_INFILES], lasttime = {0, 0};
   ddshead_t       telhead[MAX_INFILES];
   int             index[MAX_INFILES],ii, i=1, num=0, length=0, j=0, lastsource=-1;
   char            copt, *teldata=NULL;
   headbytes       inbytes, indata[MAX_INFILES];
   
   while ( i < argc )
     {
      if (*argv[i] == '-')
        {
         copt = *(argv[i]+1);
         switch(copt)
           {
            case 'h':
#ifndef SECURE
               fprintf ( stdout, "\n%s  --  %s\n\n%s\n\n%s\n\n%s\n",
                         PROGRAM, PURPOSE, USAGE, OPTIONS, AUTHOR );
#else
               fprintf ( stdout, "%s\n\n %s %s\n\n%s\n",
                         PROJECT, PROGRAM, VERSION, AUTHOR );
#endif
               exit(0);

            case 'V':
               fprintf ( stdout, "%s %s\n", PROGRAM, VERSION );
               exit(0);
          
            default: 
               fprintf ( stderr, errmsg[1], PROGRAM, argv[i] );
               fprintf ( stderr, errmsg[0], argv[0] );
               exit(1);
           }
        }
      else
        {
         if (num > MAX_INFILES)
           {
            fprintf ( stderr, errmsg[2], PROGRAM, MAX_INFILES );
            exit(2);
           }
         index[num] = i;
         infile[num] = fopen ( argv[i], "r" );
         if (infile[num] == NULL)
           {
            fprintf ( stderr, errmsg[3], PROGRAM, argv[i] );
            exit(3);
           }
         num++;
        }
      i++;
     }

   if (num == 0)
     {
      fprintf ( stderr, errmsg[4], PROGRAM );
      fprintf ( stderr, errmsg[0], argv[0] );
      exit(4);
     }

/* read headers, get time stamps of all files */
   for ( i = 0; i < num; i++ )
     { 
     if ( fread ( inbytes, 1, header_length, infile[i] ) != header_length )
        {
         fprintf ( stderr, errmsg[5], PROGRAM, argv[index[i]] );
         exit(5);
        }
     for (ii = 0;ii < header_length;ii++)
         indata[i][ii]=inbytes[ii];
     read_ddsheadc( inbytes, &telhead[i]);
     ts[i] = cds2unix ( telhead[i].t );
     }

   j = 0;

   while ( num > 0 )
     {
/* determine index of file with earliest time stamp */
      for ( i = 0; i < num; i++ )
        {
         if ((i != j) && (cmptime(&ts[i],&ts[j]) < 0))
           {
            j = i;
           }
        }
/* determine packet length */
      i = pktlen ( &telhead[j] );
      if ( i != length )
        {
/* allocate new memory for teldata */
         length = i;
         if (teldata) 
            free (teldata);
         if ((teldata = malloc(length)) == NULL)
           {
            fprintf ( stderr, errmsg[6], PROGRAM );
            exit(6);
           }
        }
/* read data packet */
      if ( fread ( teldata, 1, length, infile[j] ) != length )
        {
         fprintf ( stderr, errmsg[7], PROGRAM, argv[index[j]] );
         exit(7);
        }
      if ( cmptime(&ts[j], &lasttime) > 0 || telhead[j].source != lastsource )
        {
/* write header */
         if (  fwrite ( indata[j], 1, header_length, stdout ) != header_length )
           {
            fprintf ( stderr, errmsg[8], PROGRAM, "DDS header" );
            exit(8);
           }
/* write data packet */
         if ( fwrite ( teldata, 1, length, stdout ) != length )
           {
            fprintf ( stderr, errmsg[8], PROGRAM, "data packet" );
            exit(8);
           }
/* store the last time and the last data source */
         lasttime = ts[j];
         lastsource = telhead[j].source;
        }
      
/* read next header, close on EOF */
      if ( fread ( inbytes, 1, header_length, infile[j] ) != header_length )
        {
         fclose ( infile[j] );
/* shift elements of arrays */
         for ( i = j+1; i < num; i++ )
           {
            ts[i-1] = ts[i];
	   index[i-1] = index[i];
            infile[i-1] = infile[i];
            telhead[i-1] = telhead[i];
            for (ii = 0;ii < header_length;ii++)
                indata[i-1][ii]=indata[i][ii];
           }
         num--;
         j = 0;
        }
      else
        {
        for (ii = 0;ii < header_length;ii++)
            indata[j][ii]=inbytes[ii];
         read_ddsheadc( inbytes, &telhead[j]);
         ts[j] = cds2unix ( telhead[j].t );
        } 
      }

   exit(0);
  }
