/*
 * Copyright (C) 1994/95/96 IGM TU Braunschweig, 2000 MPE Garching
 * - modified V5.0 (1996-12-18)
 * - option l added: re-direction of stderr to a logfile
 * - spot values changed to 1 second averages
 * - option i added: calibration filename info is appended to the output;
 *   default: calibration filename in separate file 'cal.log'.
 * - modified VERSION "6.0 (2000-04-15) help, to take into account the
 *   modified fgmhrt which accepts <attf> with DDS-headers
 * - '-e' option for explicitly given STEF file
 * - default ouput names cf fgmvec, if '-o'
 * - modified VERSION "6.1 (2000-05-25)"
 *   cal_mode data not screened out anymore  
 */

#define PROJECT "CLUSTER FGM DATA PROCESSING"
#define PROGRAM "fgmpsds"
#define VERSION "6.2 (2001-01-29)"
#define PURPOSE "generate PSDS of CLUSTER FGM data"
#define CPRIGHT "Copyright (C) 1994/95/96,2000/1 IGM TU Braunschweig, MPE Garching"
#define USAGE "USAGE:

 fgmpsds [<infile>...] [-a <attf>] [-e <eclf>]
         [-s <sys>] [-l [<logf>]] [-i] [-o [<outf>]]

 fgmpsds generates a Processing Support Data Set, containing
         one second averages of the magnetic field

 The input file is a normal or burst mode science data file containing
 the raw FGM data, like those distributed on the raw data medium (RDM).
 More than one input file may be specified to concatenate data. If no
 input file is given, the data will be read from stdin."

#define OPTIONS "OPTIONS:

  -a   use <attf> as attitude file. <attf> may contain DDS-headers, i.e.
       the raw attitude file from CDROM (*ga*) may be used.
       Default is to use the merged attitude file `$SATTPATH/satt.cl#',
       where `#' is replaced by the satellite number.

  -e   read eclipse info from file <eclf>. <eclf> may contain DDS-headers, i.e.
       the raw attitude file from CDROM (*ta*) may be used.
       Default is '$SATTPATH/s{|l}tef.cl#', where #=1,2,3,4.

  -i   append calfilename-info to the end of the output;
       default is to have the used calibration file-name written in a 
       separate file 'cal.log'        
       A tailstring, containing output column names, is also appended.        

  -s   select the output coordinate system, where <sys> may be
       `sr'   for spin-reference system,
       `scs'  for spacecraft-sun system (this is the default),
       `gse'  for geocentric solar ecliptic system,
       `gsm'  for geocentric solar magnetospheric system, or
       `sm'   for solar magnetic system.
       `j2k'  for geocentric equatorial inertial system of epoch J2000.0.
         
  -l   re-direct info from stderr to a logfile <logf>; 
       if option '-l', but no filename given, default is: 'logfile' 
  
  -o   use <outf> as output file.If '-o', but no <outf> given,
       use default name : C#_yyyymmdd_sys.mag, where #=1,2,3,4 stands for
       satellite number and sys for the output coordinate system.
       Default is to write to stdout.

  -V   print version number on stdout, then exit."

#define AUTHOR "AUTHORS:
 
 Edita Georgescu (eg@mpe.mpg.de)
 Stephan Buchert (scb@stelab.nagoya-u.ac.jp)
 Reinhold Kempen (reinhold@geophys.nat.tu-bs.de)
 Joerg Warnecke  (joerg@igpp.ucla.edu)"


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


static char *errmsg[] =
   {
/* 0 */  "Type `%s -h' for help.\n",
/* 1 */  "ERROR in %s: Illegal option %s.\n",
/* 2 */  "ERROR in %s: Could not open input file %s.\n",
/* 3 */  "ERROR in %s: Could not evaluate command name (length = %d).\n",
   };

int main ( int argc, char *argv[], char *envp[] )
{
 FILE    *infile=NULL;
 char    ddsmrg[384]="", fgmtel[128]="", fgmcal[128]="", 
         fgmhrt[128]="", fgmav[128]="", fgmvec[128]="",
         cmd[1024]="", logf[128]="", copt;
 int     i, coorsys=0, num=0;

/* initialize command strings & logfile-name */
fprintf (stdout,"%s\n",CPRIGHT);
 i = strlen ( argv[0] );
 if ( i < 7 )
   {
    fprintf ( stderr, errmsg[3], PROGRAM, i );
    exit(3);
   }
 else if ( i > 7 )
   {
    strncat ( ddsmrg, argv[0], i-7 );
    strncat ( fgmtel, argv[0], i-7 );
    strncat ( fgmcal, argv[0], i-7 );
    strncat ( fgmhrt, argv[0], i-7 );
    strncat ( fgmav,  argv[0], i-7 );
    strncat ( fgmvec, argv[0], i-7 );
   }

 strcat ( ddsmrg, "ddsmrg" );
 strcat ( fgmtel, "fgmtel -a 2" );
 strcat ( fgmcal, "fgmcal -i cal.log" );
 strcat ( fgmhrt, "fgmhrt" );
 strcat ( fgmav,  "fgmav -s" );
 strcat ( fgmvec, "fgmvec -r -f " );

/* get command line parameters */

 i = 1;

 while ( i < argc )
   {
    if (*argv[i] == '-')
      {
       copt = *(argv[i]+1);
       switch(copt)
         {
          case 'h':
             fprintf ( stdout, "\n%s  --  %s\n\n%s\n\n%s\n\n%s\n", \
                       PROGRAM, PURPOSE, USAGE, OPTIONS, AUTHOR );
             exit(0);

          case 'a': 
             strcat ( fgmhrt, " -a " );
             if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                i++;
                strcat ( fgmhrt, argv[i] ); 
               }
             else
                strcat ( fgmhrt, argv[i]+2 );
             break;
             
          case 'e': 
             strcat ( fgmtel, " -e " );
             if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                i++;
                strcat ( fgmtel, argv[i] ); 
               }
             else
                strcat ( fgmtel, argv[i]+2 );
             break;

          case 'i': 
             strcat ( fgmvec, " -i cal.log" );
             break;
 
          case 's':
             coorsys = 1;
             strcat ( fgmhrt, " -s " );
             if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                i++;
                strcat ( fgmhrt, argv[i] ); 
               }
             else
                strcat ( fgmhrt, argv[i]+2 );
             break;

          case 'l':
            if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                if (*argv[i+1] != '-' ){
                  i++;
                  strcpy ( logf, argv[i] );
                  } 
                }
             else 
                strcpy ( logf, argv[i]+2 );
            if (strlen( logf ) < 2)
               strcat( logf, "logfile");      
            strcat ( cmd, " rm " );
            strcat ( cmd, logf );
            strcat ( cmd, ";" ); 
            strcat ( ddsmrg, " 2>> " );
            strcat ( fgmtel, " 2>> " );
            strcat ( fgmcal, " 2>> " );
            strcat ( fgmhrt, " 2>> " );
            strcat ( fgmav, " 2>> " );
            strcat ( fgmvec, " 2>> " );
            strcat ( ddsmrg, logf );
            strcat ( fgmtel, logf );
            strcat ( fgmcal, logf );
            strcat ( fgmhrt, logf );
            strcat ( fgmav, logf );
            strcat ( fgmvec, logf );
            break;
 
          case 'o':
             strcat ( fgmvec, " -o " );
             if ( *(argv[i]+2) == '\0' && i+1 < argc )
               {
                i++;
                strcat ( fgmvec, argv[i] ); 
               }
             else
                strcat ( fgmvec, argv[i]+2 );
             break;

          case 'V': 
             fprintf ( stdout, "%s %s\n", PROGRAM, VERSION );
             exit(0);

          default:
             fprintf ( stderr, errmsg[1], PROGRAM, argv[i] );
             fprintf ( stderr, errmsg[0], argv[0] );
             exit(1);
         }
      }
    else
      {
       infile = fopen ( argv[i], "r" );
       if ( infile == NULL )
         {
          fprintf ( stderr, errmsg[2], PROGRAM );
          exit(2);
         }
       else 
         {
          fclose ( infile );
          strcat ( ddsmrg, " " );
          strcat ( ddsmrg, argv[i] );
          num++;
         }
      }
    i++;
   }
   
/* set 'scs' as the default coordinate system */

 if (!coorsys)
    strcat ( fgmhrt, " -s scs" );

/* concatenate the command string */

 if (num)
   {
    strcat ( cmd, ddsmrg );
    strcat ( cmd, " | " );
   }
 strcat ( cmd, fgmtel );
 strcat ( cmd, " | " );
 strcat ( cmd, fgmcal );
 strcat ( cmd, " | " );
 strcat ( cmd, fgmhrt );
 strcat ( cmd, " | " );
 strcat ( cmd, fgmav );
 strcat ( cmd, " | " );
 strcat ( cmd, fgmvec );
 printf( "%s\n",cmd );

/* execute and quit */
 i = system ( cmd );
 exit(i);
}

