C
C  MRGATT - merge CLUSTER attitude files
C
C  Subroutines:
C    ILEN, SATT_READ, SATT_WRITE, SATT_NEWER
C    from the CLUSTER Fortran library:  MJD_STR
C    from the SunOS Fortran library:    GETARG, IARGC
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++C
C
      PROGRAM MRGATT
C
      IMPLICIT NONE
C
      CHARACTER*16      VERSION
      PARAMETER        (VERSION='5.0 (1996-12-18)')
C
      INTEGER           IN, OUT, ERR, UF
      PARAMETER        (IN=5, OUT=6, ERR=0, UF=4)
C
      INTEGER           ILEN, IARGC, NARG, I, K, IERR4, IERR5, IERR6
      LOGICAL           SATT_NEWER, EXIST
      DOUBLE PRECISION  MJD4B, MJD4E, MJD5B, MJD5E, MJD6E
      CHARACTER*16      CMD
      CHARACTER*128     PRG, FILE
      CHARACTER*129     STRING4, STRING5, STRING6
C
C  get program name and command name (= base of program name)
C
      CALL GETARG ( 0, PRG )
      I = ILEN(PRG)
      K = I
      DO WHILE ((K.GT.0).AND.(PRG(K:K).NE.'/'))
        K = K - 1
      END DO
      IF ((K.LT.I).AND.((I-K).LT.LEN(CMD))) THEN
        CMD = PRG(K+1:I)
      ELSE
        CMD = 'mrgatt'
      END IF
C
C  get command line parameters
C
      NARG = IARGC()
      IF (NARG.EQ.1) THEN
        CALL GETARG ( 1, FILE )
        IF (FILE(1:2).EQ.'-h') THEN
          WRITE (OUT,2000) PRG(1:ILEN(PRG))
          WRITE (OUT,2001) CMD(1:ILEN(CMD))
          WRITE (OUT,2002)
          WRITE (OUT,2003)
          STOP
        ELSE IF (FILE(1:2).EQ.'-V') THEN
          WRITE (OUT,3000) CMD(1:ILEN(CMD)), VERSION
          STOP
        END IF
      ELSE
        WRITE (ERR,1001) CMD(1:ILEN(CMD)), PRG(1:ILEN(PRG))
        STOP
      END IF
C
C  open SATT file, read first record
C
      INQUIRE ( FILE=FILE, EXIST=EXIST, IOSTAT=IERR4, ERR=904 )
      IF (EXIST) THEN
        OPEN ( UF, FILE=FILE, STATUS='OLD', ERR=904, IOSTAT=IERR4,
     &         ACCESS='SEQUENTIAL', FORM='FORMATTED' )
      ELSE
        WRITE (ERR,1002) CMD(1:ILEN(CMD)), FILE(1:ILEN(FILE))
        STOP
      END IF
      CALL SATT_READ ( UF, IERR4, STRING4, MJD4B, MJD4E )
      IF (IERR4.GT.0) GO TO 904
C
C  read first record from stdin
C
      CALL SATT_READ ( IN, IERR5, STRING5, MJD5B, MJD5E )
      IF (IERR5.GT.0) GO TO 905
C
C  initialize end time of last output record
C
      IF ((IERR4.EQ.0).AND.(IERR5.EQ.0)) THEN
        MJD6E = MIN(MJD4B,MJD5B)
      ELSE IF (IERR4.EQ.0) THEN
        MJD6E = MJD4B
      ELSE IF (IERR5.EQ.0) THEN
        MJD6E = MJD5B
      ELSE
        WRITE (ERR,1007) CMD(1:ILEN(CMD))
        STOP
      END IF
C
C  do until EOF on both stdin and file:
C
      DO WHILE ((IERR4.EQ.0).OR.(IERR5.EQ.0))
C
C       skip forward until time of last output is reached
        IF (IERR4.EQ.0) THEN
          IF (MJD4E.LT.MJD6E) GO TO 4
          IF (MJD6E.GT.MJD4B) THEN
            MJD4B = MJD6E
            CALL MJD_STR ( MJD4B, STRING4(6:25), 1 )
          END IF
        END IF
        IF (IERR5.EQ.0) THEN
          IF (MJD5E.LT.MJD6E) GO TO 5
          IF (MJD6E.GT.MJD5B) THEN
            MJD5B = MJD6E
            CALL MJD_STR ( MJD5B, STRING5(6:25), 1 )
          END IF
        END IF
C
        IF ((IERR4.EQ.0).AND.(IERR5.EQ.0)) THEN
C
          IF (STRING4(1:2).NE.STRING5(1:2)) THEN
            WRITE (ERR,1003) CMD(1:ILEN(CMD)),
     &                       STRING4(1:2), STRING5(1:2)
            STOP
          END IF
C
          IF (MJD4E.LT.MJD5B) THEN
C---------- MJD4B < MJD4E < MJD5B ------------------------------------C
C           use file record
            CALL SATT_WRITE ( OUT, STRING4, IERR6, MJD6E )
            IF (IERR6.NE.0) GO TO 906
            GO TO 4
          ELSE IF (MJD5E.LT.MJD4B) THEN
C---------- MJD5B < MJD5E < MJD4B ------------------------------------C
C           use stdin record
            CALL SATT_WRITE ( OUT, STRING5, IERR6, MJD6E )
            IF (IERR6.NE.0) GO TO 906
            GO TO 5
          ELSE IF (MJD4B.LT.MJD5B) THEN
            IF (MJD4E.LT.MJD5E) THEN
C------------ MJD4B < MJD5B, MJD4E < MJD5E----------------------------C
C             use file record
              STRING6 = STRING4
              IF (SATT_NEWER(STRING5,STRING4)) THEN
C               only until beginning of stdin record
                STRING6(27:46) = STRING5(6:25)
              END IF
              CALL SATT_WRITE ( OUT, STRING6, IERR6, MJD6E )
              IF (IERR6.NE.0) GO TO 906
              GO TO 4
            ELSE
C------------ MJD4B < MJD5B < MJD5E <= MJD4E -------------------------C
              IF (SATT_NEWER(STRING5,STRING4)) THEN
C               use file record until beginning of stdin record
                STRING6 = STRING4
                STRING6(27:46) = STRING5(6:25)
                CALL SATT_WRITE ( OUT, STRING6, IERR6, MJD6E )
                IF (IERR6.NE.0) GO TO 906
C               then use stdin record
                CALL SATT_WRITE ( OUT, STRING5, IERR6, MJD6E )
                IF (IERR6.NE.0) GO TO 906
              END IF
              GO TO 5
            END IF
          ELSE
            IF (MJD5E.LT.MJD4E) THEN
C------------ MJD5B <= MJD4B, MJD5E < MJD4E---------------------------C
C             use stdin record
              STRING6 = STRING5
              IF (.NOT.(SATT_NEWER(STRING5,STRING4))) THEN
                IF (.NOT.(MJD5B.LT.MJD4B)) GO TO 5
C               only until beginning of file record
                STRING6(27:46) = STRING4(6:25)
              END IF
              CALL SATT_WRITE ( OUT, STRING6, IERR6, MJD6E )
              IF (IERR6.NE.0) GO TO 906
              GO TO 5
            ELSE
C------------ MJD5B <= MJD4B < MJD4E <= MJD5E ------------------------C
              IF (.NOT.SATT_NEWER(STRING5,STRING4)) THEN
                IF (.NOT.(MJD5B.LT.MJD4B)) GO TO 5
C               use stdin record until beginning of file record
                STRING6 = STRING5
                STRING6(27:46) = STRING4(6:25)
                CALL SATT_WRITE ( OUT, STRING6, IERR6, MJD6E )
                IF (IERR6.NE.0) GO TO 906
C               then use file record
                CALL SATT_WRITE ( OUT, STRING4, IERR6, MJD6E )
                IF (IERR6.NE.0) GO TO 906
              END IF
              GO TO 4
            END IF
          END IF
C
        ELSE IF (IERR4.EQ.0) THEN
C
C         use file record
          CALL SATT_WRITE ( OUT, STRING4, IERR6, MJD6E )
          IF (IERR6.NE.0) GO TO 906
          GO TO 4
C
        ELSE

C         use stdin record
          CALL SATT_WRITE ( OUT, STRING5, IERR6, MJD6E )
          IF (IERR6.NE.0) GO TO 906
          GO TO 5
C
        END IF
C
        GO TO 9
C
 4      CONTINUE
        CALL SATT_READ ( UF, IERR4, STRING4, MJD4B, MJD4E )
        IF (IERR4.GT.0) GO TO 904
        GO TO 9
 5      CONTINUE
        CALL SATT_READ ( IN, IERR5, STRING5, MJD5B, MJD5E )
        IF (IERR5.GT.0) GO TO 905
        GO TO 9
 9      CONTINUE
C
      END DO
C
      STOP
C
 904  CONTINUE
      WRITE (ERR,1004) CMD(1:ILEN(CMD)), IERR4
      STOP
 905  CONTINUE
      WRITE (ERR,1005) CMD(1:ILEN(CMD)), IERR5
      STOP
 906  CONTINUE
      WRITE (ERR,1006) CMD(1:ILEN(CMD)), IERR6
      STOP
C
 1001 FORMAT ('ERROR in ', A, ': Illegal usage.', /,
     &        'Type "', A, ' -h" for help.')
 1002 FORMAT ('ERROR in ', A, ': File ', A, ' not found.')
 1003 FORMAT ('ERROR in ', A, ': Cannot merge SATT files from ',
     &        'different spacecrafts.', /,
     &        'Spacecraft id on file: ', A2, ', on stdin: ', A2 )
 1004 FORMAT ('ERROR in ', A, ' while reading from SATT file; ',
     &        'FORTRAN IOSTAT = ', I5 )
 1005 FORMAT ('ERROR in ', A, ' while reading from stdin; ',
     &        'FORTRAN IOSTAT = ', I5 )
 1006 FORMAT ('ERROR in ', A, ' while writing to stdout; ',
     &        'FORTRAN IOSTAT = ', I5 )
 1007 FORMAT ('ERROR in ', A, ': SATT files are empty.' )
C
 2000 FORMAT ( /, A, '  --  merge CLUSTER SATT files', / )
 2001 FORMAT ( 'USAGE:', //,
     & '... | ', A, ' <sattfile> | ...', //, 
     & 'The program reads CLUSTER SATT file records from stdin, ',
     & 'merges them with', /,
     & 'the specified SATT file, and writes the merged file to ',
     & 'stdout.  The DDS', /,
     & 'packet headers must have been removed.', //, 
     & 'Rules for merging competitive entries:', /,
     & '1) take reconstituted entry instead of predicted entry,', /,
     & '2) take entry with latest time of generation,', /,
     & '3) take entry from file instead of entry from stdin.', / )
 2002 FORMAT ( 'OPTIONS:', //,
     & ' -h   print this help on stdout, then exit.', //
     & ' -V   print version number on stdout, then exit.', / )
 2003 FORMAT ( 'AUTHOR:', //,
     & 'Joerg Warnecke      (joerg@igpp.ucla.edu)', / )
C
 3000 FORMAT ( A, 1X, A )
      END
C*********************************************************************C
C
      INTEGER FUNCTION ILEN ( C )
C
C  returns the actual length of a character string
C
      CHARACTER          C*(*)
C
      ILEN = LEN(C)
      DO WHILE ((ILEN.GT.0).AND.(ICHAR(C(ILEN:ILEN)).LE.32))
        ILEN = ILEN - 1
      END DO
C
      RETURN
      END
C*******************************************************************C
C
      SUBROUTINE SATT_READ ( UNIT, IERR, STRING, MJDB, MJDE )
C
C  reads a SATT file record from the specified unit,
C  returns ierr > 0 on error, or ierr < 0 on EOF,
C  else (ierr = 0) it returns the record that has been read,
C  and its time of validation (MJDB to MJDE)
C
      IMPLICIT NONE
C
      INTEGER           ERR
      PARAMETER        (ERR=0)
C
      INTEGER           UNIT, IERR
      CHARACTER*(*)     STRING
      DOUBLE PRECISION  MJDB, MJDE
C
      READ (UNIT,1000,IOSTAT=IERR) STRING
      IF (IERR.EQ.0) THEN
        CALL MJD_STR ( MJDB, STRING( 6:25), 0 )
        CALL MJD_STR ( MJDE, STRING(27:46), 0 )
        IF (STRING(1:1).EQ.' ') STRING(1:1) = '0'
      END IF
      RETURN
C
 1000 FORMAT ( A129 )
      END
C*******************************************************************C
C
      LOGICAL FUNCTION SATT_NEWER ( STRING1, STRING2 )
C
C  determines whether the SATT file record STRING1 is newer or has
C  higher priority than STRING2
C
      CHARACTER*(*)     STRING1, STRING2
      DOUBLE PRECISION  MJDC1, MJDC2
C
      SATT_NEWER = .FALSE.
      IF ((STRING1(4:4).EQ.'R').AND.(STRING2(4:4).EQ.'P')) THEN
        SATT_NEWER = .TRUE.
      ELSE
        CALL MJD_STR ( MJDC1, STRING1(110:129), 0 )
        CALL MJD_STR ( MJDC2, STRING2(110:129), 0 )
        SATT_NEWER = (MJDC1.GT.MJDC2)
      END IF
C
      RETURN
      END
C*******************************************************************C
C
      SUBROUTINE SATT_WRITE ( UNIT, STRING, IERR, MJD )
C
C  writes a SATT file record to the specified unit,
C  returns ierr > 0 on error,
C  or ierr = 0 and the validation end time of the written record.
C
      INTEGER           UNIT, IERR
      CHARACTER*(*)     STRING
      DOUBLE PRECISION  MJD
C
      WRITE (UNIT,1000,IOSTAT=IERR) STRING
      IF (IERR.EQ.0) CALL MJD_STR ( MJD, STRING(27:46), 0 )
C
      RETURN
C
 1000 FORMAT ( A129 )
      END
C*******************************************************************C
