C
C  MRGORB - merge CLUSTER orbit files
C
C  Subroutines:
C    ILEN, ORB_READ, ORB_WRITE, ORB_NEWER
C    from the CLUSTER Fortran library:  MJD_STR
C    from the SunOS Fortran library:    GETARG, IARGC
C
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++C
C
      PROGRAM MRGORB
C
      IMPLICIT NONE
C
      CHARACTER*16      VERSION
      PARAMETER        (VERSION='5.0 (1996-12-18)')
C
      INTEGER           IN, OUT, ERR, UF, M
      PARAMETER        (IN=5, OUT=6, ERR=0, UF=4, M=16)
C
      INTEGER           ILEN, IARGC, NARG, I, K, IERR4, IERR5, IERR6,
     &                  NUM4, NUM5
      LOGICAL           ORB_NEWER, EXIST
      DOUBLE PRECISION  MJD4B, MJD4E, MJD5B, MJD5E, MJD6E
      CHARACTER*16      CMD
      CHARACTER*80      STRING4(M), STRING5(M), STRING6(M)
      CHARACTER*128     PRG, FILE
C
C  get program name and command name (= base of program name)
C
      CALL GETARG ( 0, PRG )
      I = ILEN(PRG)
      K = I
      DO WHILE ((K.GT.0).AND.(PRG(K:K).NE.'/'))
        K = K - 1
      END DO
      IF ((K.LT.I).AND.((I-K).LT.LEN(CMD))) THEN
        CMD = PRG(K+1:I)
      ELSE
        CMD = 'mrgorb'
      END IF
C
C  get command line parameters
C
      NARG = IARGC()
      IF (NARG.EQ.1) THEN
        CALL GETARG ( 1, FILE )
        IF (FILE(1:2).EQ.'-h') THEN
          WRITE (OUT,2000) PRG(1:ILEN(PRG))
          WRITE (OUT,2001) CMD(1:ILEN(CMD))
          WRITE (OUT,2002)
          WRITE (OUT,2003)
          STOP
        ELSE IF (FILE(1:2).EQ.'-V') THEN
          WRITE (OUT,3000) CMD(1:ILEN(CMD)), VERSION
          STOP
        END IF
      ELSE
        WRITE (ERR,1001) CMD(1:ILEN(CMD)), PRG(1:ILEN(PRG))
        STOP
      END IF
C
C  open orbit file, read first entry
C
      INQUIRE ( FILE=FILE, EXIST=EXIST, IOSTAT=IERR4, ERR=904 )
      IF (EXIST) THEN
        OPEN ( UF, FILE=FILE, STATUS='OLD', ERR=904, IOSTAT=IERR4,
     &         ACCESS='SEQUENTIAL', FORM='FORMATTED' )
      ELSE
        WRITE (ERR,1002) CMD(1:ILEN(CMD)), FILE(1:ILEN(FILE))
        STOP
      END IF
      CALL ORB_READ ( UF, IERR4, STRING4, NUM4, MJD4B, MJD4E )
      IF (IERR4.GT.0) GO TO 904
C
C  read first entry from stdin
C
      CALL ORB_READ ( IN, IERR5, STRING5, NUM5, MJD5B, MJD5E )
      IF (IERR5.GT.0) GO TO 905
C
C  initialize end time of last output record
C
      IF ((IERR4.EQ.0).AND.(IERR5.EQ.0)) THEN
        MJD6E = MIN(MJD4B,MJD5B)
      ELSE IF (IERR4.EQ.0) THEN
        MJD6E = MJD4B
      ELSE IF (IERR5.EQ.0) THEN
        MJD6E = MJD5B
      ELSE
        WRITE (ERR,1007) CMD(1:ILEN(CMD))
        STOP
      END IF
C
C  do until EOF on both stdin and file:
C
      DO WHILE ((IERR4.EQ.0).OR.(IERR5.EQ.0))
C
C       skip forward until time of last output is reached
        IF (IERR4.EQ.0) THEN
          IF (MJD4E.LT.MJD6E) GO TO 4
          IF (MJD6E.GT.MJD4B) THEN
            MJD4B = MJD6E
            CALL MJD_STR ( MJD4B, STRING4(1)(31:50), 1 )
            WRITE (STRING4(2)(04:15),4000) MJD4B
          END IF
        END IF
        IF (IERR5.EQ.0) THEN
          IF (MJD5E.LT.MJD6E) GO TO 5
          IF (MJD6E.GT.MJD5B) THEN
            MJD5B = MJD6E
            CALL MJD_STR ( MJD5B, STRING5(1)(31:50), 1 )
            WRITE (STRING5(2)(04:15),4000) MJD5B
          END IF
        END IF
C
        IF ((IERR4.EQ.0).AND.(IERR5.EQ.0)) THEN
C
          IF (STRING4(1)(1:3).NE.STRING5(1)(1:3)) THEN
            WRITE (ERR,1003) CMD(1:ILEN(CMD)),
     &                       STRING4(1)(1:3), STRING5(1)(1:3)
            STOP
          END IF
C
          IF (MJD4E.LT.MJD5B) THEN
C---------- MJD4B < MJD4E < MJD5B ------------------------------------C
C           use file entry
            CALL ORB_WRITE ( OUT, STRING4, NUM4, IERR6, MJD6E )
            IF (IERR6.NE.0) GO TO 906
            GO TO 4
          ELSE IF (MJD5E.LT.MJD4B) THEN
C---------- MJD5B < MJD5E < MJD4B ------------------------------------C
C           use stdin entry
            CALL ORB_WRITE ( OUT, STRING5, NUM5, IERR6, MJD6E )
            IF (IERR6.NE.0) GO TO 906
            GO TO 5
          ELSE IF (MJD4B.LT.MJD5B) THEN
            IF (MJD4E.LT.MJD5E) THEN
C------------ MJD4B < MJD5B, MJD4E < MJD5E----------------------------C
C             use file entry
              DO I = 1, NUM4
                STRING6(I) = STRING4(I)
              END DO
              IF (ORB_NEWER(STRING5,STRING4)) THEN
C               only until beginning of stdin record
                CALL MJD_STR ( MJD5B, STRING6(1)(53:72), 1 )
                WRITE (STRING6(2)(16:27),4000) MJD5B
              END IF
              CALL ORB_WRITE ( OUT, STRING6, NUM4, IERR6, MJD6E )
              IF (IERR6.NE.0) GO TO 906
              GO TO 4
            ELSE
C------------ MJD4B < MJD5B < MJD5E <= MJD4E -------------------------C
              IF (ORB_NEWER(STRING5,STRING4)) THEN
C               use file record until beginning of stdin record
                DO I = 1, NUM4
                  STRING6(I) = STRING4(I)
                END DO
                CALL MJD_STR ( MJD5B, STRING6(1)(53:72), 1 )
                WRITE (STRING6(2)(16:27),4000) MJD5B
                CALL ORB_WRITE ( OUT, STRING6, NUM4, IERR6, MJD6E )
                IF (IERR6.NE.0) GO TO 906
C               then use stdin record
                CALL ORB_WRITE ( OUT, STRING5, NUM5, IERR6, MJD6E )
                IF (IERR6.NE.0) GO TO 906
              END IF
              GO TO 5
            END IF
          ELSE
            IF (MJD5E.LT.MJD4E) THEN
C------------ MJD5B <= MJD4B, MJD5E < MJD4E---------------------------C
C             use stdin record
              DO I = 1, NUM5
                STRING6(I) = STRING5(I)
              END DO
              IF (.NOT.(ORB_NEWER(STRING5,STRING4))) THEN
                IF (.NOT.(MJD5B.LT.MJD4B)) GO TO 5
C               only until beginning of file record
                CALL MJD_STR ( MJD4B, STRING6(1)(53:72), 1 )
                WRITE (STRING6(2)(16:27),4000) MJD4B
              END IF
              CALL ORB_WRITE ( OUT, STRING6, NUM5, IERR6, MJD6E )
              IF (IERR6.NE.0) GO TO 906
              GO TO 5
            ELSE
C------------ MJD5B <= MJD4B < MJD4E <= MJD5E ------------------------C
              IF (.NOT.ORB_NEWER(STRING5,STRING4)) THEN
                IF (.NOT.(MJD5B.LT.MJD4B)) GO TO 5
C               use stdin record until beginning of file record
                DO I = 1, NUM5
                  STRING6(I) = STRING5(I)
                END DO
                CALL MJD_STR ( MJD4B, STRING6(1)(53:72), 1 )
                WRITE (STRING6(2)(16:27),4000) MJD4B
                CALL ORB_WRITE ( OUT, STRING6, NUM5, IERR6, MJD6E )
                IF (IERR6.NE.0) GO TO 906
C               then use file record
                CALL ORB_WRITE ( OUT, STRING4, NUM4, IERR6, MJD6E )
                IF (IERR6.NE.0) GO TO 906
              END IF
              GO TO 4
            END IF
          END IF
C
        ELSE IF (IERR4.EQ.0) THEN
C
C         use file record
          CALL ORB_WRITE ( OUT, STRING4, NUM4, IERR6, MJD6E )
          IF (IERR6.NE.0) GO TO 906
          GO TO 4
C
        ELSE

C         use stdin record
          CALL ORB_WRITE ( OUT, STRING5, NUM5, IERR6, MJD6E )
          IF (IERR6.NE.0) GO TO 906
          GO TO 5
C
        END IF
C
        GO TO 9
C
 4      CONTINUE
        CALL ORB_READ ( UF, IERR4, STRING4, NUM4, MJD4B, MJD4E )
        IF (IERR4.GT.0) GO TO 904
        GO TO 9
 5      CONTINUE
        CALL ORB_READ ( IN, IERR5, STRING5, NUM5, MJD5B, MJD5E )
        IF (IERR5.GT.0) GO TO 905
        GO TO 9
 9      CONTINUE
C
      END DO
C
      STOP
C
 904  CONTINUE
      WRITE (ERR,1004) CMD(1:ILEN(CMD)), IERR4
      STOP
 905  CONTINUE
      WRITE (ERR,1005) CMD(1:ILEN(CMD)), IERR5
      STOP
 906  CONTINUE
      WRITE (ERR,1006) CMD(1:ILEN(CMD)), IERR6
      STOP
C
 1001 FORMAT ('ERROR in ', A, ': Illegal usage.', /,
     &        'Type "', A, ' -h" for help.')
 1002 FORMAT ('ERROR in ', A, ': File ', A, ' not found.')
 1003 FORMAT ('ERROR in ', A, ': Cannot merge orbit files from ',
     &        'different spacecrafts.', /,
     &        'Spacecraft id on file: ', A3, ', on stdin: ', A3 )
 1004 FORMAT ('ERROR in ', A, ' while reading from orbit file; ',
     &        'FORTRAN IOSTAT = ', I5 )
 1005 FORMAT ('ERROR in ', A, ' while reading from stdin; ',
     &        'FORTRAN IOSTAT = ', I5 )
 1006 FORMAT ('ERROR in ', A, ' while writing to stdout; ',
     &        'FORTRAN IOSTAT = ', I5 )
 1007 FORMAT ('ERROR in ', A, ': Orbit files are empty.' )
C
 2000 FORMAT ( /, A, '  --  merge CLUSTER orbit files', / )
 2001 FORMAT ( 'USAGE:', //,
     & '... | ', A, ' <orbfile> | ...', //, 
     & 'The program reads CLUSTER orbit file records from stdin, ',
     & 'merges them with', /,
     & 'the specified orbit file, and writes the merged file to ',
     & 'stdout.  The DDS', /,
     & 'packet headers must have been removed.', //, 
     & 'Rules for merging competitive entries:', /,
     & '1) take reconstituted entry instead of predicted entry,', /,
     & '2) take entry with latest time of generation,', /,
     & '3) take entry from file instead of entry from stdin.', / )
 2002 FORMAT ( 'OPTIONS:', //,
     & ' -h   print this help on stdout, then exit.', //
     & ' -V   print version number on stdout, then exit.', / )
 2003 FORMAT ( 'AUTHOR:', //,
     & 'Joerg Warnecke      (joerg@igpp.ucla.edu)', / )
C
 3000 FORMAT ( A, 1X, A )
C
 4000 FORMAT ( F12.6 )
      END
C*********************************************************************C
C
      INTEGER FUNCTION ILEN ( C )
C
C  returns the actual length of a character string
C
      IMPLICIT NONE
C
      CHARACTER          C*(*)
C
      ILEN = LEN(C)
      DO WHILE ((ILEN.GT.0).AND.(ICHAR(C(ILEN:ILEN)).LE.32))
        ILEN = ILEN - 1
      END DO
C
      RETURN
      END
C*******************************************************************C
C
      SUBROUTINE ORB_READ ( UNIT, IERR, STRING, NUM, MJDB, MJDE )
C
C  reads an orbit file entry from the specified unit,
C  returns ierr > 0 on error, or ierr < 0 on EOF,
C  else (ierr = 0) it returns the entry, its number of records,
C  and its time of validation (MJDB to MJDE)
C
      IMPLICIT NONE
C
      INTEGER           ERR
      PARAMETER        (ERR=0)
C
      INTEGER           UNIT, IERR, NUM, SCID, RECID, MORE
      CHARACTER*80      STRING(*)
      DOUBLE PRECISION  MJDB, MJDE
C
      READ (UNIT,1000,IOSTAT=IERR) STRING(1)
      IF (IERR.EQ.0) THEN
        READ (STRING(1)(1:3),1001,IOSTAT=IERR) SCID
        READ (UNIT,1000,IOSTAT=IERR) STRING(2)
        IF (IERR.EQ.0) THEN
          READ (STRING(2)(04:15),1002) MJDB
          READ (STRING(2)(16:27),1002) MJDE
        END IF
      END IF
C      
      IF ((IERR.EQ.0).AND.(SCID.GT.0).AND.(SCID.LE.4)) THEN
        NUM = 2
        MORE = 1
      ELSE
        NUM = 0
        MORE = 0
      END IF
C
      DO WHILE (MORE.GT.0)
        MORE = MORE - 1
        NUM = NUM + 1
        READ (UNIT,1000,IOSTAT=IERR) STRING(NUM)
        IF (IERR.EQ.0) THEN
          READ (STRING(NUM)(1:3),1001,IOSTAT=IERR) RECID
          IF (IERR.EQ.0) THEN
            IF (RECID.GT.100) MORE = MOD(RECID,100)
          ELSE
            MORE = 0
          END IF
        ELSE
          MORE = 0
        END IF
      END DO

C     IF (STRING(1)(1:2).EQ.'  ') STRING(1)(1:2) = '00'
      RETURN
C
 1000 FORMAT ( A )
 1001 FORMAT ( I3 )
 1002 FORMAT ( F12.6 )
      END
C*******************************************************************C
C
      LOGICAL FUNCTION ORB_NEWER ( STRING1, STRING2 )
C
C  determines whether the orbit file entry STRING1(*) is newer or has
C  higher priority than STRING2(*)
C
      IMPLICIT NONE
C
      CHARACTER*80      STRING1(*), STRING2(*)
      DOUBLE PRECISION  MJDC1, MJDC2
C
      ORB_NEWER = .FALSE.
      IF ((STRING1(1)(6:6).EQ.'R').AND.(STRING2(1)(6:6).EQ.'P')) THEN
        ORB_NEWER = .TRUE.
      ELSE
        CALL MJD_STR ( MJDC1, STRING1(1)(9:28), 0 )
        CALL MJD_STR ( MJDC2, STRING2(1)(9:28), 0 )
        ORB_NEWER = (MJDC1.GT.MJDC2)
      END IF
C
      RETURN
      END
C*******************************************************************C
C
      SUBROUTINE ORB_WRITE ( UNIT, STRING, NUM, IERR, MJD )
C
C  writes an orbit file entry to the specified unit,
C  returns ierr > 0 on error,
C  or ierr = 0 and the validation end time of the written record.
C
      IMPLICIT NONE
C
      INTEGER           UNIT, NUM, IERR, I, L, ILEN
      CHARACTER*80      STRING(*)
      DOUBLE PRECISION  MJD
C
      DO I = 1, NUM
        L = ILEN(STRING(I))
        WRITE (UNIT,1000,IOSTAT=IERR,ERR=999) STRING(I)(1:L)
      END DO
      READ (STRING(2)(16:27),1001) MJD
C
 999  CONTINUE
      RETURN
C
 1000 FORMAT ( A )
 1001 FORMAT ( F12.6 )
      END
C*******************************************************************C
